/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgReaderService;
import com.zkteco.zkbiosecurity.psg.vo.PsgReaderItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiReaderItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/psgReader"})
@Api(tags={"PsgReader"}, description="psg reader")
public class PsgApiReaderController {
    @Autowired
    private PsgReaderService psgReaderService;

    @ApiOperation(value="Get Psg Reader Info By Id", notes="Return Psg Reader Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getById"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getReaderById(@RequestParam(name="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ApiResultMessage.message((int)-263, (String)I18nUtil.i18nCode((String)"common_api_readerIdNotNull", (Object[])new Object[0]));
        }
        PsgReaderItem psgReaderItem = this.psgReaderService.getItemById(id);
        if (psgReaderItem == null) {
            return ApiResultMessage.message((int)-264, (String)I18nUtil.i18nCode((String)"common_api_readerNotExist", (Object[])new Object[0]));
        }
        PsgApiReaderItem psgApiReaderItem = PsgApiReaderItem.createApiReader((PsgReaderItem)psgReaderItem);
        return ApiResultMessage.successMessage((Object)psgApiReaderItem);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Psg Readers", notes="Return Psg Reader List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageNotNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        ArrayList psgApiReaderItemList = new ArrayList();
        Pager pager = this.psgReaderService.getItemsByPage((BaseItem)new PsgReaderItem(), pageNo - 1, pageSize.intValue());
        List psgReaderItemList = pager.getData();
        if (!psgReaderItemList.isEmpty()) {
            psgReaderItemList.forEach(psgReaderItem -> {
                PsgApiReaderItem psgApiReaderItem = PsgApiReaderItem.createApiReader((PsgReaderItem)psgReaderItem);
                if (psgApiReaderItem != null) {
                    psgApiReaderItemList.add(psgApiReaderItem);
                }
            });
        }
        return ApiResultMessage.successMessage(psgApiReaderItemList);
    }
}

