/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiLevelItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/psgLevel"})
@Api(tags={"psgLevel"}, description="psg level")
public class PsgApiLevelController {
    private static final Logger log = LoggerFactory.getLogger(PsgApiLevelController.class);
    @Autowired
    private PsgLevelService psgLevelService;

    @ApiOperation(value="Get PsgLevel By Id", notes="Return PsgLevel Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getById/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getById(@PathVariable(required=false) String id) {
        PsgLevelItem psgLevel = this.psgLevelService.getItemById(id);
        PsgApiLevelItem psgApiLevelItem = PsgApiLevelItem.createApiLevel((PsgLevelItem)psgLevel);
        return ApiResultMessage.successMessage((Object)psgApiLevelItem);
    }

    @ApiOperation(value="Get PsgLevel By Name", notes="Return PsgLevel Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getByName/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getByName(@PathVariable String name) {
        PsgLevelItem psgLevelItem = this.psgLevelService.getItemByName(name);
        PsgApiLevelItem psgApiLevelItem = PsgApiLevelItem.createApiLevel((PsgLevelItem)psgLevelItem);
        return ApiResultMessage.successMessage((Object)psgApiLevelItem);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get PsgLevel List", notes="Return PsgLevel List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage rs = new ApiResultMessage();
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.failedMessage((int)-90);
        }
        ArrayList apiPsgLevels = new ArrayList();
        List psgLevelItemList = this.psgLevelService.getItemsByPage((BaseItem)new PsgLevelItem(), pageNo - 1, pageSize.intValue()).getData();
        if (!psgLevelItemList.isEmpty()) {
            psgLevelItemList.forEach(psgLevelItem -> {
                PsgApiLevelItem psgApiLevelItem = PsgApiLevelItem.createApiLevel((PsgLevelItem)psgLevelItem);
                if (psgApiLevelItem != null) {
                    apiPsgLevels.add(psgApiLevelItem);
                }
            });
        }
        rs.setData(apiPsgLevels);
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/syncPerson"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Sync Person Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage syncPerson(@RequestParam(name="pin") String pin, @RequestParam(name="levelIds") String levelIds) {
        ApiResultMessage rs = null;
        try {
            rs = this.psgLevelService.syncApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api psgLevel/syncPerson error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Delete Person Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage deleteLevel(@RequestParam String pin, @RequestParam String levelIds) {
        ApiResultMessage rs = null;
        try {
            rs = this.psgLevelService.deleteApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api psgLevel/deleteLevel error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/syncLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Sync Level", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage syncLevel(@RequestParam(name="levelId") String levelId) {
        ApiResultMessage rs = null;
        try {
            rs = this.psgLevelService.syncApiLevel(levelId);
        }
        catch (Exception e) {
            log.error("api psgLevel/syncLevel error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

