/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiGateItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiGateStateItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/psgGate"})
@Api(tags={"PsgGate"}, description="psg gate")
public class PsgApiGateController {
    private static final Logger log = LoggerFactory.getLogger(PsgApiGateController.class);
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgDeviceService psgDeviceService;

    @ApiOperation(value="Get Gate By Id", notes="Return Gate Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getById"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getGateById(@RequestParam(name="id", required=false) String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"psg_api_gateIdNotNull", (Object[])new Object[0]));
        }
        ApiResultMessage rs = ApiResultMessage.successMessage();
        PsgGateItem psgGateItem = this.psgGateService.getItemById(id);
        if (psgGateItem != null) {
            rs.setData((Object)PsgApiGateItem.createApiGate((PsgGateItem)psgGateItem));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Gate List", notes="Return Gate List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageNotNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        ArrayList apiGateItemList = new ArrayList();
        Pager pager = this.psgGateService.getItemsByPage((BaseItem)new PsgGateItem(), pageNo - 1, pageSize.intValue());
        List psgGateItemList = pager.getData();
        if (!psgGateItemList.isEmpty()) {
            psgGateItemList.forEach(psgGateItem -> {
                PsgApiGateItem psgApiGateItem = PsgApiGateItem.createApiGate((PsgGateItem)psgGateItem);
                if (psgApiGateItem != null) {
                    apiGateItemList.add(psgApiGateItem);
                }
            });
        }
        return ApiResultMessage.successMessage(apiGateItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteOpenById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Open By Id", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteOpenById(@RequestParam(name="gateId", required=false) String gateId, @RequestParam(name="openType", required=false) Short openType) {
        if (StringUtils.isBlank((CharSequence)gateId)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"psg_api_gateIdNotNull", (Object[])new Object[0]));
        }
        if (openType == null) {
            return ApiResultMessage.message((int)-265, (String)I18nUtil.i18nCode((String)"psg_api_openGateTypeNotNull", (Object[])new Object[0]));
        }
        String type = this.getOpenTypeStr(openType);
        if (StringUtils.isBlank((CharSequence)type)) {
            return ApiResultMessage.message((int)-266, (String)I18nUtil.i18nCode((String)"psg_api_openTypeIncorrect", (Object[])new Object[0]));
        }
        Map dataMap = this.psgRTMonitorService.operateGate(type, gateId);
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/remoteOpenByName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Remote Open By Name", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage remoteOpenByName(@RequestParam(name="gateName", required=false) String gateName, @RequestParam(name="openType", required=false) Short openType) {
        if (StringUtils.isBlank((CharSequence)gateName)) {
            return ApiResultMessage.message((int)-46, (String)I18nUtil.i18nCode((String)"psg_api_gateNameNotNull", (Object[])new Object[0]));
        }
        if (openType == null) {
            return ApiResultMessage.message((int)-265, (String)I18nUtil.i18nCode((String)"psg_api_openGateTypeNotNull", (Object[])new Object[0]));
        }
        PsgGateItem psgGateItem = this.psgGateService.getItemByName(gateName);
        if (psgGateItem == null) {
            return ApiResultMessage.message((int)-47, (String)I18nUtil.i18nCode((String)"psg_api_gateNotExist", (Object[])new Object[0]));
        }
        String type = this.getOpenTypeStr(openType);
        if (StringUtils.isBlank((CharSequence)type)) {
            return ApiResultMessage.message((int)-266, (String)I18nUtil.i18nCode((String)"psg_api_openTypeIncorrect", (Object[])new Object[0]));
        }
        Map dataMap = this.psgRTMonitorService.operateGate(type, psgGateItem.getId());
        if (dataMap == null) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return this.dealResultData(dataMap);
    }

    @ResponseBody
    @RequestMapping(value={"/allGateState"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Gates State", notes="Return Gates State", response=ApiResultMessage.class)
    public ApiResultMessage getAllGateState() {
        List psgDeviceItemList = this.psgDeviceService.getByCondition(new PsgDeviceItem());
        HashMap devMap = Maps.newHashMap();
        if (!psgDeviceItemList.isEmpty()) {
            psgDeviceItemList.forEach(psgDeviceItem -> devMap.put(psgDeviceItem.getSn(), psgDeviceItem));
        }
        ArrayList<PsgApiGateStateItem> apiGateStateItemList = new ArrayList<PsgApiGateStateItem>();
        JSONObject devState = (JSONObject)this.psgRTMonitorService.getDevStateData(null).getData();
        JSONArray stateArray = devState.getJSONArray("gateState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (int i = 0; i < stateArray.size(); ++i) {
                JSONObject gate = stateArray.getJSONObject(i);
                PsgApiGateStateItem apiGateStateItem = this.buildApiGateState(gate);
                PsgDeviceItem psgDeviceItem2 = (PsgDeviceItem)devMap.get(gate.getString("devSn"));
                if (psgDeviceItem2 != null) {
                    apiGateStateItem.setDeviceId(psgDeviceItem2.getId());
                }
                apiGateStateItemList.add(apiGateStateItem);
            }
        }
        return ApiResultMessage.successMessage(apiGateStateItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/gateStateBySn"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Gate State By Sn", notes="Return Gate State", response=ApiResultMessage.class)
    public ApiResultMessage gateStateBySn(@RequestParam(name="deviceSn", required=false) String deviceSn) {
        if (StringUtils.isBlank((CharSequence)deviceSn)) {
            return ApiResultMessage.message((int)-48, (String)I18nUtil.i18nCode((String)"common_api_devSnNotNull", (Object[])new Object[0]));
        }
        ApiResultMessage rs = this.psgRTMonitorService.getGateStateBySn(deviceSn);
        ArrayList<PsgApiGateStateItem> apiGateStateItemList = new ArrayList<PsgApiGateStateItem>();
        if (rs.getData() != null) {
            PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemByDevSn(deviceSn);
            JSONArray gateState = (JSONArray)rs.getData();
            for (int i = 0; i < gateState.size(); ++i) {
                JSONObject gate = gateState.getJSONObject(i);
                PsgApiGateStateItem apiGateStateItem = this.buildApiGateState(gate);
                apiGateStateItem.setDeviceId(psgDeviceItem.getId());
                apiGateStateItemList.add(apiGateStateItem);
            }
        } else {
            return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"common_api_devSnNotExist", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage(apiGateStateItemList);
    }

    @ResponseBody
    @RequestMapping(value={"/gateStateById"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Gate State By Id", notes="Return Gate State", response=ApiResultMessage.class)
    public ApiResultMessage gateStateById(@RequestParam(name="gateId", required=false) String gateId) {
        if (StringUtils.isBlank((CharSequence)gateId)) {
            return ApiResultMessage.message((int)-44, (String)I18nUtil.i18nCode((String)"psg_api_gateIdNotNull", (Object[])new Object[0]));
        }
        JSONArray gateState = (JSONArray)this.psgRTMonitorService.getGateState(gateId).getData();
        ArrayList<PsgApiGateStateItem> apiGateStateItemList = new ArrayList<PsgApiGateStateItem>();
        if (Objects.nonNull(gateState) && gateState.size() > 0) {
            PsgGateItem psgGateItem = this.psgGateService.getItemById(gateId);
            for (int i = 0; i < gateState.size(); ++i) {
                JSONObject gate = gateState.getJSONObject(i);
                PsgApiGateStateItem apiGateStateItem = this.buildApiGateState(gate);
                apiGateStateItem.setDeviceId(psgGateItem.getDeviceId());
                apiGateStateItemList.add(apiGateStateItem);
            }
        } else {
            return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"common_api_devSnNotExist", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage(apiGateStateItemList);
    }

    private PsgApiGateStateItem buildApiGateState(JSONObject gate) {
        PsgApiGateStateItem apiGateStateItem = new PsgApiGateStateItem();
        int gateState = gate.getIntValue("gateState");
        int connect = gate.getIntValue("connect");
        int relay = gate.getIntValue("relay");
        int alarm = gate.getIntValue("alarm");
        apiGateStateItem.setId(gate.getString("id"));
        apiGateStateItem.setName(gate.getString("name"));
        apiGateStateItem.setGateState(gateState + "");
        apiGateStateItem.setAlarm(alarm + "");
        apiGateStateItem.setRelay(relay + "");
        apiGateStateItem.setConnect(String.valueOf(connect));
        return apiGateStateItem;
    }

    private String getOpenTypeStr(Short openType) {
        String type = "";
        if (openType == 1) {
            type = "openInGate";
        } else if (openType == 2) {
            type = "openOutGate";
        }
        return type;
    }

    private ApiResultMessage dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        if ("true".equals(dataMap.get("notExistDev"))) {
            return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("offline"))) {
            return ApiResultMessage.message((int)-103, (String)I18nUtil.i18nCode((String)"common_api_devOfflineOrDisabled", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("notSupport"))) {
            return ApiResultMessage.message((int)-104, (String)I18nUtil.i18nCode((String)"psg_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("faile"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (!Objects.isNull(resultMap) && Integer.parseInt((String)resultMap.get("result")) >= 0) continue;
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
            }
        }
        return ApiResultMessage.successMessage();
    }
}

