/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiDeviceItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/psgDevice"})
@Api(tags={"PsgDevice"}, description="psg device")
public class PsgApiDeviceController {
    private static final Logger log = LoggerFactory.getLogger(PsgApiDeviceController.class);
    @Autowired
    private PsgDeviceService psgDeviceService;

    @ApiOperation(value="Get Psg Device Info By Sn", notes="Return Psg Device Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/getBySn"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getBySn(@RequestParam(name="sn", required=false) String sn) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        if (StringUtils.isBlank((CharSequence)sn)) {
            return ApiResultMessage.message((int)-48, (String)I18nUtil.i18nCode((String)"common_api_devSnNotNull", (Object[])new Object[0]));
        }
        PsgDeviceItem psgDeviceItem = this.psgDeviceService.getItemByDevSn(sn);
        if (psgDeviceItem != null) {
            PsgApiDeviceItem psgApiDeviceItem = PsgApiDeviceItem.createPsgDevice((PsgDeviceItem)psgDeviceItem);
            rs.setData((Object)psgApiDeviceItem);
            return rs;
        }
        return ApiResultMessage.message((int)-102, (String)I18nUtil.i18nCode((String)"common_api_devSnNotExist", (Object[])new Object[0]));
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Psg Devices", notes="Return Psg Device List", response=ApiResultMessage.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="Page Index", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="One Page Size", required=true, dataType="int", paramType="query")})
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        ArrayList psgApiDeviceItemList = new ArrayList();
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageNotNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        Pager pager = this.psgDeviceService.getItemsByPage((BaseItem)new PsgDeviceItem(), pageNo - 1, pageSize.intValue());
        List psgDeviceItemList = pager.getData();
        if (!psgDeviceItemList.isEmpty()) {
            psgDeviceItemList.forEach(psgDeviceItem -> psgApiDeviceItemList.add(PsgApiDeviceItem.createPsgDevice((PsgDeviceItem)psgDeviceItem)));
        }
        return ApiResultMessage.successMessage(psgApiDeviceItemList);
    }
}

