/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.service.EleTimeSegService;
import com.zkteco.zkbiosecurity.ele.vo.EleTimeSegItem;
import com.zkteco.zkbiosecurity.guard.foldex.utils.FoldexUtil;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=60)
public class EleInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private EleTimeSegService eleTimeSegService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Value(value="${system.offlineEle.support:false}")
    private boolean isSupportOfflineEle;

    public void run(String ... args) throws Exception {
        AuthPermissionItem eleMenu;
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("EleInit");
        if (!alreadyInit && (eleMenu = this.authPermissionService.getItemByCode("Ele")) != null) {
            alreadyInit = true;
            this.baseSysParamService.setAlreadyInitModule("EleInit");
        }
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initEleTimeSeg();
            this.initEleDictionary();
            this.initEleParams();
            this.initLicenseView();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("EleInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Ele", "ele_module", "ele", "system", "true", Integer.valueOf(6));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("EleDeviceManger", "ele_dev_device", "ele:device:manager", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("eleDevice.do");
        subMenuItem1.setImg("ele_device.png");
        subMenuItem1.setImgHover("ele_device_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("EleDevice", "common_leftMenu_device", "ele:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("EleDeviceRefresh", "common_op_refresh", "ele:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceAdd", "common_op_new", "ele:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceEdit", "common_op_edit", "ele:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceDel", "common_op_del", "ele:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceExport", "common_op_export", "ele:device:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceSearchDev", "common_dev_searchDev", "ele:device:searchDev", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceEnable", "common_enable", "ele:device:enable", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceDisable", "common_disable", "ele:device:disable", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceSyncAllData", "common_dev_syncAllDataToDev", "ele:device:syncAllData", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceUpgradeFirmware", "common_dev_upgradeFirmware", "ele:device:upgradeFirmware", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceRebootDevice", "common_dev_reboot", "ele:device:rebootDevice", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceGetOptFromDev", "common_dev_getDevOpt", "ele:device:getOptFromDev", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceUploadUserInfo", "common_dev_getPersonInfo", "ele:device:uploadUserInfo", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceUploadEleLogs", "common_dev_getTrans", "ele:device:uploadEleLogs", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceQueryDevUsage", "ele_dev_queryDevCapacity", "ele:device:queryDevUsage", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceSyncTime", "common_dev_syncTime", "ele:device:syncTime", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceChangeDevIp", "common_dev_modifyIPAddress", "ele:device:changeDevIp", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceChangeDevPwd", "common_dev_modifyCommPwd", "ele:device:changeDevPwd", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceUpdateRs485Addr", "ele_dev_modifyRS485Addr", "ele:device:updateRs485Addr", "button", "true", Integer.valueOf(19));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceChangeDevMThreshold", "common_dev_modifyFPThreshold", "ele:device:changeDevMThreshold", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceSetExtendParam", "ele_dev_setExtendParam", "ele:device:updateDevExtendParam", "button", "true", Integer.valueOf(21));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceBindChannel", "common_vid_bindOrUnbindChannel", "ele:device:bindChannel", "button", "true", Integer.valueOf(22));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDeviceClearCmd", "common_devMonitor_clearCmdCache", "ele:device:clearCmdCache", "button", "true", Integer.valueOf(23));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleExtBoard", "ele_extBoard", "ele:extBoard", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleExtBoard.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleExtBoardRefresh", "common_op_refresh", "ele:extBoard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExtBoardAdd", "common_op_new", "ele:extBoard:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExtBoardDel", "common_op_del", "ele:extBoard:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleReader", "common_leftMenu_reader", "ele:reader", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleReader.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleReaderRefresh", "common_op_refresh", "ele:reader:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleReaderEdit", "common_op_edit", "ele:reader:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleFloor", "ele_floor_entity", "ele:floor", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleFloor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleFloorRefresh", "common_op_refresh", "ele:floor:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorEdit", "common_op_edit", "ele:floor:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorOpenFloor", "ele_rtm_open", "ele:floor:openFloor", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorCloseFloor", "ele_rtm_close", "ele:floor:closeFloor", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorNormalOpenFloor", "ele_eventNo_205", "ele:floor:normalOpenFloor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorEnableNormalOpenFloor", "common_rtMonitor_enableIntradayTZ", "ele:floor:enableNormalOpenFloor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFloorDisableNormalOpenFloor", "common_rtMonitor_disableIntradayTZ", "ele:floor:disableNormalOpenFloor", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleAuxIn", "common_leftMenu_auxIn", "ele:auxIn", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleAuxIn.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleAuxInRefresh", "common_op_refresh", "ele:auxIn:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleAuxInEdit", "common_op_edit", "ele:auxIn:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleDeviceEvent", "common_leftMenu_event", "ele:deviceEvent", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleDeviceEvent.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleDeviceEventRefresh", "common_op_refresh", "ele:deviceEvent:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleRTMonitor", "common_leftMenu_rtMonitor", "ele:rtMonitor", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleRTMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleRTMonitorOpenFloor", "ele_rtm_open", "ele:rtMonitor:openFloor", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleRTMonitorCloseFloor", "ele_rtm_close", "ele:rtMonitor:closeFloor", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleRTMonitorCancelEmergency", "ele_rtm_cancelEmergency", "ele:rtMonitor:cancelEmergency", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("EleControl", "ele_leftMenu_eleRule", "ele:persCard:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("elePersCard.do");
        subMenuItem1.setImg("ele_control.png");
        subMenuItem1.setImgHover("ele_control_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EleTimeSeg", "common_leftMenu_timeZone", "ele:timeSeg", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleTimeSeg.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleTimeSegRefresh", "common_op_refresh", "ele:timeSeg:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTimeSegAdd", "common_op_new", "ele:timeSeg:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTimeSegDel", "common_op_del", "ele:timeSeg:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTimeSegEdit", "common_op_edit", "ele:timeSeg:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleHoliday", "common_leftMenu_holiday", "ele:holiday", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleHoliday.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleHolidayRefresh", "common_op_refresh", "ele:holiday:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleHolidayAdd", "common_op_new", "ele:holiday:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleHolidayEdit", "common_op_edit", "ele:holiday:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleHolidayDel", "common_op_del", "ele:holiday:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleLevel", "ele_leftMenu_level", "ele:level", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleLevelRefresh", "common_op_refresh", "ele:level:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleLevelAdd", "common_op_new", "ele:level:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleLevelEdit", "common_op_edit", "ele:level:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleLevelDel", "common_op_del", "ele:level:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleLevelDelFloor", "ele_level_delFloor", "ele:level:delFloor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleLevelAddFloor", "ele_level_addFloor", "ele:level:addFloor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("ElePersonLevelByLevel", "common_leftMenu_levelSetByLevel", "ele:personLevelByLevel", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("elePersonLevelByLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByLevelRefresh", "common_op_refresh", "ele:personLevelByLevel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByLevelAddPerson", "pers_common_addPerson", "ele:personLevelByLevel:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByLevelDelPerson", "pers_common_delPerson", "ele:personLevelByLevel:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("ElePersonLevelByPerson", "common_leftMenu_levelSetByPerson", "ele:personLevelByPerson", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("elePersonLevelByPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByPersonRefresh", "common_op_refresh", "ele:personLevelByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByPersonSetEleParams", "pers_person_eleSetting", "ele:personLevelByPerson:setEleParams", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByPersonAddLevel", "common_level_addPersonLevel", "ele:personLevelByPerson:addLevel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByPersonDelLevel", "common_level_delPersonLevel", "ele:personLevelByPerson:delLevel", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("ElePersonLevelByDept", "common_leftMenu_levelSetByDept", "ele:personLevelByDept", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("elePersonLevelByDept.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByDeptRefresh", "common_op_refresh", "ele:personLevelByDept:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByDeptAddLevel", "common_level_addDefaultLevel", "ele:personLevelByDept:addLevel", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("ElePersonLevelByDeptDelLevel", "common_level_delDefaultLevel", "ele:personLevelByDept:delLevel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleDirectSelectionSet", "ele_leftMenu_directSelectionSet", "ele:directSelection", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleDirectSelection.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleDirectSelectionByPersonRefresh", "common_op_refresh", "ele:directSelectionByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDirectSelectionByPersonSetEleParams", "pers_person_eleSetting", "ele:directSelectionByPerson:setEleParams", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDirectSelectionAddDirectSelection", "ele_directSelection_add", "ele:directSelection:addDirectSelection", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDirectSelectionEdit", "common_op_edit", "ele:directSelection:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleDirectSelectionDel", "common_op_del", "ele:directSelection:delPersonDirectSelection", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleGlobalLinkage", "ele_leftMenu_globalLinkage", "ele:globalLinkage", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleGlobalLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageRefresh", "common_op_refresh", "ele:globalLinkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageAdd", "common_op_new", "ele:globalLinkage:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageEdit", "common_op_edit", "ele:globalLinkage:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageDel", "common_op_del", "ele:globalLinkage:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageEnable", "common_enable", "ele:globalLinkage:enable", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageDisable", "common_disable", "ele:globalLinkage:disable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageAddPerson", "pers_common_addPerson", "ele:globalLinkage:addPerson", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleGlobalLinkageDelPerson", "pers_common_delPerson", "ele:globalLinkage:delPerson", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleParams", "common_leftMenu_paramSet", "ele:params", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleParamRefresh", "common_op_refresh", "ele:param:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleParamEdit", "common_op_edit", "ele:param:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        if (this.isSupportOfflineEle) {
            subMenuItem1 = new AuthPermissionItem("EleOfflineElevator", "ele_leftMenu_offlineElevator", "ele:offline:elevator", "menu", "false", Integer.valueOf(3));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("ele_offline.png");
            subMenuItem1.setImgHover("ele_offline_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
            subMenuItem = new AuthPermissionItem("EleCardBusiness", "ele_leftMenu_cardBusiness", "ele:card:business", "menu", "true", Integer.valueOf(1));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("eleCardBusiness.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("EleCardBusinessInitCard", "pers_card_init", "ele:cardBusiness:initCard", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("EleCardBusinessIssueCard", "pers_issueCard_entity", "ele:cardBusiness:issueCard", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("EleCardBusinessLossCard", "pers_lossCard_entity", "ele:cardBusiness:lossCard", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("EleCardBusinessRevertCard", "pers_revertCard_entity", "ele:cardBusiness:revertCard", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("EleCard", "ele_leftMenu_cardManage", "ele:card", "menu", "true", Integer.valueOf(2));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("eleCard.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("EleCardRefresh", "common_op_refresh", "ele:card:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("EleCardExport", "common_op_export", "ele:card:export", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem1 = new AuthPermissionItem("EleReports", "ele_leftMenu_eleReports", "ele:reports:manager", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("eleTransaction.do");
        subMenuItem1.setImg("comm_reports.png");
        subMenuItem1.setImgHover("comm_reports_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EleTransaction", "common_leftMenu_transaction", "ele:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleTransactionRefresh", "common_op_refresh", "ele:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTransactionDel", "common_op_clearData", "ele:transaction:clearData", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTransactionExport", "common_op_export", "ele:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (this.isSupportOfflineEle) {
            subButtonItem = new AuthPermissionItem("EleTransactionImportUSBRecord", "ele_import_importUSBRecord", "ele:transaction:importUSBRecord", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("EleAlarmTransaction", "common_leftMenu_exceptTransaction", "ele:alarmTransaction", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleAlarmTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleAlarmTransactionRefresh", "common_op_refresh", "ele:alarmTransaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleAlarmTransactionDel", "common_op_del", "ele:alarmTransaction:clearData", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleAlarmTransactionExport", "common_op_export", "ele:alarmTransaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleTransactionByFloor", "ele_leftMenu_searchByFloor", "ele:transactionByFloor", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleTransactionByFloor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleTransactionByFloorRefresh", "common_op_refresh", "ele:transactionByFloor:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTransactionByFloorExport", "common_op_export", "ele:transactionByFloor:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleTransactionByPerson", "common_leftMenu_searchByPerson", "ele:transactionByPerson", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleTransactionByPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleTransactionByPersonRefresh", "common_op_refresh", "ele:transactionByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleTransactionByPersonExport", "common_op_export", "ele:transactionByPerson:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != subMenuItem) {
            subButtonItem = new AuthPermissionItem("PersPersonEleEdit", "pers_person_eleSet", "pers:person:eleEdit", "button", "true", Integer.valueOf(102));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("EleFirstInLastOut", "ele_leftMenu_firstInLastOut", "ele:firstInLastOut", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleFirstInLastOut.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleFirstInLastOutRefresh", "common_op_refresh", "ele:firstInLastOut:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFirstInLastOutClearData", "common_op_clearData", "ele:firstInLastOut:clearData", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleFirstInLastOutExport", "common_op_export", "ele:firstInLastOut:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("EleIntegration", "ele_leftMenu_integration", "ele:integration", "menu", "true", Integer.valueOf(5));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("eleIntegration.do");
        subMenuItem1.setImg("ele_elevatorIntegration.png");
        subMenuItem1.setImgHover("ele_elevatorIntegration_over.png");
        this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EleServiceConfig", "ele_leftMenu_serviceConfig", "ele:serviceConfig", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleServiceConfig.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigRefresh", "common_op_refresh", "ele:serviceConfig:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigAdd", "common_op_new", "ele:serviceConfig:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigEdit", "common_op_edit", "ele:serviceConfig:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigDel", "common_op_del", "ele:serviceConfig:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigExternalGlobalMask", "ele_mask_externalGlobalMask", "ele:serviceConfig:externalGlobalMask", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleServiceConfigInternalGlobalMask", "ele_mask_internalGlobalMask", "ele:serviceConfig:internalGlobalMask", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleIntegrationDevice", "ele_leftMenu_integrationDevice", "ele:integrationDevice", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleIntegrationDevice.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleIntegrationDeviceRefresh", "common_op_refresh", "ele:integrationDevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleIntegrationDeviceAdd", "common_op_new", "ele:integrationDevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleIntegrationDeviceDel", "common_op_del", "ele:integrationDevice:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleElevatorGroup", "ele_leftMenu_elevatorGroup", "ele:elevatorGroup", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleElevatorGroup.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleElevatorGroupRefresh", "common_op_refresh", "ele:elevatorGroup:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorGroupAdd", "common_op_add", "ele:elevatorGroup:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorGroupEdit", "common_op_edit", "ele:elevatorGroup:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorGroupDel", "common_op_del", "ele:elevatorGroup:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorGroupAddElevator", "ele_elevatorGroup_addElevator", "ele:elevatorGroup:addElevator", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorEdit", "ele_elevator_edit", "ele:elevator:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleElevatorDel", "ele_elevator_del", "ele:elevator:del", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleExternalReader", "ele_leftMenu_externalReader", "ele:externalReader", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleExternalReader.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderRefresh", "common_op_refresh", "ele:externalReader:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderAdd", "common_op_new", "ele:externalReader:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderEdit", "common_op_edit", "ele:externalReader:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderDel", "common_op_del", "ele:externalReader:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderSpecificMask", "ele_mask_externalSpecificMask", "ele:externalReader:specificMask", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleExternalReaderClearMask", "ele_mask_clearSpecificMask", "ele:externalReader:clearMask", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleInternalReader", "ele_leftMenu_internalReader", "ele:internalReader", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleInternalReader.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderRefresh", "common_op_refresh", "ele:internalReader:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderAdd", "common_op_new", "ele:internalReader:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderEdit", "common_op_edit", "ele:internalReader:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderDel", "common_op_del", "ele:internalReader:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderSpecificMask", "ele_mask_internalSpecificMask", "ele:internalReader:specificMask", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleInternalReaderClearMask", "ele_mask_clearSpecificMask", "ele:internalReader:clearMask", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EleOperationLog", "ele_leftMenu_operationLog", "ele:operationLog", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("eleOperationLog.do");
        this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EleOperationLogRefresh", "common_op_refresh", "ele:operationLog:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EleOperationLogClearData", "common_op_clearData", "ele:operationLog:clearData", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
    }

    private void initEleTimeSeg() {
        EleTimeSegItem timeSegItem = new EleTimeSegItem(I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), true, "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00", "23:59:00", "00:00:00", "00:00:00", "00:00:00", "00:00:00");
        timeSegItem.setInitFlag(Boolean.valueOf(true));
        this.eleTimeSegService.initData(timeSegItem);
    }

    private void initEleDictionary() {
        BaseDictionaryItem baseDictionaryItem = null;
        baseDictionaryItem = new BaseDictionaryItem("eleCommStatus", I18nUtil.i18nCode((String)"common_commStatus", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"ele_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-28", "ele_commStatus_canNotClose", Integer.valueOf(0), baseDictionaryItem.getId()));
    }

    public void initEleParams() {
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        this.baseSysParamService.initData(new BaseSysParamItem("eleReportDataClean", values.toString(), "base_dataClean_eleTrans"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.downNewlog", "0", "\u5b9a\u65f6\u4e0b\u8f7d\u65b0\u8bb0\u5f55\u7684\u65f6\u95f4\u70b9"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.downNewLogExpression", "0 0 0 * * ?", "\u5b9a\u65f6\u4e0b\u8f7d\u65b0\u8bb0\u5f55\u65f6\u95f4\u70b9\u914d\u7f6e"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.personPhotoMaxHeight", "140", "\u5b9e\u65f6\u76d1\u63a7\u9875\u9762\u5f39\u51fa\u4eba\u5458\u7167\u7247\u5927\u5c0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.eventMaxLine", "50", "\u5b9e\u65f6\u4e8b\u4ef6\u671f\u671b\u663e\u793a\u7684\u6700\u591a\u6761\u6570"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.autoGetEventTime", "2", "\u8bbe\u7f6e\u81ea\u52a8\u83b7\u53d6\u4e8b\u4ef6\u8bb0\u5f55\u7ebf\u7a0b\u4f11\u7720\u65f6\u95f4\uff08\u5206\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.autoGetEventDev", "10", "\u81ea\u52a8\u83b7\u53d6\u51e0\u53f0\u8bbe\u5907\u7684\u4e8b\u4ef6\u8bb0\u5f55"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.eventInitializeLine", "0", "\u5b9e\u65f6\u76d1\u63a7\u4e8b\u4ef6\u521d\u59cb\u5316\u6761\u6570"));
        this.baseSysParamService.initData(new BaseSysParamItem("ele.deviceMode", "1", "\u8bbe\u5907\u6a21\u5f0f\uff1a1\u5728\u7ebf,2\u8131\u673a,3\u6df7\u5408"));
        if (this.isSupportOfflineEle) {
            this.baseSysParamService.initData(new BaseSysParamItem("ele.cardKey", FoldexUtil.encryptByRandomSey((String)"FFFFFFFF"), "\u5361\u5bc6\u94a5"));
            this.baseSysParamService.initData(new BaseSysParamItem("ele.cardOldKey", FoldexUtil.encryptByRandomSey((String)"FFFFFFFF"), "\u5361\u65e7\u5bc6\u94a5"));
            this.baseSysParamService.initData(new BaseSysParamItem("ele.offlineFlag", "false", "\u542f\u7528\u8131\u673a\u529f\u80fd"));
        }
    }

    private void initLicenseView() {
        this.baseSysParamService.initData(new BaseSysParamItem("eledcs.version", "true", "Elevator DCS License", Boolean.valueOf(true)));
        this.baseSysParamService.initData(new BaseSysParamItem("eledcsquantity.version", "true", "Elevator DCS Service Quantity", Boolean.valueOf(true)));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"ele");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("EleUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("EleUpgradeVersion", curVersion, "Ele Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

