/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ias.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.ias.service.IasDeviceService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=210)
public class IasInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(IasInit.class);
    @Autowired
    BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private IasDeviceService iasDeviceService;

    public void run(String ... strings) {
        try {
            boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("IasInit");
            if (!alreadyInit) {
                this.initAuthPermission();
                this.baseSysParamService.setAlreadyInitModule("IasInit");
            }
        }
        catch (Exception e) {
            log.error("IasInit Exception", (Throwable)e);
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Ias", "ias_module", "ias", "system", "true", Integer.valueOf(21));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem topMenuItem = new AuthPermissionItem("IasDeviceManage", "ias_leftMenu_iasDev", "ias:device:manage", "menu", "true", Integer.valueOf(1));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("ias_device.png");
        topMenuItem.setImgHover("ias_device_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("IasDevice", "common_leftMenu_device", "ias:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("IasDeviceRefresh", "common_op_refresh", "ias:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceAdd", "common_op_new", "ias:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceEdit", "common_op_edit", "ias:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceDel", "common_op_del", "ias:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceSetDateTime", "ias_device_operation_setDateTime", "ias:device:setDateTime", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUpdateDeviceInfo", "ias_device_operation_updateDeviceInfo", "ias:device:updateDeviceInfo", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IasPartition", "ias_leftMenu_partition", "ias:partition", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasPartition.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasPartitionRefresh", "common_op_refresh", "ias:partition:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPartitionEdit", "common_op_edit", "ias:partition:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPartitionArm", "ias_partitionArm", "ias:partition:arm", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPartitionDisarm", "ias_partition_disarm", "ias:partition:disarm", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPartitionSilenceBells", "ias_partition_silenceBells", "ias:partition:silenceBells", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IasPoint", "ias_leftMenu_point", "ias:point", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasPoint.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasPointRefresh", "common_op_refresh", "ias:point:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPointEdit", "common_op_edit", "ias:point:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPointBypass", "ias_point_bypass", "ias:point:bypass", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasPointUnBypass", "ias_point_unbypass", "ias:point:unBypass", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IasDeviceUser", "ias_leftMenu_deviceUser", "ias:deviceUser", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasDeviceUser.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUserRefresh", "common_op_refresh", "ias:deviceUser:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUserAdd", "common_op_new", "ias:deviceUser:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUserEdit", "common_op_edit", "ias:deviceUser:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUserUpdate", "ias_device_updateUser", "ias:deviceUser:updateUser", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasDeviceUserDel", "common_op_del", "ias:deviceUser:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IasLinkage", "ias_leftMenu_globalLinkage", "ias:linkage", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasLinkageRefresh", "common_op_refresh", "ias:linkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasLinkageAdd", "common_op_new", "ias:linkage:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasLinkageEdit", "common_op_edit", "ias:linkage:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasLinkageDel", "common_op_del", "ias:linkage:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("IasRTMonitorManage", "common_leftMenu_rtMonitor", "ias:rtMonitor:manage", "menu", "true", Integer.valueOf(2));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("ias_RTMonitor.png");
        topMenuItem.setImgHover("ias_RTMonitor_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("IasRTMonitor", "common_leftMenu_rtMonitor", "ias:rtMonitor", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasRTMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorArm", "ias_partitionArm", "ias:rtMonitor:arm", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorDisarm", "ias_partition_disarm", "ias:rtMonitor:disarm", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorDisAlarm", "ias_partition_disAlarm", "ias:rtMonitor:disAlarm", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorBypass", "ias_point_bypass", "ias:rtMonitor:bypass", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorUnByPass", "ias_point_unbypass", "ias:rtMonitor:unBypass", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorActive", "ias_output_active", "ias:rtMonitor:active", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasRTMonitorCancel", "ias_output_cancel", "ias:rtMonitor:inactive", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("IasRecordManage", "ias_leftMenu_record", "ias:record:manage", "menu", "true", Integer.valueOf(3));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("ias_report.png");
        topMenuItem.setImgHover("ias_report_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("IasEvent", "ias_leftMenu_eventRecord", "ias:event", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasEvent.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasEventRecordRefresh", "common_op_refresh", "ias:event:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasEventRecordDel", "common_op_clearData", "ias:event:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasEventRecordExport", "common_op_export", "ias:event:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("IasLinkageRecord", "ias_linkage_record", "ias:linkageRecord", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("iasLinkageRecord.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("IasLinkageRecordRefresh", "common_op_refresh", "ias:linkageRecord:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasLinkageRecordDel", "common_op_clearData", "ias:linkageRecord:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("IasLinkageRecordExport", "common_op_export", "ias:linkageRecord:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }
}

