/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;

@From(after="PARK_PAVILIO t LEFT JOIN PARK_ENTRANCE_AREA ea ON ea.ID = t.ENTRANCE_AREA_ID LEFT JOIN PARK_PARKING_AREA pa ON pa.ID = ea.PARKING_AREA_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=700, operates={@GridOperate(type="edit", permission="park:pavilio:edit", url="parkPavilio.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="park:pavilio:del", url="parkPavilio.do?del&names=(name)", label="common_op_del"), @GridOperate(type="custom", permission="park:pavilio:reset", click="parkPavilioReset", label="common_op_reset", showConvertor="showConvertor")})
public class ParkPavilioItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="park_pavilio_name", sortNo=1, width="150", columnType="edit", editPermission="park:pavilio:edit", editUrl="parkPavilio.do?edit")
    private String name;
    @Column(name="t.IP_ADDRESS")
    @GridColumn(label="park_pavilio_ipAddress", sortNo=2, width="150")
    private String ipAddress;
    @Column(name="ea.NAME")
    @GridColumn(label="park_pavilio_entranceArea", sortNo=3, width="150")
    private String entranceAreaName;
    @Column(name="pa.NAME")
    @GridColumn(label="park_parkingArea_name", sortNo=4, width="150")
    private String parkingAreaName;
    @Column(name="pa.ID")
    private String parkingAreaId;
    @Column(name="pa.AREATYPE")
    private Short parkingAreaType;
    @Column(name="ea.ID")
    private String entranceAreaId;
    @Column(name="t.TEMPORARY_CAR_FREE")
    private Short temporaryCarFree;
    @Column(name="t.REPLACEMENT")
    private Short replacement;
    @Column(name="t.OPENGAGEBYHAND_FLAG")
    private Short opengagebyhandFlag;
    @Column(name="t.TEMPCAR_QUICKOUT_FLAG")
    private Short tempcarQuickoutFlag;
    @Column(name="t.REVISE_CARNO_IN")
    private Short reviseCarnoIn;
    @Column(name="t.REVISE_CARNO_OUT")
    private Short reviseCarnoOut;
    @Column(name="t.CUSTOM_DISPLAY_PORT")
    private Integer customDisplayPort;
    @Column(name="t.WIDECHANNEL_FLAG")
    private Short widechannelFlag;
    @Column(name="t.ONECHANNEL_FLAG")
    private Short onechannelFlag;
    @Column(name="t.FINGER_VERIFICATIONFLAG")
    private Short fingerVerificationflag;
    @Column(name="t.CLIENT_MODE")
    @GridColumn(label="park_pavilio_clientMode", sortNo=10, width="120", format="0=park_pavilio_clientModeBS,1=park_pavilio_clientModeCS", showHeader="parkPavilioShowClientMode")
    private Short clientMode;
    @Column(name="t.REGISTRATION_CODE")
    private String registrationCode;
    @Column(name="t.ACTIVATION_STATE")
    @GridColumn(label="park_pvailio_state", sortNo=10, width="120", columnType="custom", convert="convertActivated", showHeader="parkPavilioShowClientMode")
    private Short activationState;
    @Column(name="t.COMMUNICATION_FLAG")
    @GridColumn(label="park_pavilio_communicationFlag", sortNo=11, width="120", columnType="custom", convert="convertActivated", showHeader="parkPavilioShowClientMode")
    private Short communicationFlag;
    @Column(name="t.PARKING_LOTINF_ID")
    private String parkingLotInfId;
    @GridColumn(label="park_parkingArea_parkingLotName", width="150")
    private String parkingLotInfName;
    @Condition(value="t.PARKING_LOTINF_ID", equalTag="in")
    private String parkingLotInfIdIn;

    public boolean showConvertor() {
        return ParkConstants.PAVILIO_CS.equals(this.clientMode) && ParkConstants.PAVILIO_ACTIVE.equals(this.activationState);
    }

    public ParkPavilioItem() {
    }

    public ParkPavilioItem(Boolean equals) {
        super(equals);
    }

    public ParkPavilioItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getEntranceAreaName() {
        return this.entranceAreaName;
    }

    public String getParkingAreaName() {
        return this.parkingAreaName;
    }

    public String getParkingAreaId() {
        return this.parkingAreaId;
    }

    public Short getParkingAreaType() {
        return this.parkingAreaType;
    }

    public String getEntranceAreaId() {
        return this.entranceAreaId;
    }

    public Short getTemporaryCarFree() {
        return this.temporaryCarFree;
    }

    public Short getReplacement() {
        return this.replacement;
    }

    public Short getOpengagebyhandFlag() {
        return this.opengagebyhandFlag;
    }

    public Short getTempcarQuickoutFlag() {
        return this.tempcarQuickoutFlag;
    }

    public Short getReviseCarnoIn() {
        return this.reviseCarnoIn;
    }

    public Short getReviseCarnoOut() {
        return this.reviseCarnoOut;
    }

    public Integer getCustomDisplayPort() {
        return this.customDisplayPort;
    }

    public Short getWidechannelFlag() {
        return this.widechannelFlag;
    }

    public Short getOnechannelFlag() {
        return this.onechannelFlag;
    }

    public Short getFingerVerificationflag() {
        return this.fingerVerificationflag;
    }

    public Short getClientMode() {
        return this.clientMode;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public Short getActivationState() {
        return this.activationState;
    }

    public Short getCommunicationFlag() {
        return this.communicationFlag;
    }

    public String getParkingLotInfId() {
        return this.parkingLotInfId;
    }

    public String getParkingLotInfName() {
        return this.parkingLotInfName;
    }

    public String getParkingLotInfIdIn() {
        return this.parkingLotInfIdIn;
    }

    public ParkPavilioItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkPavilioItem setName(String name) {
        this.name = name;
        return this;
    }

    public ParkPavilioItem setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public ParkPavilioItem setEntranceAreaName(String entranceAreaName) {
        this.entranceAreaName = entranceAreaName;
        return this;
    }

    public ParkPavilioItem setParkingAreaName(String parkingAreaName) {
        this.parkingAreaName = parkingAreaName;
        return this;
    }

    public ParkPavilioItem setParkingAreaId(String parkingAreaId) {
        this.parkingAreaId = parkingAreaId;
        return this;
    }

    public ParkPavilioItem setParkingAreaType(Short parkingAreaType) {
        this.parkingAreaType = parkingAreaType;
        return this;
    }

    public ParkPavilioItem setEntranceAreaId(String entranceAreaId) {
        this.entranceAreaId = entranceAreaId;
        return this;
    }

    public ParkPavilioItem setTemporaryCarFree(Short temporaryCarFree) {
        this.temporaryCarFree = temporaryCarFree;
        return this;
    }

    public ParkPavilioItem setReplacement(Short replacement) {
        this.replacement = replacement;
        return this;
    }

    public ParkPavilioItem setOpengagebyhandFlag(Short opengagebyhandFlag) {
        this.opengagebyhandFlag = opengagebyhandFlag;
        return this;
    }

    public ParkPavilioItem setTempcarQuickoutFlag(Short tempcarQuickoutFlag) {
        this.tempcarQuickoutFlag = tempcarQuickoutFlag;
        return this;
    }

    public ParkPavilioItem setReviseCarnoIn(Short reviseCarnoIn) {
        this.reviseCarnoIn = reviseCarnoIn;
        return this;
    }

    public ParkPavilioItem setReviseCarnoOut(Short reviseCarnoOut) {
        this.reviseCarnoOut = reviseCarnoOut;
        return this;
    }

    public ParkPavilioItem setCustomDisplayPort(Integer customDisplayPort) {
        this.customDisplayPort = customDisplayPort;
        return this;
    }

    public ParkPavilioItem setWidechannelFlag(Short widechannelFlag) {
        this.widechannelFlag = widechannelFlag;
        return this;
    }

    public ParkPavilioItem setOnechannelFlag(Short onechannelFlag) {
        this.onechannelFlag = onechannelFlag;
        return this;
    }

    public ParkPavilioItem setFingerVerificationflag(Short fingerVerificationflag) {
        this.fingerVerificationflag = fingerVerificationflag;
        return this;
    }

    public ParkPavilioItem setClientMode(Short clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public ParkPavilioItem setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
        return this;
    }

    public ParkPavilioItem setActivationState(Short activationState) {
        this.activationState = activationState;
        return this;
    }

    public ParkPavilioItem setCommunicationFlag(Short communicationFlag) {
        this.communicationFlag = communicationFlag;
        return this;
    }

    public ParkPavilioItem setParkingLotInfId(String parkingLotInfId) {
        this.parkingLotInfId = parkingLotInfId;
        return this;
    }

    public ParkPavilioItem setParkingLotInfName(String parkingLotInfName) {
        this.parkingLotInfName = parkingLotInfName;
        return this;
    }

    public ParkPavilioItem setParkingLotInfIdIn(String parkingLotInfIdIn) {
        this.parkingLotInfIdIn = parkingLotInfIdIn;
        return this;
    }

    public String toString() {
        return "ParkPavilioItem(id=" + this.getId() + ", name=" + this.getName() + ", ipAddress=" + this.getIpAddress() + ", entranceAreaName=" + this.getEntranceAreaName() + ", parkingAreaName=" + this.getParkingAreaName() + ", parkingAreaId=" + this.getParkingAreaId() + ", parkingAreaType=" + this.getParkingAreaType() + ", entranceAreaId=" + this.getEntranceAreaId() + ", temporaryCarFree=" + this.getTemporaryCarFree() + ", replacement=" + this.getReplacement() + ", opengagebyhandFlag=" + this.getOpengagebyhandFlag() + ", tempcarQuickoutFlag=" + this.getTempcarQuickoutFlag() + ", reviseCarnoIn=" + this.getReviseCarnoIn() + ", reviseCarnoOut=" + this.getReviseCarnoOut() + ", customDisplayPort=" + this.getCustomDisplayPort() + ", widechannelFlag=" + this.getWidechannelFlag() + ", onechannelFlag=" + this.getOnechannelFlag() + ", fingerVerificationflag=" + this.getFingerVerificationflag() + ", clientMode=" + this.getClientMode() + ", registrationCode=" + this.getRegistrationCode() + ", activationState=" + this.getActivationState() + ", communicationFlag=" + this.getCommunicationFlag() + ", parkingLotInfId=" + this.getParkingLotInfId() + ", parkingLotInfName=" + this.getParkingLotInfName() + ", parkingLotInfIdIn=" + this.getParkingLotInfIdIn() + ")";
    }
}

