/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import org.apache.commons.lang3.StringUtils;

@From(after="PARK_DEVICE t LEFT JOIN PARK_CHANNEL c ON t.CHANNEL_ID=c.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=380, winWidth=420, operates={@GridOperate(type="edit", permission="park:device:edit", url="parkDevice.do?edit", showConvertor="showGridOperate", label="common_op_edit"), @GridOperate(type="custom", permission="adms:devCmd:refresh", click="parkViewBestCommand", showConvertor="showGridViewCommand", label="common_devMonitor_viewTheCommand"), @GridOperate(type="del", permission="park:device:del", url="parkDevice.do?del&names=(name)", label="common_op_del"), @GridOperate(type="custom", permission="park:device:bindChannel", click="parkBindVidChannel", showConvertor="filterByMachineType", label="common_vid_bindOrUnbindChannel")})
public class ParkDeviceItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="park_device_name", sortNo=2, width="150", columnType="edit", showConvertor="showGridOperate", editPermission="park:device:edit", editUrl="parkDevice.do?edit")
    private String name;
    @Column(name="t.NAME")
    @GridColumn(label="park_device_name", sortNo=2, width="150")
    private String nameNotEdit;
    @Column(name="t.VENDORSTYPE")
    @GridColumn(label="park_device_vendors", sortNo=13, width="100", format="zk-LPR1000=park_vendorList_zk,zs-LPR=park_vendorList_zs,zk-CarId=park_vendorList_carId,zk-CA100=park_vendorList_ca100,zk-TBM100=park_vendorList_tbm100")
    private String vendorsType;
    @Column(name="t.LPR_DEVICE_TYPE")
    private Short lprDeviceType;
    @Column(name="t.DEVICE_TYPE")
    @GridColumn(label="park_device_type", sortNo=4, width="150", format="1=park_device_deviceType1,2=park_device_deviceType2,3=park_device_deviceType3", show=false)
    private Short deviceType;
    @Column(name="t.DISPLAY_TYPE")
    @GridColumn(label="park_device_displayType", sortNo=5, width="100", format="0=park_device_oneColor,1=park_device_twoColor,2=park_device_fourColor,9=park_device_oneRow,11=park_device_allLcd,8=park_device_twoColorV,12=park_device_fullLcd")
    private Short displayType;
    @Column(name="t.IP_ADDRESS")
    @GridColumn(label="common_ipAddress", sortNo=6, width="150")
    private String ipAddress;
    @Column(name="t.SN")
    @GridColumn(label="common_dev_sn", sortNo=7, width="150")
    private String sn;
    @Column(name="t.USERNAME")
    private String username;
    @Column(name="t.PASSWORD")
    private String password;
    @Column(name="t.PORT")
    @GridColumn(label="park_device_port", sortNo=8, sort="na")
    private Integer port;
    @Column(name="t.AVOPTION")
    @GridColumn(label="park_device_avoption", sortNo=9, sort="na")
    private Short avoption;
    @Column(name="t.STATUS")
    @GridColumn(label="common_enable", sortNo=10, columnType="custom", convert="convertToIcon", sort="na")
    private Short status;
    @GridColumn(label="common_status", sortNo=11, columnType="custom", convert="parkDeviceStatus", sort="na")
    private String deviceStatus;
    @Column(name="t.MAC_ADDRESS")
    private String macAddress;
    @Column(name="t.PRIORITIES")
    private Short priorities;
    @Column(name="t.P2P")
    private String p2p;
    @Column(name="c.ID")
    private String channelId;
    @Column(name="c.STATE")
    private Short channelState;
    @Column(name="c.NAME")
    private String channelName;
    @Column(name="t.ALGORITHM_VERSION")
    @GridColumn(label="park_device_algorithmVersion", width="150")
    private String algorithmVersion;
    @Column(name="t.FIRM_VERSION")
    @GridColumn(label="park_device_firmVersion", width="150")
    private String firmVersion;
    @Column(name="t.SDK_VERSION")
    @GridColumn(label="park_device_sdkVersion", width="120")
    private String sdkVersion;
    @Column(name="t.PROTYPE")
    private String protype;
    @Column(name="t.RTSP_URL")
    private String rtspUrl;
    private String netmask;
    private String gateway;
    private String funList;
    @Column(name="t.PARKING_LOTINF_ID")
    private String parkingLotInfId;
    @GridColumn(label="park_parkingArea_parkingLotName", sortNo=1, width="150")
    private String parkingLotInfName;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.PARKING_LOTINF_ID", equalTag="in")
    private String parkingLotInfIdIn;

    public ParkDeviceItem() {
    }

    public ParkDeviceItem(Boolean equals) {
        super(equals);
    }

    public ParkDeviceItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public boolean showGridOperate() {
        return StringUtils.isNotBlank((CharSequence)this.ipAddress);
    }

    public boolean filterByMachineType() {
        return "zk-TBM100".equals(this.vendorsType);
    }

    public boolean showGridViewCommand() {
        return "best-w".equals(this.protype);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameNotEdit() {
        return this.nameNotEdit;
    }

    public String getVendorsType() {
        return this.vendorsType;
    }

    public Short getLprDeviceType() {
        return this.lprDeviceType;
    }

    public Short getDeviceType() {
        return this.deviceType;
    }

    public Short getDisplayType() {
        return this.displayType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSn() {
        return this.sn;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    public Short getAvoption() {
        return this.avoption;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getDeviceStatus() {
        return this.deviceStatus;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public Short getPriorities() {
        return this.priorities;
    }

    public String getP2p() {
        return this.p2p;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Short getChannelState() {
        return this.channelState;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public String getFirmVersion() {
        return this.firmVersion;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getProtype() {
        return this.protype;
    }

    public String getRtspUrl() {
        return this.rtspUrl;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getFunList() {
        return this.funList;
    }

    public String getParkingLotInfId() {
        return this.parkingLotInfId;
    }

    public String getParkingLotInfName() {
        return this.parkingLotInfName;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getParkingLotInfIdIn() {
        return this.parkingLotInfIdIn;
    }

    public ParkDeviceItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkDeviceItem setName(String name) {
        this.name = name;
        return this;
    }

    public ParkDeviceItem setNameNotEdit(String nameNotEdit) {
        this.nameNotEdit = nameNotEdit;
        return this;
    }

    public ParkDeviceItem setVendorsType(String vendorsType) {
        this.vendorsType = vendorsType;
        return this;
    }

    public ParkDeviceItem setLprDeviceType(Short lprDeviceType) {
        this.lprDeviceType = lprDeviceType;
        return this;
    }

    public ParkDeviceItem setDeviceType(Short deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public ParkDeviceItem setDisplayType(Short displayType) {
        this.displayType = displayType;
        return this;
    }

    public ParkDeviceItem setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public ParkDeviceItem setSn(String sn) {
        this.sn = sn;
        return this;
    }

    public ParkDeviceItem setUsername(String username) {
        this.username = username;
        return this;
    }

    public ParkDeviceItem setPassword(String password) {
        this.password = password;
        return this;
    }

    public ParkDeviceItem setPort(Integer port) {
        this.port = port;
        return this;
    }

    public ParkDeviceItem setAvoption(Short avoption) {
        this.avoption = avoption;
        return this;
    }

    public ParkDeviceItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public ParkDeviceItem setDeviceStatus(String deviceStatus) {
        this.deviceStatus = deviceStatus;
        return this;
    }

    public ParkDeviceItem setMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    public ParkDeviceItem setPriorities(Short priorities) {
        this.priorities = priorities;
        return this;
    }

    public ParkDeviceItem setP2p(String p2p) {
        this.p2p = p2p;
        return this;
    }

    public ParkDeviceItem setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public ParkDeviceItem setChannelState(Short channelState) {
        this.channelState = channelState;
        return this;
    }

    public ParkDeviceItem setChannelName(String channelName) {
        this.channelName = channelName;
        return this;
    }

    public ParkDeviceItem setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
        return this;
    }

    public ParkDeviceItem setFirmVersion(String firmVersion) {
        this.firmVersion = firmVersion;
        return this;
    }

    public ParkDeviceItem setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
        return this;
    }

    public ParkDeviceItem setProtype(String protype) {
        this.protype = protype;
        return this;
    }

    public ParkDeviceItem setRtspUrl(String rtspUrl) {
        this.rtspUrl = rtspUrl;
        return this;
    }

    public ParkDeviceItem setNetmask(String netmask) {
        this.netmask = netmask;
        return this;
    }

    public ParkDeviceItem setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    public ParkDeviceItem setFunList(String funList) {
        this.funList = funList;
        return this;
    }

    public ParkDeviceItem setParkingLotInfId(String parkingLotInfId) {
        this.parkingLotInfId = parkingLotInfId;
        return this;
    }

    public ParkDeviceItem setParkingLotInfName(String parkingLotInfName) {
        this.parkingLotInfName = parkingLotInfName;
        return this;
    }

    public ParkDeviceItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public ParkDeviceItem setParkingLotInfIdIn(String parkingLotInfIdIn) {
        this.parkingLotInfIdIn = parkingLotInfIdIn;
        return this;
    }

    public String toString() {
        return "ParkDeviceItem(id=" + this.getId() + ", name=" + this.getName() + ", nameNotEdit=" + this.getNameNotEdit() + ", vendorsType=" + this.getVendorsType() + ", lprDeviceType=" + this.getLprDeviceType() + ", deviceType=" + this.getDeviceType() + ", displayType=" + this.getDisplayType() + ", ipAddress=" + this.getIpAddress() + ", sn=" + this.getSn() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", avoption=" + this.getAvoption() + ", status=" + this.getStatus() + ", deviceStatus=" + this.getDeviceStatus() + ", macAddress=" + this.getMacAddress() + ", priorities=" + this.getPriorities() + ", p2p=" + this.getP2p() + ", channelId=" + this.getChannelId() + ", channelState=" + this.getChannelState() + ", channelName=" + this.getChannelName() + ", algorithmVersion=" + this.getAlgorithmVersion() + ", firmVersion=" + this.getFirmVersion() + ", sdkVersion=" + this.getSdkVersion() + ", protype=" + this.getProtype() + ", rtspUrl=" + this.getRtspUrl() + ", netmask=" + this.getNetmask() + ", gateway=" + this.getGateway() + ", funList=" + this.getFunList() + ", parkingLotInfId=" + this.getParkingLotInfId() + ", parkingLotInfName=" + this.getParkingLotInfName() + ", notInId=" + this.getNotInId() + ", parkingLotInfIdIn=" + this.getParkingLotInfIdIn() + ")";
    }
}

