/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarTypeItem;
import java.util.List;

@From(after="PARK_CHANNEL t LEFT JOIN PARK_PAVILIO pp ON pp.ID = t.PAVILIO_ID LEFT JOIN PARK_ENTRANCE_AREA ent ON pp.ENTRANCE_AREA_ID = ent.ID LEFT JOIN PARK_PARKING_AREA area ON ent.PARKING_AREA_ID = area.ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=420, winWidth=700, minWidth="200", operates={@GridOperate(type="edit", permission="park:channel:edit", url="parkChannel.do?edit", label="common_op_edit"), @GridOperate(type="del", click="afterDeleteParkChannel", permission="park:channel:del", url="parkChannel.do?del&names=(name)", label="common_op_del"), @GridOperate(type="custom", filter="parkChannelShowUnmannedQR", permission="park:channel:showUnmannedQR", click="showUnmannedQR", label="park_channel_unmannedQR")})
public class ParkChannelItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="park_channel_name", sortNo=1, width="150", columnType="edit", editPermission="park:channel:edit", editUrl="parkChannel.do?edit")
    private String name;
    @Column(name="area.ID")
    private String parkingAreaId;
    @Column(name="area.AREATYPE")
    private Short parkingAreaType;
    @Column(name="pp.ID")
    private String pavilioId;
    @Column(name="pp.IP_ADDRESS")
    private String pavilioIP;
    @Column(name="pp.NAME")
    @GridColumn(label="park_pavilio_name", sortNo=2, width="150")
    private String pavilioName;
    @Column(name="pp.OPENGAGEBYHAND_FLAG")
    private Short pavilioOpengagebyhandFlag;
    @Column(name="t.STATE")
    @GridColumn(label="park_channel_state", columnType="dic", key="parkChannelState", sortNo=3, width="150")
    private Short state;
    @Column(name="(SELECT dev.ID FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 1)")
    private String devMaster;
    @Column(name="(SELECT dev.IP_ADDRESS FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 1)")
    private String devMasterIPAddress;
    @Deprecated
    private Boolean devMasterUsedInAtt = false;
    @Column(name="(SELECT dev.NAME FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 1)")
    @GridColumn(label="park_channel_IPC1_IP", sortNo=4, width="150", show=false)
    private String devMasterName;
    @Column(name="(SELECT dev.AVOPTION FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 1)")
    @GridColumn(label="park_channel_IPC1avoption", sortNo=5, width="150", show=false)
    private Short devMasterAvoption;
    @Column(name="(SELECT dev.ID FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 2)")
    private String devSlave;
    @Deprecated
    private Boolean devSlaveUsedInAtt = false;
    @Column(name="(SELECT dev.NAME FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 2)")
    @GridColumn(label="park_channel_IPC2_IP", sortNo=6, width="150", show=false)
    private String devSlaveName;
    @Column(name="(SELECT dev.AVOPTION FROM PARK_DEVICE dev WHERE dev.CHANNEL_ID = t.ID AND dev.PRIORITIES = 2)")
    @GridColumn(label="park_channel_IPC2avoption", sortNo=7, width="150", show=false)
    private Short devSlaveAvoption;
    @Column(name="t.MONTHCAR_OPEN_TYPE")
    @GridColumn(label="park_channel_monthCarOpenType", sortNo=8, width="150", format="1=park_channel_carOpenTypeConfirm,2=park_channel_carOpenTypeDirect,3=park_channel_carOpenTypeTelecontrol")
    private Short monthCarOpenType;
    @Column(name="t.TEMPCAR_OPEN_TYPE")
    @GridColumn(label="park_channel_tempCarOpenType", sortNo=9, width="150", format="1=park_channel_carOpenTypeConfirm,2=park_channel_carOpenTypeDirect,3=park_channel_carOpenTypeTelecontrol")
    private Short tempCarOpenType;
    @Column(name="t.LIMIT_MODE")
    private Short limitMode;
    @Column(name="t.RESTRICT_VEHICLETYPE")
    private String restrictVehicleType;
    @Column(name="t.START_TIME")
    @GridColumn(label="common_startTime", width="100")
    private String startTime;
    @Column(name="t.END_TIME")
    @GridColumn(label="common_endTime", width="100")
    private String endTime;
    @Column(name="t.OPENGAGE_DEVICEID")
    private Short opengageDeviceid;
    @Column(name="t.PORT")
    private String port;
    @Column(name="t.CARD_DEVICE_TYPE")
    private Short cardDeviceType;
    @Column(name="t.PICTURE_CAPTURE_MODE")
    private Short pictureCaptureMode;
    @Column(name="t.PARKING_LOTINF_ID")
    private String parkingLotInfId;
    @GridColumn(label="park_parkingArea_parkingLotName", width="150")
    private String parkingLotInfName;
    @Column(name="t.ENABLE_TICKET")
    private String enableTicket;
    @Column(name="t.CHANNEL_CODE")
    private String channelCode;
    private Boolean carTeamSignal = false;
    private List<ParkCarTypeItem> parkCarTypeItemList;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notId;
    @Condition(value="t.PARKING_LOTINF_ID", equalTag="in")
    private String parkingLotInfIdIn;
    @Condition(value="t.STATE", equalTag="!=")
    private Short notState;

    public ParkChannelItem() {
    }

    public ParkChannelItem(Boolean equals) {
        super(equals);
    }

    public ParkChannelItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParkingAreaId() {
        return this.parkingAreaId;
    }

    public Short getParkingAreaType() {
        return this.parkingAreaType;
    }

    public String getPavilioId() {
        return this.pavilioId;
    }

    public String getPavilioIP() {
        return this.pavilioIP;
    }

    public String getPavilioName() {
        return this.pavilioName;
    }

    public Short getPavilioOpengagebyhandFlag() {
        return this.pavilioOpengagebyhandFlag;
    }

    public Short getState() {
        return this.state;
    }

    public String getDevMaster() {
        return this.devMaster;
    }

    public String getDevMasterIPAddress() {
        return this.devMasterIPAddress;
    }

    @Deprecated
    public Boolean getDevMasterUsedInAtt() {
        return this.devMasterUsedInAtt;
    }

    public String getDevMasterName() {
        return this.devMasterName;
    }

    public Short getDevMasterAvoption() {
        return this.devMasterAvoption;
    }

    public String getDevSlave() {
        return this.devSlave;
    }

    @Deprecated
    public Boolean getDevSlaveUsedInAtt() {
        return this.devSlaveUsedInAtt;
    }

    public String getDevSlaveName() {
        return this.devSlaveName;
    }

    public Short getDevSlaveAvoption() {
        return this.devSlaveAvoption;
    }

    public Short getMonthCarOpenType() {
        return this.monthCarOpenType;
    }

    public Short getTempCarOpenType() {
        return this.tempCarOpenType;
    }

    public Short getLimitMode() {
        return this.limitMode;
    }

    public String getRestrictVehicleType() {
        return this.restrictVehicleType;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public Short getOpengageDeviceid() {
        return this.opengageDeviceid;
    }

    public String getPort() {
        return this.port;
    }

    public Short getCardDeviceType() {
        return this.cardDeviceType;
    }

    public Short getPictureCaptureMode() {
        return this.pictureCaptureMode;
    }

    public String getParkingLotInfId() {
        return this.parkingLotInfId;
    }

    public String getParkingLotInfName() {
        return this.parkingLotInfName;
    }

    public String getEnableTicket() {
        return this.enableTicket;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public Boolean getCarTeamSignal() {
        return this.carTeamSignal;
    }

    public List<ParkCarTypeItem> getParkCarTypeItemList() {
        return this.parkCarTypeItemList;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotId() {
        return this.notId;
    }

    public String getParkingLotInfIdIn() {
        return this.parkingLotInfIdIn;
    }

    public Short getNotState() {
        return this.notState;
    }

    public ParkChannelItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkChannelItem setName(String name) {
        this.name = name;
        return this;
    }

    public ParkChannelItem setParkingAreaId(String parkingAreaId) {
        this.parkingAreaId = parkingAreaId;
        return this;
    }

    public ParkChannelItem setParkingAreaType(Short parkingAreaType) {
        this.parkingAreaType = parkingAreaType;
        return this;
    }

    public ParkChannelItem setPavilioId(String pavilioId) {
        this.pavilioId = pavilioId;
        return this;
    }

    public ParkChannelItem setPavilioIP(String pavilioIP) {
        this.pavilioIP = pavilioIP;
        return this;
    }

    public ParkChannelItem setPavilioName(String pavilioName) {
        this.pavilioName = pavilioName;
        return this;
    }

    public ParkChannelItem setPavilioOpengagebyhandFlag(Short pavilioOpengagebyhandFlag) {
        this.pavilioOpengagebyhandFlag = pavilioOpengagebyhandFlag;
        return this;
    }

    public ParkChannelItem setState(Short state) {
        this.state = state;
        return this;
    }

    public ParkChannelItem setDevMaster(String devMaster) {
        this.devMaster = devMaster;
        return this;
    }

    public ParkChannelItem setDevMasterIPAddress(String devMasterIPAddress) {
        this.devMasterIPAddress = devMasterIPAddress;
        return this;
    }

    @Deprecated
    public ParkChannelItem setDevMasterUsedInAtt(Boolean devMasterUsedInAtt) {
        this.devMasterUsedInAtt = devMasterUsedInAtt;
        return this;
    }

    public ParkChannelItem setDevMasterName(String devMasterName) {
        this.devMasterName = devMasterName;
        return this;
    }

    public ParkChannelItem setDevMasterAvoption(Short devMasterAvoption) {
        this.devMasterAvoption = devMasterAvoption;
        return this;
    }

    public ParkChannelItem setDevSlave(String devSlave) {
        this.devSlave = devSlave;
        return this;
    }

    @Deprecated
    public ParkChannelItem setDevSlaveUsedInAtt(Boolean devSlaveUsedInAtt) {
        this.devSlaveUsedInAtt = devSlaveUsedInAtt;
        return this;
    }

    public ParkChannelItem setDevSlaveName(String devSlaveName) {
        this.devSlaveName = devSlaveName;
        return this;
    }

    public ParkChannelItem setDevSlaveAvoption(Short devSlaveAvoption) {
        this.devSlaveAvoption = devSlaveAvoption;
        return this;
    }

    public ParkChannelItem setMonthCarOpenType(Short monthCarOpenType) {
        this.monthCarOpenType = monthCarOpenType;
        return this;
    }

    public ParkChannelItem setTempCarOpenType(Short tempCarOpenType) {
        this.tempCarOpenType = tempCarOpenType;
        return this;
    }

    public ParkChannelItem setLimitMode(Short limitMode) {
        this.limitMode = limitMode;
        return this;
    }

    public ParkChannelItem setRestrictVehicleType(String restrictVehicleType) {
        this.restrictVehicleType = restrictVehicleType;
        return this;
    }

    public ParkChannelItem setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public ParkChannelItem setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public ParkChannelItem setOpengageDeviceid(Short opengageDeviceid) {
        this.opengageDeviceid = opengageDeviceid;
        return this;
    }

    public ParkChannelItem setPort(String port) {
        this.port = port;
        return this;
    }

    public ParkChannelItem setCardDeviceType(Short cardDeviceType) {
        this.cardDeviceType = cardDeviceType;
        return this;
    }

    public ParkChannelItem setPictureCaptureMode(Short pictureCaptureMode) {
        this.pictureCaptureMode = pictureCaptureMode;
        return this;
    }

    public ParkChannelItem setParkingLotInfId(String parkingLotInfId) {
        this.parkingLotInfId = parkingLotInfId;
        return this;
    }

    public ParkChannelItem setParkingLotInfName(String parkingLotInfName) {
        this.parkingLotInfName = parkingLotInfName;
        return this;
    }

    public ParkChannelItem setEnableTicket(String enableTicket) {
        this.enableTicket = enableTicket;
        return this;
    }

    public ParkChannelItem setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public ParkChannelItem setCarTeamSignal(Boolean carTeamSignal) {
        this.carTeamSignal = carTeamSignal;
        return this;
    }

    public ParkChannelItem setParkCarTypeItemList(List<ParkCarTypeItem> parkCarTypeItemList) {
        this.parkCarTypeItemList = parkCarTypeItemList;
        return this;
    }

    public ParkChannelItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public ParkChannelItem setNotId(String notId) {
        this.notId = notId;
        return this;
    }

    public ParkChannelItem setParkingLotInfIdIn(String parkingLotInfIdIn) {
        this.parkingLotInfIdIn = parkingLotInfIdIn;
        return this;
    }

    public ParkChannelItem setNotState(Short notState) {
        this.notState = notState;
        return this;
    }

    public String toString() {
        return "ParkChannelItem(id=" + this.getId() + ", name=" + this.getName() + ", parkingAreaId=" + this.getParkingAreaId() + ", parkingAreaType=" + this.getParkingAreaType() + ", pavilioId=" + this.getPavilioId() + ", pavilioIP=" + this.getPavilioIP() + ", pavilioName=" + this.getPavilioName() + ", pavilioOpengagebyhandFlag=" + this.getPavilioOpengagebyhandFlag() + ", state=" + this.getState() + ", devMaster=" + this.getDevMaster() + ", devMasterIPAddress=" + this.getDevMasterIPAddress() + ", devMasterUsedInAtt=" + this.getDevMasterUsedInAtt() + ", devMasterName=" + this.getDevMasterName() + ", devMasterAvoption=" + this.getDevMasterAvoption() + ", devSlave=" + this.getDevSlave() + ", devSlaveUsedInAtt=" + this.getDevSlaveUsedInAtt() + ", devSlaveName=" + this.getDevSlaveName() + ", devSlaveAvoption=" + this.getDevSlaveAvoption() + ", monthCarOpenType=" + this.getMonthCarOpenType() + ", tempCarOpenType=" + this.getTempCarOpenType() + ", limitMode=" + this.getLimitMode() + ", restrictVehicleType=" + this.getRestrictVehicleType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", opengageDeviceid=" + this.getOpengageDeviceid() + ", port=" + this.getPort() + ", cardDeviceType=" + this.getCardDeviceType() + ", pictureCaptureMode=" + this.getPictureCaptureMode() + ", parkingLotInfId=" + this.getParkingLotInfId() + ", parkingLotInfName=" + this.getParkingLotInfName() + ", enableTicket=" + this.getEnableTicket() + ", channelCode=" + this.getChannelCode() + ", carTeamSignal=" + this.getCarTeamSignal() + ", parkCarTypeItemList=" + this.getParkCarTypeItemList() + ", inId=" + this.getInId() + ", notId=" + this.getNotId() + ", parkingLotInfIdIn=" + this.getParkingLotInfIdIn() + ", notState=" + this.getNotState() + ")";
    }
}

