/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PARK_CAR_NUMBER t LEFT JOIN PARK_PERSON pp ON pp.ID = t.PERSON_ID LEFT JOIN PARK_AUTHORIZE auth ON auth.CAR_NUMBER_ID = t.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false)
public class ParkCarNumberSelectItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="pp.ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", sortNo=1, width="120")
    private String persName;
    @Column(name="pp.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=2, width="120")
    private String persLastName;
    @Column(name="t.CAR_NUMBER")
    @GridColumn(label="park_carNumber", sortNo=3, width="120")
    private String carNumber;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="120")
    private String cardNo;
    @GridColumn(label="type", sortNo=5, width="120")
    private String type;
    @Column(name="t.PARKING_LOT")
    @GridColumn(label="park_parkingSpace_spaceName", sortNo=6, width="120")
    private String parkingLot;
    @Column(name="t.ID", equalTag="not in")
    private String selectId;
    @Condition(value="(pp.PERS_PERSON_NAME LIKE ''%{0}%'' OR pp.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptIdIn;
    @Condition(value="pp.PERS_PERSON_ID", equalTag="not in")
    private String persPersonIdNotIn;
    private String sessionId;

    public ParkCarNumberSelectItem() {
    }

    public ParkCarNumberSelectItem(Boolean equals) {
        super(equals);
    }

    public ParkCarNumberSelectItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getType() {
        return this.type;
    }

    public String getParkingLot() {
        return this.parkingLot;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDeptIdIn() {
        return this.deptIdIn;
    }

    public String getPersPersonIdNotIn() {
        return this.persPersonIdNotIn;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ParkCarNumberSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkCarNumberSelectItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkCarNumberSelectItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkCarNumberSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public ParkCarNumberSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public ParkCarNumberSelectItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkCarNumberSelectItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkCarNumberSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public ParkCarNumberSelectItem setParkingLot(String parkingLot) {
        this.parkingLot = parkingLot;
        return this;
    }

    public ParkCarNumberSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public ParkCarNumberSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ParkCarNumberSelectItem setDeptIdIn(String deptIdIn) {
        this.deptIdIn = deptIdIn;
        return this;
    }

    public ParkCarNumberSelectItem setPersPersonIdNotIn(String persPersonIdNotIn) {
        this.persPersonIdNotIn = persPersonIdNotIn;
        return this;
    }

    public ParkCarNumberSelectItem setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String toString() {
        return "ParkCarNumberSelectItem(id=" + this.getId() + ", parkPersonId=" + this.getParkPersonId() + ", persPersonId=" + this.getPersPersonId() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", carNumber=" + this.getCarNumber() + ", cardNo=" + this.getCardNo() + ", type=" + this.getType() + ", parkingLot=" + this.getParkingLot() + ", selectId=" + this.getSelectId() + ", likeName=" + this.getLikeName() + ", deptIdIn=" + this.getDeptIdIn() + ", persPersonIdNotIn=" + this.getPersPersonIdNotIn() + ", sessionId=" + this.getSessionId() + ")";
    }
}

