/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PARK_CAR_NUMBER t LEFT JOIN PARK_PERSON pp ON pp.ID = t.PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=250, winWidth=450, operates={@GridOperate(type="edit", permission="park:carNumber:edit", url="parkCarNumber.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="park:carNumber:del", url="parkCarNumber.do?del&names=(carNumber)", label="common_op_del")})
public class ParkCarNumberItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="pp.ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="t.CAR_NUMBER")
    @GridColumn(label="park_carNumber", width="120", columnType="edit", editPermission="park:carNumber:edit", editUrl="parkCarNumber.do?edit", encryptMode="${park.encryptModeCarNumber}", encryptProp="${park.encryptPropCarNumber}")
    private String carNumber;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", width="120", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="pp.PERS_PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPersonPin;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String persName;
    @Column(name="pp.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", width="120", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String persLastName;
    @Column(name="pp.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="120")
    private String deptName;
    @Column(name="pp.PERS_MOBILE_PHONE", encryptConverter=true)
    @GridColumn(label="pers_person_mobilePhone", width="120", encryptMode="${pers.mobilePhone.encryptMode}", encryptProp="${pers.mobilePhone.encryptProp}", show=false)
    private String persMobilePhone;
    @Column(name="t.CAR_AREA")
    private String carArea;
    @Column(name="t.PARKING_LOT")
    @GridColumn(show=false)
    private String parkingLot;
    @Column(name="pp.AUTH_DEPT_ID")
    private String deptId;
    private String runningMode;
    private String parkProvince;
    private boolean authoraized;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptIdIn;
    @Condition(value="pp.PERS_PERSON_PIN", equalTag="in")
    private String persPersonPinIn;
    @Condition(value="pp.PERS_PERSON_ID", equalTag="in")
    private String persPersonIdIn;
    @Condition(value="(pp.PERS_PERSON_NAME LIKE ''%{0}%'' OR pp.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;

    public ParkCarNumberItem(String id, String carArea, String carNumber, String cardNo, String parkingLot) {
        this.id = id;
        this.carArea = carArea;
        this.carNumber = carNumber;
        this.cardNo = cardNo;
        this.parkingLot = parkingLot;
    }

    public ParkCarNumberItem() {
    }

    public ParkCarNumberItem(Boolean equals) {
        super(equals);
    }

    public ParkCarNumberItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getPersPersonPin() {
        return this.persPersonPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getPersMobilePhone() {
        return this.persMobilePhone;
    }

    public String getCarArea() {
        return this.carArea;
    }

    public String getParkingLot() {
        return this.parkingLot;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getRunningMode() {
        return this.runningMode;
    }

    public String getParkProvince() {
        return this.parkProvince;
    }

    public boolean isAuthoraized() {
        return this.authoraized;
    }

    public String getDeptIdIn() {
        return this.deptIdIn;
    }

    public String getPersPersonPinIn() {
        return this.persPersonPinIn;
    }

    public String getPersPersonIdIn() {
        return this.persPersonIdIn;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public ParkCarNumberItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkCarNumberItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkCarNumberItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkCarNumberItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkCarNumberItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkCarNumberItem setPersPersonPin(String persPersonPin) {
        this.persPersonPin = persPersonPin;
        return this;
    }

    public ParkCarNumberItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public ParkCarNumberItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public ParkCarNumberItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public ParkCarNumberItem setPersMobilePhone(String persMobilePhone) {
        this.persMobilePhone = persMobilePhone;
        return this;
    }

    public ParkCarNumberItem setCarArea(String carArea) {
        this.carArea = carArea;
        return this;
    }

    public ParkCarNumberItem setParkingLot(String parkingLot) {
        this.parkingLot = parkingLot;
        return this;
    }

    public ParkCarNumberItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public ParkCarNumberItem setRunningMode(String runningMode) {
        this.runningMode = runningMode;
        return this;
    }

    public ParkCarNumberItem setParkProvince(String parkProvince) {
        this.parkProvince = parkProvince;
        return this;
    }

    public ParkCarNumberItem setAuthoraized(boolean authoraized) {
        this.authoraized = authoraized;
        return this;
    }

    public ParkCarNumberItem setDeptIdIn(String deptIdIn) {
        this.deptIdIn = deptIdIn;
        return this;
    }

    public ParkCarNumberItem setPersPersonPinIn(String persPersonPinIn) {
        this.persPersonPinIn = persPersonPinIn;
        return this;
    }

    public ParkCarNumberItem setPersPersonIdIn(String persPersonIdIn) {
        this.persPersonIdIn = persPersonIdIn;
        return this;
    }

    public ParkCarNumberItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "ParkCarNumberItem(id=" + this.getId() + ", parkPersonId=" + this.getParkPersonId() + ", persPersonId=" + this.getPersPersonId() + ", carNumber=" + this.getCarNumber() + ", cardNo=" + this.getCardNo() + ", persPersonPin=" + this.getPersPersonPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", deptName=" + this.getDeptName() + ", persMobilePhone=" + this.getPersMobilePhone() + ", carArea=" + this.getCarArea() + ", parkingLot=" + this.getParkingLot() + ", deptId=" + this.getDeptId() + ", runningMode=" + this.getRunningMode() + ", parkProvince=" + this.getParkProvince() + ", authoraized=" + this.isAuthoraized() + ", deptIdIn=" + this.getDeptIdIn() + ", persPersonPinIn=" + this.getPersPersonPinIn() + ", persPersonIdIn=" + this.getPersPersonIdIn() + ", likeName=" + this.getLikeName() + ")";
    }
}

