/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PARK_CAR_NUMBER t LEFT JOIN PARK_PERSON pp ON pp.ID = t.PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=250, winWidth=420, operates={@GridOperate(type="edit", permission="park:carNumber:edit", url="parkCarNumber.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="park:carNumber:del", url="parkCarNumber.do?del&names=(carNumber)", label="common_op_del")})
public class ParkCarNumberAccModelItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="pp.ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String persPersonId;
    @Column(name="t.CAR_NUMBER")
    @GridColumn(label="park_carNumber", sortNo=1, width="120", columnType="edit", editPermission="park:carNumber:edit", editUrl="parkCarNumber.do?edit")
    private String carNumber;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="120")
    private String persName;
    @Column(name="pp.AUTH_DEPT_NAME")
    @GridColumn(label="PERS_PERSON_LASTNAME", sortNo=3, width="120", showExpression="#language!='zh_CN'")
    private String persLastName;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptId;
    @Column(name="pp.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", sortNo=4, width="120")
    private String deptName;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", sortNo=5, width="120")
    private String cardNo;
    @Column(name="t.CAR_AREA")
    private String carArea;
    @Column(name="t.PARKING_LOT")
    @GridColumn(show=false)
    private String parkingLot;
    private String runningMode;
    private String parkProvince;
    private boolean authoraized;
    @Condition(value="pp.PERS_PERSON_ID", equalTag="in")
    private String persPersonIdIn;

    public ParkCarNumberAccModelItem(String id, String carArea, String carNumber, String cardNo, String parkingLot) {
        this.id = id;
        this.carArea = carArea;
        this.carNumber = carNumber;
        this.cardNo = cardNo;
        this.parkingLot = parkingLot;
    }

    public ParkCarNumberAccModelItem() {
    }

    public ParkCarNumberAccModelItem(Boolean equals) {
        super(equals);
    }

    public ParkCarNumberAccModelItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersPersonId() {
        return this.persPersonId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getCarArea() {
        return this.carArea;
    }

    public String getParkingLot() {
        return this.parkingLot;
    }

    public String getRunningMode() {
        return this.runningMode;
    }

    public String getParkProvince() {
        return this.parkProvince;
    }

    public boolean isAuthoraized() {
        return this.authoraized;
    }

    public String getPersPersonIdIn() {
        return this.persPersonIdIn;
    }

    public ParkCarNumberAccModelItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkCarNumberAccModelItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkCarNumberAccModelItem setPersPersonId(String persPersonId) {
        this.persPersonId = persPersonId;
        return this;
    }

    public ParkCarNumberAccModelItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkCarNumberAccModelItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public ParkCarNumberAccModelItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public ParkCarNumberAccModelItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public ParkCarNumberAccModelItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public ParkCarNumberAccModelItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkCarNumberAccModelItem setCarArea(String carArea) {
        this.carArea = carArea;
        return this;
    }

    public ParkCarNumberAccModelItem setParkingLot(String parkingLot) {
        this.parkingLot = parkingLot;
        return this;
    }

    public ParkCarNumberAccModelItem setRunningMode(String runningMode) {
        this.runningMode = runningMode;
        return this;
    }

    public ParkCarNumberAccModelItem setParkProvince(String parkProvince) {
        this.parkProvince = parkProvince;
        return this;
    }

    public ParkCarNumberAccModelItem setAuthoraized(boolean authoraized) {
        this.authoraized = authoraized;
        return this;
    }

    public ParkCarNumberAccModelItem setPersPersonIdIn(String persPersonIdIn) {
        this.persPersonIdIn = persPersonIdIn;
        return this;
    }

    public String toString() {
        return "ParkCarNumberAccModelItem(id=" + this.getId() + ", parkPersonId=" + this.getParkPersonId() + ", persPersonId=" + this.getPersPersonId() + ", carNumber=" + this.getCarNumber() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", deptId=" + this.getDeptId() + ", deptName=" + this.getDeptName() + ", cardNo=" + this.getCardNo() + ", carArea=" + this.getCarArea() + ", parkingLot=" + this.getParkingLot() + ", runningMode=" + this.getRunningMode() + ", parkProvince=" + this.getParkProvince() + ", authoraized=" + this.isAuthoraized() + ", persPersonIdIn=" + this.getPersPersonIdIn() + ")";
    }
}

