/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.sql.Timestamp;
import java.util.Date;

@From(after="PARK_AUTHORIZE t LEFT JOIN PARK_CAR_TYPE ct ON t.CAR_TYPE_ID = ct.ID LEFT JOIN PARK_CAR_NUMBER car ON t.CAR_NUMBER_ID =car.ID LEFT JOIN PARK_FIXED_CHARGE charge ON t.FIXED_CHARGE_ID = charge.ID LEFT JOIN PARK_PARKINGSPACE space ON t.PARKINGSPACE_ID = space.ID LEFT JOIN PARK_PERSON pp ON t.PARK_PERSON_ID = pp.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, operates={@GridOperate(type="edit", permission="park:authorizeDelay:edit", url="parkAuthorizeDelay.do?edit", label="park_carDelay"), @GridOperate(type="custom", permission="park:authorize:del", click="parkDelDelayAuthorize", label="park_authorize_del")})
public class ParkAuthorizeDelayItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PARK_PERSON_ID")
    private String parkPersonId;
    @Column(name="pp.PERS_PERSON_ID")
    private String personId;
    @Column(name="pp.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", sortNo=1, width="120", editUrl="parkAuthorizeDelay.do?edit", columnType="edit", editPermission="park:authorizeDelay:edit", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="pp.PERS_PERSON_LASTNAME")
    @GridColumn(label="pers_person_lastName", sortNo=2, width="120", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="car.ID")
    private String carNumberId;
    @Column(name="car.CAR_NUMBER")
    @GridColumn(label="park_carNumber", sortNo=3, width="120", encryptMode="${park.encryptModeCarNumber}", encryptProp="${park.encryptPropCarNumber}")
    private String carNumber;
    @Column(name="car.CARD_NO")
    @GridColumn(label="pers_card_cardNo", sortNo=4, width="120")
    private String cardNo;
    @Column(name="space.ID")
    private String parkingSpaceId;
    private String parkEntZoneIds;
    private String parkEntZoneNames;
    @Column(name="space.SPACE_NAME")
    @GridColumn(label="park_parkingSpace_spaceName", sortNo=5, width="120")
    private String parkingSpaceName;
    @Column(name="ct.ID")
    private String carTypeId;
    @Column(name="ct.NAME")
    @GridColumn(label="park_carType_name", sortNo=6, width="120")
    private String carTypeName;
    @Column(name="charge.ID")
    private String fixedChargeId;
    private String fixedChargeInfo;
    @Column(name="ct.CODE")
    private String carTypeCode;
    @Column(name="ct.TYPE", equalTag="=")
    private Short carTypeType;
    @Column(name="t.START_TIME")
    @DateType
    @GridColumn(label="common_startTime", sortNo=7, width="150")
    private Date startTime;
    @Column(name="t.END_TIME", equalTag="<=")
    @DateType
    @GridColumn(label="common_endTime", sortNo=8, width="150")
    private Date endTime;
    @GridColumn(label="park_carDelay_warnDays", sortNo=9, width="120", format="-1=park_carDelay_expired", sort="na")
    private String warnDays;
    @Condition(value="pp.PERS_PERSON_ID", equalTag="in")
    private String persPersonIdIn;
    @Column(name="t.STATUS")
    @GridColumn(label="park_carDelay_status", sortNo=10, width="120", columnType="custom", convert="showAuthDelayStatus")
    private Short status;
    @Column(name="pp.PERS_MOBILE_PHONE", encryptConverter=true)
    @GridColumn(label="pers_person_mobilePhone", sortNo=11, width="120", encryptMode="${pers.mobilePhone.encryptMode}", encryptProp="${pers.mobilePhone.encryptProp}")
    private String persMobilePhone;
    @Condition(value="pp.AUTH_DEPT_ID", equalTag="in")
    private String deptIdIn;
    @Column(name="t.STATUS", equalTag="in")
    private String statusIn;
    @Condition(value="(pp.PERS_PERSON_NAME LIKE ''%{0}%'' OR pp.PERS_PERSON_LASTNAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="pp.ID IN (SELECT DISTINCT pp.ID FROM park_person pp,park_car_number car WHERE car.PERSON_ID = pp.ID AND car.car_number LIKE ''%{0}%'')")
    private String carNumberEx;
    private Date delayEndTime;
    private Double delayDebt;
    private String delayAuthIds;
    private String batchAuthorizeSelect;
    private boolean fixedFeeScale;
    private boolean displayParkingSpace;
    private String parkingLotModel;
    private Timestamp nowTime;
    private Integer todyNum;

    public ParkAuthorizeDelayItem() {
    }

    public ParkAuthorizeDelayItem(Boolean equals) {
        super(equals);
    }

    public ParkAuthorizeDelayItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getParkPersonId() {
        return this.parkPersonId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getCarNumberId() {
        return this.carNumberId;
    }

    public String getCarNumber() {
        return this.carNumber;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getParkingSpaceId() {
        return this.parkingSpaceId;
    }

    public String getParkEntZoneIds() {
        return this.parkEntZoneIds;
    }

    public String getParkEntZoneNames() {
        return this.parkEntZoneNames;
    }

    public String getParkingSpaceName() {
        return this.parkingSpaceName;
    }

    public String getCarTypeId() {
        return this.carTypeId;
    }

    public String getCarTypeName() {
        return this.carTypeName;
    }

    public String getFixedChargeId() {
        return this.fixedChargeId;
    }

    public String getFixedChargeInfo() {
        return this.fixedChargeInfo;
    }

    public String getCarTypeCode() {
        return this.carTypeCode;
    }

    public Short getCarTypeType() {
        return this.carTypeType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getWarnDays() {
        return this.warnDays;
    }

    public String getPersPersonIdIn() {
        return this.persPersonIdIn;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getPersMobilePhone() {
        return this.persMobilePhone;
    }

    public String getDeptIdIn() {
        return this.deptIdIn;
    }

    public String getStatusIn() {
        return this.statusIn;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getCarNumberEx() {
        return this.carNumberEx;
    }

    public Date getDelayEndTime() {
        return this.delayEndTime;
    }

    public Double getDelayDebt() {
        return this.delayDebt;
    }

    public String getDelayAuthIds() {
        return this.delayAuthIds;
    }

    public String getBatchAuthorizeSelect() {
        return this.batchAuthorizeSelect;
    }

    public boolean isFixedFeeScale() {
        return this.fixedFeeScale;
    }

    public boolean isDisplayParkingSpace() {
        return this.displayParkingSpace;
    }

    public String getParkingLotModel() {
        return this.parkingLotModel;
    }

    public Timestamp getNowTime() {
        return this.nowTime;
    }

    public Integer getTodyNum() {
        return this.todyNum;
    }

    public ParkAuthorizeDelayItem setId(String id) {
        this.id = id;
        return this;
    }

    public ParkAuthorizeDelayItem setParkPersonId(String parkPersonId) {
        this.parkPersonId = parkPersonId;
        return this;
    }

    public ParkAuthorizeDelayItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public ParkAuthorizeDelayItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public ParkAuthorizeDelayItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public ParkAuthorizeDelayItem setCarNumberId(String carNumberId) {
        this.carNumberId = carNumberId;
        return this;
    }

    public ParkAuthorizeDelayItem setCarNumber(String carNumber) {
        this.carNumber = carNumber;
        return this;
    }

    public ParkAuthorizeDelayItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public ParkAuthorizeDelayItem setParkingSpaceId(String parkingSpaceId) {
        this.parkingSpaceId = parkingSpaceId;
        return this;
    }

    public ParkAuthorizeDelayItem setParkEntZoneIds(String parkEntZoneIds) {
        this.parkEntZoneIds = parkEntZoneIds;
        return this;
    }

    public ParkAuthorizeDelayItem setParkEntZoneNames(String parkEntZoneNames) {
        this.parkEntZoneNames = parkEntZoneNames;
        return this;
    }

    public ParkAuthorizeDelayItem setParkingSpaceName(String parkingSpaceName) {
        this.parkingSpaceName = parkingSpaceName;
        return this;
    }

    public ParkAuthorizeDelayItem setCarTypeId(String carTypeId) {
        this.carTypeId = carTypeId;
        return this;
    }

    public ParkAuthorizeDelayItem setCarTypeName(String carTypeName) {
        this.carTypeName = carTypeName;
        return this;
    }

    public ParkAuthorizeDelayItem setFixedChargeId(String fixedChargeId) {
        this.fixedChargeId = fixedChargeId;
        return this;
    }

    public ParkAuthorizeDelayItem setFixedChargeInfo(String fixedChargeInfo) {
        this.fixedChargeInfo = fixedChargeInfo;
        return this;
    }

    public ParkAuthorizeDelayItem setCarTypeCode(String carTypeCode) {
        this.carTypeCode = carTypeCode;
        return this;
    }

    public ParkAuthorizeDelayItem setCarTypeType(Short carTypeType) {
        this.carTypeType = carTypeType;
        return this;
    }

    public ParkAuthorizeDelayItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public ParkAuthorizeDelayItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public ParkAuthorizeDelayItem setWarnDays(String warnDays) {
        this.warnDays = warnDays;
        return this;
    }

    public ParkAuthorizeDelayItem setPersPersonIdIn(String persPersonIdIn) {
        this.persPersonIdIn = persPersonIdIn;
        return this;
    }

    public ParkAuthorizeDelayItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public ParkAuthorizeDelayItem setPersMobilePhone(String persMobilePhone) {
        this.persMobilePhone = persMobilePhone;
        return this;
    }

    public ParkAuthorizeDelayItem setDeptIdIn(String deptIdIn) {
        this.deptIdIn = deptIdIn;
        return this;
    }

    public ParkAuthorizeDelayItem setStatusIn(String statusIn) {
        this.statusIn = statusIn;
        return this;
    }

    public ParkAuthorizeDelayItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public ParkAuthorizeDelayItem setCarNumberEx(String carNumberEx) {
        this.carNumberEx = carNumberEx;
        return this;
    }

    public ParkAuthorizeDelayItem setDelayEndTime(Date delayEndTime) {
        this.delayEndTime = delayEndTime;
        return this;
    }

    public ParkAuthorizeDelayItem setDelayDebt(Double delayDebt) {
        this.delayDebt = delayDebt;
        return this;
    }

    public ParkAuthorizeDelayItem setDelayAuthIds(String delayAuthIds) {
        this.delayAuthIds = delayAuthIds;
        return this;
    }

    public ParkAuthorizeDelayItem setBatchAuthorizeSelect(String batchAuthorizeSelect) {
        this.batchAuthorizeSelect = batchAuthorizeSelect;
        return this;
    }

    public ParkAuthorizeDelayItem setFixedFeeScale(boolean fixedFeeScale) {
        this.fixedFeeScale = fixedFeeScale;
        return this;
    }

    public ParkAuthorizeDelayItem setDisplayParkingSpace(boolean displayParkingSpace) {
        this.displayParkingSpace = displayParkingSpace;
        return this;
    }

    public ParkAuthorizeDelayItem setParkingLotModel(String parkingLotModel) {
        this.parkingLotModel = parkingLotModel;
        return this;
    }

    public ParkAuthorizeDelayItem setNowTime(Timestamp nowTime) {
        this.nowTime = nowTime;
        return this;
    }

    public ParkAuthorizeDelayItem setTodyNum(Integer todyNum) {
        this.todyNum = todyNum;
        return this;
    }

    public String toString() {
        return "ParkAuthorizeDelayItem(id=" + this.getId() + ", parkPersonId=" + this.getParkPersonId() + ", personId=" + this.getPersonId() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", carNumberId=" + this.getCarNumberId() + ", carNumber=" + this.getCarNumber() + ", cardNo=" + this.getCardNo() + ", parkingSpaceId=" + this.getParkingSpaceId() + ", parkEntZoneIds=" + this.getParkEntZoneIds() + ", parkEntZoneNames=" + this.getParkEntZoneNames() + ", parkingSpaceName=" + this.getParkingSpaceName() + ", carTypeId=" + this.getCarTypeId() + ", carTypeName=" + this.getCarTypeName() + ", fixedChargeId=" + this.getFixedChargeId() + ", fixedChargeInfo=" + this.getFixedChargeInfo() + ", carTypeCode=" + this.getCarTypeCode() + ", carTypeType=" + this.getCarTypeType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", warnDays=" + this.getWarnDays() + ", persPersonIdIn=" + this.getPersPersonIdIn() + ", status=" + this.getStatus() + ", persMobilePhone=" + this.getPersMobilePhone() + ", deptIdIn=" + this.getDeptIdIn() + ", statusIn=" + this.getStatusIn() + ", likeName=" + this.getLikeName() + ", carNumberEx=" + this.getCarNumberEx() + ", delayEndTime=" + this.getDelayEndTime() + ", delayDebt=" + this.getDelayDebt() + ", delayAuthIds=" + this.getDelayAuthIds() + ", batchAuthorizeSelect=" + this.getBatchAuthorizeSelect() + ", fixedFeeScale=" + this.isFixedFeeScale() + ", displayParkingSpace=" + this.isDisplayParkingSpace() + ", parkingLotModel=" + this.getParkingLotModel() + ", nowTime=" + this.getNowTime() + ", todyNum=" + this.getTodyNum() + ")";
    }
}

