/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.enums;

public enum ParkDeviceConfigEnum {
    DEVICE_TYPE_TBM100("zk-TBM100", "6", "", "", "TBM100"),
    DEVICE_TYPE_CA100("zk-CA100", "5", "rtsp://%s:8557/h264", "rtsp://%s:8557/sub_stream_1", "LPRCA100"),
    DEVICE_TYPE_ZS("zs-LPR", "3", "rtsp://%s:8557/h264", "rtsp://%s:8557/sub_stream_1", ""),
    DEVICE_TYPE_CARID("zk-CarId", "4", "rtsp://%s:554/ch01", "rtsp://%s:554/ch01_sub", "CarId"),
    DEVICE_TYPE_GZ("zk-LPR1000", "2", "rtsp://%s:554/ch01.264", "rtsp://%s:554/ch01_sub.264", ""),
    DEVICE_TYPE_JL("zk-LPR1000", "1", "rtsp://%s:554/av0_0", "rtsp://%s:554/av0_1", "");

    private String devSeriesType;
    private String devSeries;
    private Short devType;
    private String rtsp;
    private String rtspSub;

    public static ParkDeviceConfigEnum getDevType(Short devType) {
        for (ParkDeviceConfigEnum devConfig : ParkDeviceConfigEnum.values()) {
            if (!devConfig.getDevType().equals(devType)) continue;
            return devConfig;
        }
        return null;
    }

    public static String getRtspStream(Short devType, String devIp) {
        for (ParkDeviceConfigEnum devConfig : ParkDeviceConfigEnum.values()) {
            if (!devConfig.getDevType().equals(devType)) continue;
            return String.format(devConfig.getRtsp(), devIp);
        }
        return "";
    }

    public static String getRtspSubStream(Short devType, String devIp) {
        for (ParkDeviceConfigEnum devConfig : ParkDeviceConfigEnum.values()) {
            if (!devConfig.getDevType().equals(devType)) continue;
            return String.format(devConfig.getRtspSub(), devIp);
        }
        return "";
    }

    public String getDevSeriesType() {
        return this.devSeriesType;
    }

    public String getDevSeries() {
        return this.devSeries;
    }

    public Short getDevType() {
        return this.devType;
    }

    public String getRtsp() {
        return this.rtsp;
    }

    public String getRtspSub() {
        return this.rtspSub;
    }

    private ParkDeviceConfigEnum(String devSeries, String devType, String rtsp, String rtspSub, String devSeriesType) {
        this.devSeries = devSeries;
        this.devType = Short.valueOf(devType);
        this.rtsp = rtsp;
        this.rtspSub = rtspSub;
        this.devSeriesType = devSeriesType;
    }
}

