/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;
import java.util.Map;

@From(after="PERS_PERSON t LEFT JOIN PERS_POSITION p ON t.POSITION_ID=p.ID LEFT JOIN PERS_CERTIFICATE c on c.PERSON_ID = t.ID LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id LEFT JOIN PERS_USERTYPE e ON t.USERTYPE_ID=e.ID LEFT JOIN PERS_MEMBERSHIP f ON t.MEMBERSHIP_ID=f.ID")
@OrderBy(after="t.UPDATE_TIME DESC, t.ID DESC")
@GridConfig(operate=true, idField="id", winHeight=670, winWidth=1000, operates={@GridOperate(type="edit", permission="pers:person:edit", url="persPerson.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="pers:person:del", url="persPerson.do?del&pins=(pin)", label="common_op_del")})
public class PersPersonItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PIN")
    @GridColumn(columnType="edit", label="pers_person_pin", width="110", editPermission="pers:person:edit", editUrl="/persPerson.do?edit&id=(id)", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="110", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="110", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="d.CODE")
    private String deptCode;
    @Column(name="d.NAME")
    private String deptName;
    @Column(name="p.NAME")
    private String positionName;
    @GridColumn(label="pers_userType_name", width="150")
    @Column(name="e.USERTYPE_NAME")
    private String userTypeName;
    @GridColumn(label="pers_trainerPlan", width="150")
    @Column(name="t.PERS_TRAINER_PLAN")
    private String persTrainerPlan;
    @Column(name="t.PERS_TRAINER_PLAN_ID", equalTag="=")
    private String persTrainerPlanId;
    @Column(name="t.FINAL_AMOUNT")
    private String finalAmount;
    @Column(name="t.AMOUNT")
    private String amount;
    @Column(name="t.DISCOUNT_AMOUNT")
    private String discountAmount;
    @Column(name="t.GRACE_PERIOD")
    private String gracePeriod;
    @Column(name="t.LOCALITY")
    private String locality;
    @Column(name="t.CERTJPGPATH")
    private String certJpgPath;
    @Column(name="t.EXPERIENCE")
    private String experience;
    private String experienceYears;
    private String experienceMonths;
    @Column(name="f.MEMBERSHIP_PLAN")
    private String membershipPlan;
    @Column(name="f.MEMBERSHIP_AMOUNT")
    private String membershipAmount;
    @Column(name="t.MEMBERSHIP_ID")
    private String membershipId;
    @Column(name="f.MEMBERSHIP_CODE")
    private String membershipCode;
    private String inquiryId;
    @Column(name="t.IS_NEED_TRAINER")
    private Boolean isNeedTrainer;
    @Column(name="t.PERS_TRAINER_ID")
    private String persTrainerId;
    @Column(name="t.PERS_TRAINER_NAME")
    @GridColumn(label="pers_userType_trainer", width="150")
    private String persTrainerName;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    @Column(name="t.PERS_LOGIN_LIMIT")
    private Integer persLoginLimit;
    @Condition(value="t.ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_STATE=1 AND c.CARD_NO IN(%s))", formatType="quote")
    private String cardNos;
    @Condition(value="t.ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_NO LIKE ''%{0}%'')", encryptConverter=true)
    private String likeCardNo;
    @Column(name="t.BIRTHDAY")
    @DateType(type="date")
    @GridColumn(label="pers_person_birthday", encryptMode="${pers.birthday.encryptMode}", encryptProp="${pers.birthday.encryptProp}")
    private Date birthday;
    @Column(name="t.ANNIVERSARY")
    @DateType(type="date")
    private Date anniversary;
    @Column(name="t.JOIN_DATE")
    @DateType(type="timestamp")
    @GridColumn(label="pers_person_joinDate", width="180")
    private Date joinDate;
    @Column(name="t.GENDER")
    @GridColumn(label="pers_person_gender", format="F=pers_person_female,M=pers_person_male,U=common_unknown", encryptMode="${pers.gender.encryptMode}", encryptProp="${pers.gender.encryptProp}")
    private String gender;
    @Column(name="t.MOBILE_PHONE", encryptConverter=true)
    private String mobilePhone;
    @Column(name="t.EMAIL", encryptConverter=true)
    private String email;
    @GridColumn(columnType="custom", label="common_verifyMode_entiy", sort="na", width="140", convert="persConvertVerifyMode")
    private String verifyMode;
    @Column(name="t.ENABLED_CREDENTIAL")
    @GridColumn(label="common_enable", width="100", columnType="custom", convert="convertToIcon", showHeader="persShowEnabledCredential")
    private Boolean enabledCredential;
    @Column(name="t.APP_AUTHORIZATION")
    @GridColumn(label="pers_applogin_status", width="130", columnType="custom", convert="convertAppAuthorization", showHeader="persShowAppAuthorization")
    private Boolean appAuthorization;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="pers_person_createTime", width="150")
    private Date createTime;
    @Column(name="t.PHOTO_PATH")
    private String photoPath;
    private String thumbPhotoPath;
    @Column(name="t.STATUS")
    private Short status;
    @Column(name="t.PERSON_TYPE")
    private Short personType;
    @Column(name="t.PERSON_PWD", equalTag="=", encryptConverter=true)
    @GridColumn(label="pers_person_password", show=false)
    private String personPwd;
    @Column(name="t.SSN")
    private String ssn;
    @Column(name="t.CAR_PLATE")
    @GridColumn(label="pers_person_carPlate", show=false)
    private String carPlate;
    @Column(name="t.SELF_PWD", encryptConverter=true)
    @GridColumn(label="pers_person_reseCode", show=false)
    private String selfPwd;
    @Column(name="t.EXCEPTION_FLAG")
    @GridColumn(label="common_status", width="70", sort="na", format="0=common_commStatus_normal,1=pers_person_cardDuress,2=pers_person_pwdException,3=pers_person_pinException")
    private Short exceptionFlag;
    @Column(name="t.IS_SENDMAIL")
    private Boolean isSendMail;
    @Column(name="t.HIRE_DATE")
    @GridColumn(label="pers_cardTemplate_entryDate", show=false)
    private Date hireDate;
    @Column(name="t.ID_CARD", equalTag="=", encryptConverter=true)
    private String idCard;
    @Column(name="c.CERT_NUMBER")
    private String certNumber;
    @Column(name="t.ID_CARD_PHYSICAL_NO", equalTag="=", encryptConverter=true)
    private String idCardPhysicalNo;
    @Column(name="t.IS_FROM")
    @GridColumn(label="pers_person_isFrom", show=false)
    private String isFrom;
    @Condition(value="t.IS_FROM", equalTag="in")
    private String isFromIn;
    @Condition(value="(t.IS_FROM NOT IN (%s) OR t.IS_FROM IS NULL)", formatType="quote")
    private String isFromNotIn;
    @Column(name="p.ID", equalTag="=")
    private String positionId;
    @Column(name="e.ID", equalTag="=")
    private String userTypeId;
    @Condition(value="p.ID", equalTag="in")
    private String inPositionId;
    @Column(name="p.CODE", equalTag="=")
    private String positionCode;
    @Column(name="e.USERTYPE_CODE", equalTag="=")
    private String userTypeCode;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.PIN", equalTag="in")
    private String inPin;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="d.CODE", equalTag="in")
    private String inDeptCode;
    @GridColumn(dynamicColumn="persPersonDyna")
    private Map attrExtMap;
    @Column(name="t.APP_ID")
    private String appId;
    @Condition(value="(LOWER(t.NAME) LIKE LOWER(''%{0}%'') OR LOWER(t.LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="(LOWER(t.NAME) LIKE LOWER(''%{0}%'') OR LOWER(c.CERT_NUMBER) LIKE LOWER(''%{0}%'') OR LOWER(t.PIN) LIKE LOWER(''%{0}%''))")
    private String likeCurrency;
    @Condition(value="t.HIRE_DATE", equalTag=">=")
    private Date beginDate;
    @Condition(value="t.HIRE_DATE", equalTag="<=")
    private Date endDate;
    private String cropPhotoPath;
    @Column(name="t.UPDATE_TIME")
    private Date updateTime;
    @Column(name="t.SEND_SMS")
    private Boolean sendSMS;
    @Column(name="t.SEND_WHATSAPP")
    private Boolean sendWhatsapp;
    @Column(name="t.WHATSAPP_MOBILENO")
    private String whatsappMobileNo;
    private String areaCode;
    private Boolean pinLetter;
    private String threatLevel;
    private String photoBase64;
    private String certJpgBase64;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.NUMBER_PIN")
    private Long numberPin;
    @Column(name="t.EXISTS_MOBILE_USER")
    private Boolean existsMobileUser;
    private String cropPhotoBase64;
    private Boolean cropPhotoDel;
    private String acmsCardNum;
    private String acmsMasterCard;

    public PersPersonItem() {
    }

    public PersPersonItem(Boolean equals) {
        super(equals);
    }

    public PersPersonItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersPersonItem(String id, Date createTime, String pin, String name, String lastName, String gender, String photoPath, Short status, Short personType, Date birthday, String mobilePhone, String email, String personPwd, String ssn, String carPlate, String selfPwd, Short exceptionFlag, Boolean isSendMail, Date hireDate, String idCard, String idCardPhysicalNo, String isFrom) {
        this.id = id;
        this.createTime = createTime;
        this.pin = pin;
        this.name = name;
        this.lastName = lastName;
        this.gender = gender;
        this.photoPath = photoPath;
        this.status = status;
        this.personType = personType;
        this.birthday = birthday;
        this.mobilePhone = mobilePhone;
        this.email = email;
        this.personPwd = personPwd;
        this.ssn = ssn;
        this.carPlate = carPlate;
        this.selfPwd = selfPwd;
        this.exceptionFlag = exceptionFlag;
        this.isSendMail = isSendMail;
        this.hireDate = hireDate;
        this.idCard = idCard;
        this.idCardPhysicalNo = idCardPhysicalNo;
        this.isFrom = isFrom;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public String getUserTypeName() {
        return this.userTypeName;
    }

    public String getPersTrainerPlan() {
        return this.persTrainerPlan;
    }

    public String getPersTrainerPlanId() {
        return this.persTrainerPlanId;
    }

    public String getFinalAmount() {
        return this.finalAmount;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getDiscountAmount() {
        return this.discountAmount;
    }

    public String getGracePeriod() {
        return this.gracePeriod;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getCertJpgPath() {
        return this.certJpgPath;
    }

    public String getExperience() {
        return this.experience;
    }

    public String getExperienceYears() {
        return this.experienceYears;
    }

    public String getExperienceMonths() {
        return this.experienceMonths;
    }

    public String getMembershipPlan() {
        return this.membershipPlan;
    }

    public String getMembershipAmount() {
        return this.membershipAmount;
    }

    public String getMembershipId() {
        return this.membershipId;
    }

    public String getMembershipCode() {
        return this.membershipCode;
    }

    public String getInquiryId() {
        return this.inquiryId;
    }

    public Boolean getIsNeedTrainer() {
        return this.isNeedTrainer;
    }

    public String getPersTrainerId() {
        return this.persTrainerId;
    }

    public String getPersTrainerName() {
        return this.persTrainerName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public Integer getPersLoginLimit() {
        return this.persLoginLimit;
    }

    public String getCardNos() {
        return this.cardNos;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public Date getAnniversary() {
        return this.anniversary;
    }

    public Date getJoinDate() {
        return this.joinDate;
    }

    public String getGender() {
        return this.gender;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getVerifyMode() {
        return this.verifyMode;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public Boolean getAppAuthorization() {
        return this.appAuthorization;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getThumbPhotoPath() {
        return this.thumbPhotoPath;
    }

    public Short getStatus() {
        return this.status;
    }

    public Short getPersonType() {
        return this.personType;
    }

    public String getPersonPwd() {
        return this.personPwd;
    }

    public String getSsn() {
        return this.ssn;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getSelfPwd() {
        return this.selfPwd;
    }

    public Short getExceptionFlag() {
        return this.exceptionFlag;
    }

    public Boolean getIsSendMail() {
        return this.isSendMail;
    }

    public Date getHireDate() {
        return this.hireDate;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getIdCardPhysicalNo() {
        return this.idCardPhysicalNo;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public String getIsFromIn() {
        return this.isFromIn;
    }

    public String getIsFromNotIn() {
        return this.isFromNotIn;
    }

    public String getPositionId() {
        return this.positionId;
    }

    public String getUserTypeId() {
        return this.userTypeId;
    }

    public String getInPositionId() {
        return this.inPositionId;
    }

    public String getPositionCode() {
        return this.positionCode;
    }

    public String getUserTypeCode() {
        return this.userTypeCode;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInPin() {
        return this.inPin;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInDeptCode() {
        return this.inDeptCode;
    }

    public Map getAttrExtMap() {
        return this.attrExtMap;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getLikeCurrency() {
        return this.likeCurrency;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getCropPhotoPath() {
        return this.cropPhotoPath;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Boolean getSendSMS() {
        return this.sendSMS;
    }

    public Boolean getSendWhatsapp() {
        return this.sendWhatsapp;
    }

    public String getWhatsappMobileNo() {
        return this.whatsappMobileNo;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public Boolean getPinLetter() {
        return this.pinLetter;
    }

    public String getThreatLevel() {
        return this.threatLevel;
    }

    public String getPhotoBase64() {
        return this.photoBase64;
    }

    public String getCertJpgBase64() {
        return this.certJpgBase64;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getNumberPin() {
        return this.numberPin;
    }

    public Boolean getExistsMobileUser() {
        return this.existsMobileUser;
    }

    public String getCropPhotoBase64() {
        return this.cropPhotoBase64;
    }

    public Boolean getCropPhotoDel() {
        return this.cropPhotoDel;
    }

    public String getAcmsCardNum() {
        return this.acmsCardNum;
    }

    public String getAcmsMasterCard() {
        return this.acmsMasterCard;
    }

    public PersPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersPersonItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersPersonItem setName(String name) {
        this.name = name;
        return this;
    }

    public PersPersonItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersPersonItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PersPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersPersonItem setPositionName(String positionName) {
        this.positionName = positionName;
        return this;
    }

    public PersPersonItem setUserTypeName(String userTypeName) {
        this.userTypeName = userTypeName;
        return this;
    }

    public PersPersonItem setPersTrainerPlan(String persTrainerPlan) {
        this.persTrainerPlan = persTrainerPlan;
        return this;
    }

    public PersPersonItem setPersTrainerPlanId(String persTrainerPlanId) {
        this.persTrainerPlanId = persTrainerPlanId;
        return this;
    }

    public PersPersonItem setFinalAmount(String finalAmount) {
        this.finalAmount = finalAmount;
        return this;
    }

    public PersPersonItem setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public PersPersonItem setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    public PersPersonItem setGracePeriod(String gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public PersPersonItem setLocality(String locality) {
        this.locality = locality;
        return this;
    }

    public PersPersonItem setCertJpgPath(String certJpgPath) {
        this.certJpgPath = certJpgPath;
        return this;
    }

    public PersPersonItem setExperience(String experience) {
        this.experience = experience;
        return this;
    }

    public PersPersonItem setExperienceYears(String experienceYears) {
        this.experienceYears = experienceYears;
        return this;
    }

    public PersPersonItem setExperienceMonths(String experienceMonths) {
        this.experienceMonths = experienceMonths;
        return this;
    }

    public PersPersonItem setMembershipPlan(String membershipPlan) {
        this.membershipPlan = membershipPlan;
        return this;
    }

    public PersPersonItem setMembershipAmount(String membershipAmount) {
        this.membershipAmount = membershipAmount;
        return this;
    }

    public PersPersonItem setMembershipId(String membershipId) {
        this.membershipId = membershipId;
        return this;
    }

    public PersPersonItem setMembershipCode(String membershipCode) {
        this.membershipCode = membershipCode;
        return this;
    }

    public PersPersonItem setInquiryId(String inquiryId) {
        this.inquiryId = inquiryId;
        return this;
    }

    public PersPersonItem setIsNeedTrainer(Boolean isNeedTrainer) {
        this.isNeedTrainer = isNeedTrainer;
        return this;
    }

    public PersPersonItem setPersTrainerId(String persTrainerId) {
        this.persTrainerId = persTrainerId;
        return this;
    }

    public PersPersonItem setPersTrainerName(String persTrainerName) {
        this.persTrainerName = persTrainerName;
        return this;
    }

    public PersPersonItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersPersonItem setPersLoginLimit(Integer persLoginLimit) {
        this.persLoginLimit = persLoginLimit;
        return this;
    }

    public PersPersonItem setCardNos(String cardNos) {
        this.cardNos = cardNos;
        return this;
    }

    public PersPersonItem setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
        return this;
    }

    public PersPersonItem setBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    public PersPersonItem setAnniversary(Date anniversary) {
        this.anniversary = anniversary;
        return this;
    }

    public PersPersonItem setJoinDate(Date joinDate) {
        this.joinDate = joinDate;
        return this;
    }

    public PersPersonItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersPersonItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersPersonItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersPersonItem setVerifyMode(String verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public PersPersonItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public PersPersonItem setAppAuthorization(Boolean appAuthorization) {
        this.appAuthorization = appAuthorization;
        return this;
    }

    public PersPersonItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PersPersonItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public PersPersonItem setThumbPhotoPath(String thumbPhotoPath) {
        this.thumbPhotoPath = thumbPhotoPath;
        return this;
    }

    public PersPersonItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public PersPersonItem setPersonType(Short personType) {
        this.personType = personType;
        return this;
    }

    public PersPersonItem setPersonPwd(String personPwd) {
        this.personPwd = personPwd;
        return this;
    }

    public PersPersonItem setSsn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    public PersPersonItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public PersPersonItem setSelfPwd(String selfPwd) {
        this.selfPwd = selfPwd;
        return this;
    }

    public PersPersonItem setExceptionFlag(Short exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
        return this;
    }

    public PersPersonItem setIsSendMail(Boolean isSendMail) {
        this.isSendMail = isSendMail;
        return this;
    }

    public PersPersonItem setHireDate(Date hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    public PersPersonItem setIdCard(String idCard) {
        this.idCard = idCard;
        return this;
    }

    public PersPersonItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public PersPersonItem setIdCardPhysicalNo(String idCardPhysicalNo) {
        this.idCardPhysicalNo = idCardPhysicalNo;
        return this;
    }

    public PersPersonItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public PersPersonItem setIsFromIn(String isFromIn) {
        this.isFromIn = isFromIn;
        return this;
    }

    public PersPersonItem setIsFromNotIn(String isFromNotIn) {
        this.isFromNotIn = isFromNotIn;
        return this;
    }

    public PersPersonItem setPositionId(String positionId) {
        this.positionId = positionId;
        return this;
    }

    public PersPersonItem setUserTypeId(String userTypeId) {
        this.userTypeId = userTypeId;
        return this;
    }

    public PersPersonItem setInPositionId(String inPositionId) {
        this.inPositionId = inPositionId;
        return this;
    }

    public PersPersonItem setPositionCode(String positionCode) {
        this.positionCode = positionCode;
        return this;
    }

    public PersPersonItem setUserTypeCode(String userTypeCode) {
        this.userTypeCode = userTypeCode;
        return this;
    }

    public PersPersonItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public PersPersonItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PersPersonItem setInPin(String inPin) {
        this.inPin = inPin;
        return this;
    }

    public PersPersonItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PersPersonItem setInDeptCode(String inDeptCode) {
        this.inDeptCode = inDeptCode;
        return this;
    }

    public PersPersonItem setAttrExtMap(Map attrExtMap) {
        this.attrExtMap = attrExtMap;
        return this;
    }

    public PersPersonItem setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public PersPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PersPersonItem setLikeCurrency(String likeCurrency) {
        this.likeCurrency = likeCurrency;
        return this;
    }

    public PersPersonItem setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public PersPersonItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public PersPersonItem setCropPhotoPath(String cropPhotoPath) {
        this.cropPhotoPath = cropPhotoPath;
        return this;
    }

    public PersPersonItem setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public PersPersonItem setSendSMS(Boolean sendSMS) {
        this.sendSMS = sendSMS;
        return this;
    }

    public PersPersonItem setSendWhatsapp(Boolean sendWhatsapp) {
        this.sendWhatsapp = sendWhatsapp;
        return this;
    }

    public PersPersonItem setWhatsappMobileNo(String whatsappMobileNo) {
        this.whatsappMobileNo = whatsappMobileNo;
        return this;
    }

    public PersPersonItem setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    public PersPersonItem setPinLetter(Boolean pinLetter) {
        this.pinLetter = pinLetter;
        return this;
    }

    public PersPersonItem setThreatLevel(String threatLevel) {
        this.threatLevel = threatLevel;
        return this;
    }

    public PersPersonItem setPhotoBase64(String photoBase64) {
        this.photoBase64 = photoBase64;
        return this;
    }

    public PersPersonItem setCertJpgBase64(String certJpgBase64) {
        this.certJpgBase64 = certJpgBase64;
        return this;
    }

    public PersPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PersPersonItem setNumberPin(Long numberPin) {
        this.numberPin = numberPin;
        return this;
    }

    public PersPersonItem setExistsMobileUser(Boolean existsMobileUser) {
        this.existsMobileUser = existsMobileUser;
        return this;
    }

    public PersPersonItem setCropPhotoBase64(String cropPhotoBase64) {
        this.cropPhotoBase64 = cropPhotoBase64;
        return this;
    }

    public PersPersonItem setCropPhotoDel(Boolean cropPhotoDel) {
        this.cropPhotoDel = cropPhotoDel;
        return this;
    }

    public PersPersonItem setAcmsCardNum(String acmsCardNum) {
        this.acmsCardNum = acmsCardNum;
        return this;
    }

    public PersPersonItem setAcmsMasterCard(String acmsMasterCard) {
        this.acmsMasterCard = acmsMasterCard;
        return this;
    }

    public String toString() {
        return "PersPersonItem(id=" + this.getId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", positionName=" + this.getPositionName() + ", userTypeName=" + this.getUserTypeName() + ", persTrainerPlan=" + this.getPersTrainerPlan() + ", persTrainerPlanId=" + this.getPersTrainerPlanId() + ", finalAmount=" + this.getFinalAmount() + ", amount=" + this.getAmount() + ", discountAmount=" + this.getDiscountAmount() + ", gracePeriod=" + this.getGracePeriod() + ", locality=" + this.getLocality() + ", certJpgPath=" + this.getCertJpgPath() + ", experience=" + this.getExperience() + ", experienceYears=" + this.getExperienceYears() + ", experienceMonths=" + this.getExperienceMonths() + ", membershipPlan=" + this.getMembershipPlan() + ", membershipAmount=" + this.getMembershipAmount() + ", membershipId=" + this.getMembershipId() + ", membershipCode=" + this.getMembershipCode() + ", inquiryId=" + this.getInquiryId() + ", isNeedTrainer=" + this.getIsNeedTrainer() + ", persTrainerId=" + this.getPersTrainerId() + ", persTrainerName=" + this.getPersTrainerName() + ", deptId=" + this.getDeptId() + ", persLoginLimit=" + this.getPersLoginLimit() + ", cardNos=" + this.getCardNos() + ", likeCardNo=" + this.getLikeCardNo() + ", birthday=" + this.getBirthday() + ", anniversary=" + this.getAnniversary() + ", joinDate=" + this.getJoinDate() + ", gender=" + this.getGender() + ", mobilePhone=" + this.getMobilePhone() + ", email=" + this.getEmail() + ", verifyMode=" + this.getVerifyMode() + ", enabledCredential=" + this.getEnabledCredential() + ", appAuthorization=" + this.getAppAuthorization() + ", createTime=" + this.getCreateTime() + ", photoPath=" + this.getPhotoPath() + ", thumbPhotoPath=" + this.getThumbPhotoPath() + ", status=" + this.getStatus() + ", personType=" + this.getPersonType() + ", personPwd=" + this.getPersonPwd() + ", ssn=" + this.getSsn() + ", carPlate=" + this.getCarPlate() + ", selfPwd=" + this.getSelfPwd() + ", exceptionFlag=" + this.getExceptionFlag() + ", isSendMail=" + this.getIsSendMail() + ", hireDate=" + this.getHireDate() + ", idCard=" + this.getIdCard() + ", certNumber=" + this.getCertNumber() + ", idCardPhysicalNo=" + this.getIdCardPhysicalNo() + ", isFrom=" + this.getIsFrom() + ", isFromIn=" + this.getIsFromIn() + ", isFromNotIn=" + this.getIsFromNotIn() + ", positionId=" + this.getPositionId() + ", userTypeId=" + this.getUserTypeId() + ", inPositionId=" + this.getInPositionId() + ", positionCode=" + this.getPositionCode() + ", userTypeCode=" + this.getUserTypeCode() + ", inId=" + this.getInId() + ", notInId=" + this.getNotInId() + ", inPin=" + this.getInPin() + ", inDeptId=" + this.getInDeptId() + ", inDeptCode=" + this.getInDeptCode() + ", attrExtMap=" + this.getAttrExtMap() + ", appId=" + this.getAppId() + ", likeName=" + this.getLikeName() + ", likeCurrency=" + this.getLikeCurrency() + ", beginDate=" + this.getBeginDate() + ", endDate=" + this.getEndDate() + ", cropPhotoPath=" + this.getCropPhotoPath() + ", updateTime=" + this.getUpdateTime() + ", sendSMS=" + this.getSendSMS() + ", sendWhatsapp=" + this.getSendWhatsapp() + ", whatsappMobileNo=" + this.getWhatsappMobileNo() + ", areaCode=" + this.getAreaCode() + ", pinLetter=" + this.getPinLetter() + ", threatLevel=" + this.getThreatLevel() + ", photoBase64=" + this.getPhotoBase64() + ", certJpgBase64=" + this.getCertJpgBase64() + ", userId=" + this.getUserId() + ", numberPin=" + this.getNumberPin() + ", existsMobileUser=" + this.getExistsMobileUser() + ", cropPhotoBase64=" + this.getCropPhotoBase64() + ", cropPhotoDel=" + this.getCropPhotoDel() + ", acmsCardNum=" + this.getAcmsCardNum() + ", acmsMasterCard=" + this.getAcmsMasterCard() + ")";
    }
}

