/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeExtItem;
import java.util.Date;
import java.util.Map;

@From(after="PERS_PERSON t")
@OrderBy(after="t.UPDATE_TIME DESC")
public class PersPersonExportItem
extends BaseItem {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="90")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="120")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="120", showExpression="#language!='zh_CN'")
    private String lastName;
    @Condition(value="t.ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_STATE=1 AND c.CARD_NO IN(%s))", formatType="quote")
    @GridColumn(label="pers_card_cardNo", width="120")
    private String cardNos;
    @Column(name="t.GENDER")
    @GridColumn(label="pers_person_gender", width="120")
    private String gender;
    @Column(name="t.BIRTHDAY")
    @DateType(type="date")
    @GridColumn(label="pers_person_birthday", width="120")
    private Date birthday;
    @Column(name="t.MOBILE_PHONE", encryptConverter=true)
    @GridColumn(label="pers_person_mobilePhone", width="120")
    private String mobilePhone;
    @Column(name="t.EMAIL", encryptConverter=true)
    @GridColumn(label="pers_person_email", width="120")
    private String email;
    @Column(name="t.CAR_PLATE")
    @GridColumn(label="pers_person_carPlate", width="120")
    private String carPlate;
    @Condition(value="t.ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_NO LIKE ''%{0}%'')")
    private String likeCardNo;
    @GridColumn(label="pers_cert_type", width="120")
    private String certName;
    @GridColumn(label="pers_cert_number", width="120")
    private String certNumber;
    @GridColumn(label="pers_person_building", width="120")
    private String buildingName;
    @GridColumn(label="pers_person_unitName", width="120")
    private String unitName;
    @GridColumn(label="pers_person_roomNo", width="120")
    private String roomNo;
    private PersAttributeExtItem attributeExt;
    @GridColumn(show=false)
    private Map<String, String> attrMap;
    @GridColumn(label="common_verifyMode_entiy", width="200", show=false)
    private String verifyMode;
    @GridColumn(label="pers_userType_name", width="120")
    private String userTypeName;
    @GridColumn(label="pers_membership_plan", width="200")
    private String membershipPlan;
    @Column(name="t.ANNIVERSARY")
    @DateType(type="date")
    @GridColumn(label="pers_person_anniversary")
    private Date anniversary;
    @Column(name="t.WHATSAPP_MOBILENO", encryptConverter=true)
    @GridColumn(label="base_model_whatsapp", width="120")
    private String whatsappMobileNo;
    @Column(name="t.LOCALITY")
    @GridColumn(label="pers_person_locality", width="120")
    private String locality;

    public PersAttributeExtItem getAttributeExt() {
        if (this.attributeExt == null) {
            return new PersAttributeExtItem();
        }
        return this.attributeExt;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNos() {
        return this.cardNos;
    }

    public String getGender() {
        return this.gender;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public String getCertName() {
        return this.certName;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getRoomNo() {
        return this.roomNo;
    }

    public Map<String, String> getAttrMap() {
        return this.attrMap;
    }

    public String getVerifyMode() {
        return this.verifyMode;
    }

    public String getUserTypeName() {
        return this.userTypeName;
    }

    public String getMembershipPlan() {
        return this.membershipPlan;
    }

    public Date getAnniversary() {
        return this.anniversary;
    }

    public String getWhatsappMobileNo() {
        return this.whatsappMobileNo;
    }

    public String getLocality() {
        return this.locality;
    }

    public PersPersonExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersPersonExportItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersPersonExportItem setName(String name) {
        this.name = name;
        return this;
    }

    public PersPersonExportItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersPersonExportItem setCardNos(String cardNos) {
        this.cardNos = cardNos;
        return this;
    }

    public PersPersonExportItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersPersonExportItem setBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    public PersPersonExportItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersPersonExportItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersPersonExportItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public PersPersonExportItem setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
        return this;
    }

    public PersPersonExportItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public PersPersonExportItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public PersPersonExportItem setBuildingName(String buildingName) {
        this.buildingName = buildingName;
        return this;
    }

    public PersPersonExportItem setUnitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    public PersPersonExportItem setRoomNo(String roomNo) {
        this.roomNo = roomNo;
        return this;
    }

    public PersPersonExportItem setAttributeExt(PersAttributeExtItem attributeExt) {
        this.attributeExt = attributeExt;
        return this;
    }

    public PersPersonExportItem setAttrMap(Map<String, String> attrMap) {
        this.attrMap = attrMap;
        return this;
    }

    public PersPersonExportItem setVerifyMode(String verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public PersPersonExportItem setUserTypeName(String userTypeName) {
        this.userTypeName = userTypeName;
        return this;
    }

    public PersPersonExportItem setMembershipPlan(String membershipPlan) {
        this.membershipPlan = membershipPlan;
        return this;
    }

    public PersPersonExportItem setAnniversary(Date anniversary) {
        this.anniversary = anniversary;
        return this;
    }

    public PersPersonExportItem setWhatsappMobileNo(String whatsappMobileNo) {
        this.whatsappMobileNo = whatsappMobileNo;
        return this;
    }

    public PersPersonExportItem setLocality(String locality) {
        this.locality = locality;
        return this;
    }

    public String toString() {
        return "PersPersonExportItem(id=" + this.getId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", cardNos=" + this.getCardNos() + ", gender=" + this.getGender() + ", birthday=" + this.getBirthday() + ", mobilePhone=" + this.getMobilePhone() + ", email=" + this.getEmail() + ", carPlate=" + this.getCarPlate() + ", likeCardNo=" + this.getLikeCardNo() + ", certName=" + this.getCertName() + ", certNumber=" + this.getCertNumber() + ", buildingName=" + this.getBuildingName() + ", unitName=" + this.getUnitName() + ", roomNo=" + this.getRoomNo() + ", attributeExt=" + (Object)((Object)this.getAttributeExt()) + ", attrMap=" + this.getAttrMap() + ", verifyMode=" + this.getVerifyMode() + ", userTypeName=" + this.getUserTypeName() + ", membershipPlan=" + this.getMembershipPlan() + ", anniversary=" + this.getAnniversary() + ", whatsappMobileNo=" + this.getWhatsappMobileNo() + ", locality=" + this.getLocality() + ")";
    }
}

