/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="PERS_PERSON t LEFT JOIN PERS_CERTIFICATE pc ON t.ID = pc.PERSON_ID LEFT JOIN PERS_ATTRIBUTE_EXT pat ON pat.PERSON_ID = t.ID LEFT JOIN PERS_POSITION p ON t.POSITION_ID=p.ID LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id LEFT JOIN AUTH_DEPARTMENT pd ON d.PARENT_ID = pd.ID")
@OrderBy(after="t.UPDATE_TIME DESC,t.PIN DESC")
public class PersPersonCloudItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    private String id;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    @Column(name="t.PIN")
    private String pin;
    @Column(name="t.NAME")
    private String name;
    @Column(name="t.LAST_NAME")
    private String lastName;
    @Column(name="d.CODE")
    private String deptCode;
    @Column(name="d.NAME")
    private String deptName;
    @Column(name="t.GENDER")
    private String gender;
    @Column(name="t.PHOTO_PATH")
    private String photoPath;
    @Column(name="t.STATUS")
    private Short status;
    @Column(name="t.PERSON_TYPE")
    private Short personType;
    @Column(name="t.BIRTHDAY")
    private Date birthday;
    @Column(name="t.MOBILE_PHONE", encryptConverter=true)
    private String mobilePhone;
    @Column(name="t.SELF_PWD", encryptConverter=true)
    private String selfPwd;
    @Column(name="t.PERSON_PWD", equalTag="=", encryptConverter=true)
    private String personPwd;
    @Column(name="pc.CERT_TYPE")
    private String certType;
    @Column(name="pc.CERT_NUMBER", equalTag="=", encryptConverter=true)
    private String certNumber;
    @Column(name="pat.ATTR_VALUE12")
    private String homeAddress;
    @Column(name="t.EXCEPTION_FLAG")
    private Short exceptionFlag;
    @Column(name="t.IS_FROM")
    private String isFrom;
    @Column(name="t.APP_ID", equalTag="=")
    private String appId;
    private String cardNos;
    @Column(name="t.HIRE_DATE")
    private Date hireDate;
    @Column(name="t.EMAIL", encryptConverter=true)
    private String email;
    private String thumbPhotoPath;
    @Column(name="pd.CODE")
    private String parentDeptCode;
    @Column(name="p.CODE", equalTag="=")
    private String positionCode;
    @Condition(value="t.UPDATE_TIME", equalTag=">")
    private Date lastUpdateDate;
    @Condition(value="(t.IS_FROM NOT IN (%s) OR t.IS_FROM IS NULL)", formatType="quote")
    private String isFromNotIn;
    private String cropPhotoPath;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public Short getStatus() {
        return this.status;
    }

    public Short getPersonType() {
        return this.personType;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getSelfPwd() {
        return this.selfPwd;
    }

    public String getPersonPwd() {
        return this.personPwd;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getHomeAddress() {
        return this.homeAddress;
    }

    public Short getExceptionFlag() {
        return this.exceptionFlag;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getCardNos() {
        return this.cardNos;
    }

    public Date getHireDate() {
        return this.hireDate;
    }

    public String getEmail() {
        return this.email;
    }

    public String getThumbPhotoPath() {
        return this.thumbPhotoPath;
    }

    public String getParentDeptCode() {
        return this.parentDeptCode;
    }

    public String getPositionCode() {
        return this.positionCode;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getIsFromNotIn() {
        return this.isFromNotIn;
    }

    public String getCropPhotoPath() {
        return this.cropPhotoPath;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public PersPersonCloudItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersPersonCloudItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersPersonCloudItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersPersonCloudItem setName(String name) {
        this.name = name;
        return this;
    }

    public PersPersonCloudItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersPersonCloudItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PersPersonCloudItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersPersonCloudItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersPersonCloudItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public PersPersonCloudItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public PersPersonCloudItem setPersonType(Short personType) {
        this.personType = personType;
        return this;
    }

    public PersPersonCloudItem setBirthday(Date birthday) {
        this.birthday = birthday;
        return this;
    }

    public PersPersonCloudItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersPersonCloudItem setSelfPwd(String selfPwd) {
        this.selfPwd = selfPwd;
        return this;
    }

    public PersPersonCloudItem setPersonPwd(String personPwd) {
        this.personPwd = personPwd;
        return this;
    }

    public PersPersonCloudItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public PersPersonCloudItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public PersPersonCloudItem setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress;
        return this;
    }

    public PersPersonCloudItem setExceptionFlag(Short exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
        return this;
    }

    public PersPersonCloudItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public PersPersonCloudItem setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public PersPersonCloudItem setCardNos(String cardNos) {
        this.cardNos = cardNos;
        return this;
    }

    public PersPersonCloudItem setHireDate(Date hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    public PersPersonCloudItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersPersonCloudItem setThumbPhotoPath(String thumbPhotoPath) {
        this.thumbPhotoPath = thumbPhotoPath;
        return this;
    }

    public PersPersonCloudItem setParentDeptCode(String parentDeptCode) {
        this.parentDeptCode = parentDeptCode;
        return this;
    }

    public PersPersonCloudItem setPositionCode(String positionCode) {
        this.positionCode = positionCode;
        return this;
    }

    public PersPersonCloudItem setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return this;
    }

    public PersPersonCloudItem setIsFromNotIn(String isFromNotIn) {
        this.isFromNotIn = isFromNotIn;
        return this;
    }

    public PersPersonCloudItem setCropPhotoPath(String cropPhotoPath) {
        this.cropPhotoPath = cropPhotoPath;
        return this;
    }

    public PersPersonCloudItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public String toString() {
        return "PersPersonCloudItem(id=" + this.getId() + ", deptId=" + this.getDeptId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", gender=" + this.getGender() + ", photoPath=" + this.getPhotoPath() + ", status=" + this.getStatus() + ", personType=" + this.getPersonType() + ", birthday=" + this.getBirthday() + ", mobilePhone=" + this.getMobilePhone() + ", selfPwd=" + this.getSelfPwd() + ", personPwd=" + this.getPersonPwd() + ", certType=" + this.getCertType() + ", certNumber=" + this.getCertNumber() + ", homeAddress=" + this.getHomeAddress() + ", exceptionFlag=" + this.getExceptionFlag() + ", isFrom=" + this.getIsFrom() + ", appId=" + this.getAppId() + ", cardNos=" + this.getCardNos() + ", hireDate=" + this.getHireDate() + ", email=" + this.getEmail() + ", thumbPhotoPath=" + this.getThumbPhotoPath() + ", parentDeptCode=" + this.getParentDeptCode() + ", positionCode=" + this.getPositionCode() + ", lastUpdateDate=" + this.getLastUpdateDate() + ", isFromNotIn=" + this.getIsFromNotIn() + ", cropPhotoPath=" + this.getCropPhotoPath() + ", enabledCredential=" + this.getEnabledCredential() + ")";
    }
}

