/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="PERS_PAYMENT_HISTORY_REPORT t INNER JOIN PERS_PERSON p ON p.ID=t.PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class PersPaymentHistoryReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_userId", width="150")
    private String personPin;
    @Column(name="CONCAT_WS(' ', p.NAME, p.LAST_NAME)")
    @GridColumn(label="pers_user_name", width="150")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    private String personLastName;
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.PAYMENT_ID")
    @GridColumn(label="pers_paymentId", width="150")
    private String paymentId;
    @Column(name="t.MEMBERSHIP_PLAN")
    @GridColumn(label="pers_membership_plan", width="150")
    private String membershipPlan;
    @Column(name="t.PAYABLE_AMOUNT")
    @GridColumn(label="pers_membership_payableAMount", width="150")
    private String payableAmount;
    @Column(name="t.FINAL_AMOUNT")
    private String finalAmount;
    @Column(name="t.AMOUNT_PAID")
    private String amountPaid;
    @Column(name="t.BALANCE_AMOUNT")
    @GridColumn(label="pers_membership_balanceAmount", width="150")
    private String balanceAmount;
    @Column(name="t.PAY_MODE")
    @GridColumn(label="pers_payMode", width="150")
    private String payMode;
    @Column(name="t.PAY_DAY")
    @GridColumn(label="pers_payment_day", width="150")
    private Date payDay;
    @Condition(value="t.PAY_DAY", equalTag=">=")
    private Date startTime;
    @Condition(value="t.PAY_DAY", equalTag="<=")
    private Date endTime;
    @Column(name="t.PERS_MAIL_CHECK")
    private String persMailCheck;

    public PersPaymentHistoryReportItem() {
    }

    public PersPaymentHistoryReportItem(Boolean equals) {
        super(equals);
    }

    public PersPaymentHistoryReportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersPaymentHistoryReportItem(String id, String personPin, String membershipPlan, String finalAmount, String amountPaid, String balanceAmount, String payMode, String status, Date payDay) {
        this.id = id;
        this.personPin = personPin;
        this.paymentId = this.paymentId;
        this.membershipPlan = membershipPlan;
        this.finalAmount = finalAmount;
        this.amountPaid = amountPaid;
        this.balanceAmount = balanceAmount;
        this.payMode = payMode;
        this.payDay = payDay;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getMembershipPlan() {
        return this.membershipPlan;
    }

    public String getPayableAmount() {
        return this.payableAmount;
    }

    public String getFinalAmount() {
        return this.finalAmount;
    }

    public String getAmountPaid() {
        return this.amountPaid;
    }

    public String getBalanceAmount() {
        return this.balanceAmount;
    }

    public String getPayMode() {
        return this.payMode;
    }

    public Date getPayDay() {
        return this.payDay;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getPersMailCheck() {
        return this.persMailCheck;
    }

    public PersPaymentHistoryReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersPaymentHistoryReportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PersPaymentHistoryReportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PersPaymentHistoryReportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PersPaymentHistoryReportItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PersPaymentHistoryReportItem setPaymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    public PersPaymentHistoryReportItem setMembershipPlan(String membershipPlan) {
        this.membershipPlan = membershipPlan;
        return this;
    }

    public PersPaymentHistoryReportItem setPayableAmount(String payableAmount) {
        this.payableAmount = payableAmount;
        return this;
    }

    public PersPaymentHistoryReportItem setFinalAmount(String finalAmount) {
        this.finalAmount = finalAmount;
        return this;
    }

    public PersPaymentHistoryReportItem setAmountPaid(String amountPaid) {
        this.amountPaid = amountPaid;
        return this;
    }

    public PersPaymentHistoryReportItem setBalanceAmount(String balanceAmount) {
        this.balanceAmount = balanceAmount;
        return this;
    }

    public PersPaymentHistoryReportItem setPayMode(String payMode) {
        this.payMode = payMode;
        return this;
    }

    public PersPaymentHistoryReportItem setPayDay(Date payDay) {
        this.payDay = payDay;
        return this;
    }

    public PersPaymentHistoryReportItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public PersPaymentHistoryReportItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public PersPaymentHistoryReportItem setPersMailCheck(String persMailCheck) {
        this.persMailCheck = persMailCheck;
        return this;
    }

    public String toString() {
        return "PersPaymentHistoryReportItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", personId=" + this.getPersonId() + ", paymentId=" + this.getPaymentId() + ", membershipPlan=" + this.getMembershipPlan() + ", payableAmount=" + this.getPayableAmount() + ", finalAmount=" + this.getFinalAmount() + ", amountPaid=" + this.getAmountPaid() + ", balanceAmount=" + this.getBalanceAmount() + ", payMode=" + this.getPayMode() + ", payDay=" + this.getPayDay() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", persMailCheck=" + this.getPersMailCheck() + ")";
    }
}

