/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id")
public class PersNoCardPersonItem
extends BaseItem {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="120")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="120", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", width="120", sort="na")
    private String deptName;
    @GridColumn(label="pers_card_cardNo", width="120", sort="na")
    private String cardNo;
    @Condition(value="t.PERSON_TYPE", equalTag="=")
    private Short personType;
    @Condition(value="t.ID NOT IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_STATE={0} GROUP BY c.PERSON_ID)")
    private Short cardState;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String notInPersonId;
    private String startPersonPin;
    private String endPersonPin;
    @Column(name="t.NUMBER_PIN", equalTag=">=")
    private Long startNumberPin;
    @Column(name="t.NUMBER_PIN", equalTag="<=")
    private Long endNumberPin;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="(LOWER(t.NAME) LIKE LOWER(''%{0}%'') OR LOWER(t.LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Short getPersonType() {
        return this.personType;
    }

    public Short getCardState() {
        return this.cardState;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getType() {
        return this.type;
    }

    public String getNotInPersonId() {
        return this.notInPersonId;
    }

    public String getStartPersonPin() {
        return this.startPersonPin;
    }

    public String getEndPersonPin() {
        return this.endPersonPin;
    }

    public Long getStartNumberPin() {
        return this.startNumberPin;
    }

    public Long getEndNumberPin() {
        return this.endNumberPin;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public PersNoCardPersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersNoCardPersonItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PersNoCardPersonItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PersNoCardPersonItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PersNoCardPersonItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersNoCardPersonItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PersNoCardPersonItem setPersonType(Short personType) {
        this.personType = personType;
        return this;
    }

    public PersNoCardPersonItem setCardState(Short cardState) {
        this.cardState = cardState;
        return this;
    }

    public PersNoCardPersonItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersNoCardPersonItem setType(String type) {
        this.type = type;
        return this;
    }

    public PersNoCardPersonItem setNotInPersonId(String notInPersonId) {
        this.notInPersonId = notInPersonId;
        return this;
    }

    public PersNoCardPersonItem setStartPersonPin(String startPersonPin) {
        this.startPersonPin = startPersonPin;
        return this;
    }

    public PersNoCardPersonItem setEndPersonPin(String endPersonPin) {
        this.endPersonPin = endPersonPin;
        return this;
    }

    public PersNoCardPersonItem setStartNumberPin(Long startNumberPin) {
        this.startNumberPin = startNumberPin;
        return this;
    }

    public PersNoCardPersonItem setEndNumberPin(Long endNumberPin) {
        this.endNumberPin = endNumberPin;
        return this;
    }

    public PersNoCardPersonItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PersNoCardPersonItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PersNoCardPersonItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public String toString() {
        return "PersNoCardPersonItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", cardNo=" + this.getCardNo() + ", personType=" + this.getPersonType() + ", cardState=" + this.getCardState() + ", deptId=" + this.getDeptId() + ", type=" + this.getType() + ", notInPersonId=" + this.getNotInPersonId() + ", startPersonPin=" + this.getStartPersonPin() + ", endPersonPin=" + this.getEndPersonPin() + ", startNumberPin=" + this.getStartNumberPin() + ", endNumberPin=" + this.getEndNumberPin() + ", userId=" + this.getUserId() + ", likeName=" + this.getLikeName() + ", selectId=" + this.getSelectId() + ")";
    }
}

