/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.sql.Timestamp;

@From(after="PERS_ISSUECARD t ")
@OrderBy(after="t.CREATE_TIME DESC, t.ID DESC")
@GridConfig
public class PersIssueCardItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="120", sort="na", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.PIN", equalTag="=")
    @GridColumn(label="pers_person_pin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String lastName;
    @Column(name="t.OPERATE_TYPE")
    @GridColumn(label="pers_issueCard_operate", width="120", format="1=pers_issueCard_entity,6=pers_lossCard_entity,7=pers_revertCard_entity,10=pers_card_writeMgr,11=pers_card_write,12=pers_card_back,13=pers_card_change")
    private Short operateType;
    @Column(name="t.CREATER_CODE")
    @GridColumn(label="pers_issueCard_operator", width="120")
    private String operator;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="base_opLog_opTime", width="150")
    private Timestamp issueTime;
    @Column(name="t.UPDATE_TIME")
    @GridColumn(label="pers_issueCard_changeTime", width="150")
    private Timestamp changeTime;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;

    public PersIssueCardItem() {
    }

    public PersIssueCardItem(Boolean equals) {
        super(equals);
    }

    public PersIssueCardItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersIssueCardItem(String id, String pin, String name, String lastName, String cardNo, Short operateType, Timestamp issueTime, Timestamp changeTime) {
        this.id = id;
        this.pin = pin;
        this.name = name;
        this.lastName = lastName;
        this.cardNo = cardNo;
        this.operateType = operateType;
        this.issueTime = issueTime;
        this.changeTime = changeTime;
    }

    public String getId() {
        return this.id;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Short getOperateType() {
        return this.operateType;
    }

    public String getOperator() {
        return this.operator;
    }

    public Timestamp getIssueTime() {
        return this.issueTime;
    }

    public Timestamp getChangeTime() {
        return this.changeTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public PersIssueCardItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersIssueCardItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PersIssueCardItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersIssueCardItem setName(String name) {
        this.name = name;
        return this;
    }

    public PersIssueCardItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersIssueCardItem setOperateType(Short operateType) {
        this.operateType = operateType;
        return this;
    }

    public PersIssueCardItem setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public PersIssueCardItem setIssueTime(Timestamp issueTime) {
        this.issueTime = issueTime;
        return this;
    }

    public PersIssueCardItem setChangeTime(Timestamp changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public PersIssueCardItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PersIssueCardItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public String toString() {
        return "PersIssueCardItem(id=" + this.getId() + ", cardNo=" + this.getCardNo() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", operateType=" + this.getOperateType() + ", operator=" + this.getOperator() + ", issueTime=" + this.getIssueTime() + ", changeTime=" + this.getChangeTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ")";
    }
}

