/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.sql.Timestamp;

@From(after="PERS_CARD t LEFT JOIN PERS_PERSON p ON t.PERSON_ID=p.ID LEFT join AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC, t.ID DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class PersCardItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="100", sort="na", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="p.ID", equalTag="=")
    private String personId;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="d.CODE")
    private String deptCode;
    @Column(name="d.NAME")
    private String deptName;
    @Column(name="p.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    @Column(name="t.CARD_TYPE")
    private Short cardType;
    @Column(name="t.CARD_OP_TYPE")
    private Short cardOpType;
    @Column(name="t.ISSUE_TIME")
    @GridColumn(label="pers_issueCard_date", width="140")
    private Timestamp issueTime;
    @Column(name="t.CARD_STATE")
    @GridColumn(label="pers_card_state", columnType="custom", format="1=pers_card_effect,3=pers_card_disabled")
    private Short cardState;
    @Column(name="t.START_TIME")
    private Timestamp startTime;
    @Column(name="t.END_TIME")
    private Timestamp endTime;
    @Column(name="t.LOGICAL_CARD_NO")
    private String logicalCardNo;
    @Condition(value="p.ID", equalTag="in")
    private String personIdIn;
    @Condition(value="t.CARD_NO", equalTag="in", encryptConverter=true)
    private String cardNoIn;
    @Condition(value="p.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="p.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.IS_FROM")
    private String isFrom;

    public PersCardItem() {
    }

    public PersCardItem(Boolean equals) {
        super(equals);
    }

    public PersCardItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersCardItem(String personPin, String cardNo, Short cardType, Short cardState) {
        this.personPin = personPin;
        this.cardNo = cardNo;
        this.cardType = cardType;
        this.cardState = cardState;
    }

    public PersCardItem(String cardNo, Short cardType, Short cardState) {
        this.cardNo = cardNo;
        this.cardType = cardType;
        this.cardState = cardState;
    }

    public PersCardItem(String cardNo, Short cardType, Short cardState, String isFrom) {
        this.cardNo = cardNo;
        this.cardType = cardType;
        this.cardState = cardState;
        this.isFrom = isFrom;
    }

    public PersCardItem(String id, Short cardType, Short cardOpType, Short cardState, String cardNo, Timestamp issueTime, Timestamp startTime, Timestamp endTime, String logicalCardNo) {
        this.id = id;
        this.cardType = cardType;
        this.cardOpType = cardOpType;
        this.cardState = cardState;
        this.cardNo = cardNo;
        this.issueTime = issueTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.logicalCardNo = logicalCardNo;
    }

    public String getId() {
        return this.id;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public Short getCardType() {
        return this.cardType;
    }

    public Short getCardOpType() {
        return this.cardOpType;
    }

    public Timestamp getIssueTime() {
        return this.issueTime;
    }

    public Short getCardState() {
        return this.cardState;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public String getLogicalCardNo() {
        return this.logicalCardNo;
    }

    public String getPersonIdIn() {
        return this.personIdIn;
    }

    public String getCardNoIn() {
        return this.cardNoIn;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public PersCardItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersCardItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PersCardItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PersCardItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PersCardItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PersCardItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PersCardItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PersCardItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersCardItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersCardItem setCardType(Short cardType) {
        this.cardType = cardType;
        return this;
    }

    public PersCardItem setCardOpType(Short cardOpType) {
        this.cardOpType = cardOpType;
        return this;
    }

    public PersCardItem setIssueTime(Timestamp issueTime) {
        this.issueTime = issueTime;
        return this;
    }

    public PersCardItem setCardState(Short cardState) {
        this.cardState = cardState;
        return this;
    }

    public PersCardItem setStartTime(Timestamp startTime) {
        this.startTime = startTime;
        return this;
    }

    public PersCardItem setEndTime(Timestamp endTime) {
        this.endTime = endTime;
        return this;
    }

    public PersCardItem setLogicalCardNo(String logicalCardNo) {
        this.logicalCardNo = logicalCardNo;
        return this;
    }

    public PersCardItem setPersonIdIn(String personIdIn) {
        this.personIdIn = personIdIn;
        return this;
    }

    public PersCardItem setCardNoIn(String cardNoIn) {
        this.cardNoIn = cardNoIn;
        return this;
    }

    public PersCardItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PersCardItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PersCardItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public PersCardItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public String toString() {
        return "PersCardItem(id=" + this.getId() + ", cardNo=" + this.getCardNo() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", deptId=" + this.getDeptId() + ", cardType=" + this.getCardType() + ", cardOpType=" + this.getCardOpType() + ", issueTime=" + this.getIssueTime() + ", cardState=" + this.getCardState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", logicalCardNo=" + this.getLogicalCardNo() + ", personIdIn=" + this.getPersonIdIn() + ", cardNoIn=" + this.getCardNoIn() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", isFrom=" + this.getIsFrom() + ")";
    }
}

