/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_BIOTEMPLATE t LEFT JOIN PERS_PERSON p ON t.PERSON_ID=p.ID LEFT join AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
public class PersBioTemplateItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    private String id;
    @Column(name="t.PERSON_ID", equalTag="=")
    private String personId;
    @Column(name="p.PIN", equalTag="=")
    @GridColumn(label="pers_person_pin")
    private String personPin;
    @Column(name="p.name")
    @GridColumn(label="pers_person_name")
    private String personName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.VALID_TYPE")
    @GridColumn(label="pers_person_templateValidType", format="0=pers_card_disabled,1=pers_card_effect")
    private Short validType;
    @Column(name="t.BIO_TYPE")
    @GridColumn(label="pers_person_templateBioTypeNumber")
    private Short bioType;
    @Column(name="t.BIO_TYPE")
    @GridColumn(label="pers_person_templateBioType", format="0=pers_person_universal,1=pers_person_regFinger,2=pers_person_infraredFace,3=pers_person_voice,4=pers_person_iris,5=pers_person_retina,6=pers_person_palmPrints,7=pers_person_regVein,8=pers_person_metacarpalVein,9=pers_person_visibleFace,10=pers_person_metacarpalVein")
    private Short bioTypeVal;
    @Column(name="t.VERSION")
    @GridColumn(label="pers_person_templateVersion")
    private String version;
    @Column(name="t.TEMPLATE")
    @GridColumn(label="pers_person_template")
    private String template;
    @Column(name="t.TEMPLATE_NO")
    @GridColumn(label="pers_person_templateNo")
    private Short templateNo;
    @Column(name="t.TEMPLATE_NO_INDEX")
    @GridColumn(label="pers_person_templateNoIndex")
    private Short templateNoIndex;
    @Column(name="t.DURESS")
    @GridColumn(label="pers_person_bioDuress", format="true=common_yes,false=common_no")
    private Boolean duress;
    @Condition(value="t.PERSON_ID", equalTag="in")
    private String personIdIn;
    @Condition(value="p.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="p.PIN", equalTag="like")
    private String pin;
    @Condition(value="(LOWER (p.NAME) LIKE LOWER (''%{0}%'') OR LOWER (p.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="p.GENDER", equalTag="=")
    private String gender;
    @Condition(value="p.EMAIL", equalTag="like", encryptConverter=true)
    private String email;
    @Column(name="p.MOBILE_PHONE", encryptConverter=true)
    private String mobilePhone;
    @Condition(value="p.EXCEPTION_FLAG", equalTag="=")
    private Short exceptionFlag;
    @Condition(value="t.PERSON_ID IN (SELECT c.PERSON_ID FROM PERS_CARD c WHERE c.CARD_NO LIKE ''%{0}%'')", encryptConverter=true)
    private String likeCardNo;
    @Column(name="d.NAME")
    private String deptName;
    @Column(name="p.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    private String verifyMode;
    @Condition(value="p.POSITION_ID IN (SELECT c.ID FROM PERS_POSITION c WHERE c.NAME LIKE ''%{0}%'')")
    private String positionName;
    @Condition(value="p.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;

    public PersBioTemplateItem() {
    }

    public PersBioTemplateItem(Boolean equals) {
        super(equals);
    }

    public PersBioTemplateItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersBioTemplateItem(String id, Short validType, Short bioType, String version, String template, Short templateNo, Short templateNoIndex) {
        this.id = id;
        this.validType = validType;
        this.bioType = bioType;
        this.version = version;
        this.template = template;
        this.templateNo = templateNo;
        this.templateNoIndex = templateNoIndex;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Short getValidType() {
        return this.validType;
    }

    public Short getBioType() {
        return this.bioType;
    }

    public Short getBioTypeVal() {
        return this.bioTypeVal;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTemplate() {
        return this.template;
    }

    public Short getTemplateNo() {
        return this.templateNo;
    }

    public Short getTemplateNoIndex() {
        return this.templateNoIndex;
    }

    public Boolean getDuress() {
        return this.duress;
    }

    public String getPersonIdIn() {
        return this.personIdIn;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public Short getExceptionFlag() {
        return this.exceptionFlag;
    }

    public String getLikeCardNo() {
        return this.likeCardNo;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getVerifyMode() {
        return this.verifyMode;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public String getUserId() {
        return this.userId;
    }

    public PersBioTemplateItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersBioTemplateItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PersBioTemplateItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PersBioTemplateItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PersBioTemplateItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersBioTemplateItem setValidType(Short validType) {
        this.validType = validType;
        return this;
    }

    public PersBioTemplateItem setBioType(Short bioType) {
        this.bioType = bioType;
        return this;
    }

    public PersBioTemplateItem setBioTypeVal(Short bioTypeVal) {
        this.bioTypeVal = bioTypeVal;
        return this;
    }

    public PersBioTemplateItem setVersion(String version) {
        this.version = version;
        return this;
    }

    public PersBioTemplateItem setTemplate(String template) {
        this.template = template;
        return this;
    }

    public PersBioTemplateItem setTemplateNo(Short templateNo) {
        this.templateNo = templateNo;
        return this;
    }

    public PersBioTemplateItem setTemplateNoIndex(Short templateNoIndex) {
        this.templateNoIndex = templateNoIndex;
        return this;
    }

    public PersBioTemplateItem setDuress(Boolean duress) {
        this.duress = duress;
        return this;
    }

    public PersBioTemplateItem setPersonIdIn(String personIdIn) {
        this.personIdIn = personIdIn;
        return this;
    }

    public PersBioTemplateItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PersBioTemplateItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersBioTemplateItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PersBioTemplateItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public PersBioTemplateItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public PersBioTemplateItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public PersBioTemplateItem setExceptionFlag(Short exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
        return this;
    }

    public PersBioTemplateItem setLikeCardNo(String likeCardNo) {
        this.likeCardNo = likeCardNo;
        return this;
    }

    public PersBioTemplateItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PersBioTemplateItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PersBioTemplateItem setVerifyMode(String verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public PersBioTemplateItem setPositionName(String positionName) {
        this.positionName = positionName;
        return this;
    }

    public PersBioTemplateItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PersBioTemplateItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", lastName=" + this.getLastName() + ", validType=" + this.getValidType() + ", bioType=" + this.getBioType() + ", bioTypeVal=" + this.getBioTypeVal() + ", version=" + this.getVersion() + ", template=" + this.getTemplate() + ", templateNo=" + this.getTemplateNo() + ", templateNoIndex=" + this.getTemplateNoIndex() + ", duress=" + this.getDuress() + ", personIdIn=" + this.getPersonIdIn() + ", inDeptId=" + this.getInDeptId() + ", pin=" + this.getPin() + ", likeName=" + this.getLikeName() + ", gender=" + this.getGender() + ", email=" + this.getEmail() + ", mobilePhone=" + this.getMobilePhone() + ", exceptionFlag=" + this.getExceptionFlag() + ", likeCardNo=" + this.getLikeCardNo() + ", deptName=" + this.getDeptName() + ", deptId=" + this.getDeptId() + ", verifyMode=" + this.getVerifyMode() + ", positionName=" + this.getPositionName() + ", userId=" + this.getUserId() + ")";
    }
}

