/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PersRegularUtil {
    protected static final Pattern pinPattern = Pattern.compile("[0-9a-zA-Z]+");
    protected static final Pattern cardPattern = Pattern.compile("[0-9a-fA-F]+");
    public static Pattern zeroPattern = Pattern.compile("^0.*");
    public static Pattern carnumberPattern = Pattern.compile("^[0-9A-Z\\u4e00-\\u9fa5]+$");
    protected static final Pattern mobilePhonePattern = Pattern.compile("^1[1-9][0-9]\\d{8}$");
    public static final String[] UNCHAR = new String[]{"<", ">", "`", "~", "!", "@", "#", "$", "%", "^", "*", "?", "/", "|", "\\", ":", ";", "=", "\"", "'", ",", "--", "+", "\uff0c", "\u3002", "\u3001", "\uff1b", "\u2018", "\u2019", "\u3010", "\u3011", "\u3001", "\uff01", "\uffe5", "\u2026\u2026", "&", "*", "\uff08", "\uff09", "\u2014\u2014"};
    public static Pattern sqlPattern1 = Pattern.compile("[+]*(like|and|or|xor|rlike|not)(([+])|([\\s]+['0-9]+))", 2);
    public static Pattern sqlPattern2 = Pattern.compile("[+]*(like|and|or|xor|rlike|not)(([+]{2})|([\\s]+['0-9]+))", 2);
    public static Pattern sqlPattern3 = Pattern.compile("((like|and|or|xor|rlike|not)[\\s]*[%'])|([%'][\\s]*(like|and|or|xor|rlike|not)[\\W]+)|(\\|\\|)|(&&)", 2);
    private static String[] provinceCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] powFactor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static char[] verifyValue = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static String idNumberPattern = "^[1-9][0-9]{5}(?:19|20)?[0-9]{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01])[0-9]{3}[0-9Xx]?$";
    private static Pattern regex = Pattern.compile(idNumberPattern);
    public static Pattern emailPattern = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*$");

    public static boolean hasNumberOrLetter(String pin) {
        return pinPattern.matcher(pin).matches();
    }

    public static boolean isHex(String cardNo) {
        return cardPattern.matcher(cardNo).matches();
    }

    public static boolean hasSpecialChar(String value) {
        String[] specialChars;
        String[] stringArray = specialChars = UNCHAR;
        int n = specialChars.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (value.contains(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean idNumberCheck(String idNum) {
        if ((idNum = idNum.toUpperCase().trim()) == null || idNum.trim().length() != 18) {
            return false;
        }
        char checkValue = PersRegularUtil.getCheckValue(idNum);
        return regex.matcher(idNum).find() && PersRegularUtil.isValidProvinceId(idNum.substring(0, 2)) && checkValue == idNum.charAt(17) && PersRegularUtil.isValidDate(idNum.substring(6, 14));
    }

    private static boolean isValidProvinceId(String provinceId) {
        String[] stringArray = provinceCode;
        int n = provinceCode.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(provinceId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    private static char getCheckValue(String idNum) {
        int sum = 0;
        int i = 0;
        while (i < 17) {
            sum += Integer.parseInt(idNum.substring(i, i + 1)) * powFactor[i];
            ++i;
        }
        return verifyValue[sum % 11];
    }

    public static boolean isValidMobilePhone(String mobilePhone) {
        return mobilePhonePattern.matcher(mobilePhone).matches();
    }

    public static String hideWithAsterisk(String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            int numberLength = number.length();
            int length = numberLength / 2;
            if (length > 0) {
                Object[] numbers = number.split("");
                if (length == 1) {
                    numbers[1] = "*";
                } else if (length > 1 && length < 5) {
                    int j = 2;
                    while (j < length + 1) {
                        numbers[j] = "*";
                        ++j;
                    }
                } else {
                    int j = 2;
                    while (j < 6) {
                        numbers[j] = "*";
                        ++j;
                    }
                }
                number = StringUtils.join((Object[])numbers, (String)"");
            } else {
                number = String.valueOf(number) + "*";
            }
        }
        return number;
    }

    public static boolean hasSqlKey(String str) {
        return sqlPattern1.matcher(str).find() || sqlPattern2.matcher(str).find() || sqlPattern3.matcher(str).find();
    }
}

