/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthTokenRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthTokenService;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthTokenController
extends BaseController
implements AuthTokenRemote {
    @Autowired
    private AuthTokenService authTokenService;

    public ZKResultMsg getToken(@RequestParam(value="loginType", defaultValue="NORMAL") String loginType, @RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        ZKResultMsg zkResultMsg = this.authTokenService.getToken(loginType, username, password);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg createToken() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        String token = this.authTokenService.createToken(securitySubject);
        return new ZKResultMsg((Object)token);
    }

    public ZKResultMsg getSubject() {
        SecuritySubject subject = this.authTokenService.getSubjectByToken(this.getToken());
        return new ZKResultMsg((Object)subject);
    }

    public ZKResultMsg getSessionId() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.request.getSession().getId());
        return zkResultMsg;
    }
}

