/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthShortCutMenuRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthShortCutMenuService;
import com.zkteco.zkbiosecurity.auth.vo.AuthShortCutMenuItem;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthShortCutMenuController
extends BaseController
implements AuthShortCutMenuRemote {
    @Autowired
    private AuthShortCutMenuService authShortCutMenuService;

    public ModelAndView index() {
        List authShortCutMenuItems = this.authShortCutMenuService.getByCurrentUser(this.request.getSession().getId());
        this.request.setAttribute("sysModuleMenus", (Object)authShortCutMenuItems);
        return new ModelAndView("auth/shortcutmenu/editAuthShortcutMenu");
    }

    public ZKResultMsg save(AuthShortCutMenuItem item) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        this.authShortCutMenuService.saveItem(item, securitySubject.getUserId());
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg getListByUser() {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        zkResultMsg.setData((Object)this.authShortCutMenuService.getListByUser(this.request.getSession().getId()));
        return zkResultMsg;
    }

    public ZKResultMsg deleteShortCutMenu(String authPermissionId) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        this.authShortCutMenuService.deleteShortCutMenu(securitySubject, authPermissionId);
        return ZKResultMsg.successMsg();
    }
}

