/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.remote.AuthRoleRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.service.AuthRoleService;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthRoleItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthRoleController
extends BaseController
implements AuthRoleRemote {
    @Autowired
    private AuthRoleService authRoleService;
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private AuthSessionServcie authSessionServcie;

    @RequiresPermissions(value={"auth:role"})
    public ModelAndView index() {
        return new ModelAndView("auth/role/authRole");
    }

    @RequiresPermissions(value={"auth:role:refresh"})
    public DxGrid list(AuthRoleItem condition) {
        Pager pager = this.authRoleService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"auth:role:del"})
    @LogRequest(module="system_module", object="auth_leftMenu_roleManage", opType="common_op_del", requestParams={"names"}, opContent="auth_role_name")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.authRoleService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"auth:role:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authRoleService.getItemById(id));
        }
        return new ModelAndView("auth/role/editAuthRole");
    }

    @RequiresPermissions(value={"auth:role:edit"})
    @LogRequest(module="system_module", object="auth_leftMenu_roleManage", opType="common_op_edit", requestParams={"name"}, opContent="auth_role_name")
    public ZKResultMsg save(AuthRoleItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.authRoleService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public TreeItem tree() {
        List items = this.authRoleService.getByCondition(new AuthRoleItem());
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthRoleItem config : items) {
            item = new TreeItem();
            item.setId(config.getId());
            item.setText(config.getName());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getAuthSystemList() {
        String roleId = this.request.getParameter("roleId");
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject retJson = new JSONObject();
        retJson.put("roleId", (Object)roleId);
        List authPermissionItems = this.authPermissionService.getSystemMenus();
        List appMenus = this.authPermissionService.getAppMenus();
        if (appMenus != null && appMenus.size() > 0) {
            authPermissionItems.addAll(appMenus);
            authPermissionItems = authPermissionItems.stream().sorted((param1, param2) -> param1.getOrderNo() > param2.getOrderNo() ? 1 : -1).collect(Collectors.toList());
        }
        JSONArray sysArray = new JSONArray();
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(WebContextUtil.getCurrentSessionId());
        for (AuthPermissionItem authPermissionItem : authPermissionItems) {
            if (!securitySubject.hasPermission(authPermissionItem.getPermission())) continue;
            String key = authPermissionItem.getName();
            authPermissionItem.setName(I18nUtil.i18nCode((String)key, (Object[])new Object[0]));
            if (StringUtils.equals((CharSequence)key, (CharSequence)authPermissionItem.getName())) continue;
            JSONObject json = new JSONObject();
            json.put("id", (Object)authPermissionItem.getId());
            json.put("name", (Object)authPermissionItem.getName());
            sysArray.add((Object)json);
        }
        resultMsg.setRet("ok");
        retJson.put("sysArr", (Object)sysArray);
        resultMsg.setData((Object)retJson.toString());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getTreeLists() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String roleId = this.request.getParameter("roleId");
        String systemId = this.request.getParameter("systemId");
        SecuritySubject subject = this.authSessionServcie.getSecuritySubject(WebContextUtil.getCurrentSessionId());
        resultMsg = this.authRoleService.getResourceTree(roleId, systemId, subject);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public String valid(String name) {
        boolean ret = this.authRoleService.isExistRoleName(name);
        return String.valueOf(!ret);
    }

    public String validCode(String code) {
        boolean ret = this.authRoleService.isExistRoleCode(code);
        return String.valueOf(!ret);
    }
}

