/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthPermissionRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionSelectItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthPermissionController
extends BaseController
implements AuthPermissionRemote {
    @Autowired
    private AuthPermissionService authPermissionService;

    public ModelAndView index() {
        String resourceType = this.request.getParameter("resourceType");
        return new ModelAndView("auth/permission/authPermission" + StrUtil.firstUpperCase((String)resourceType));
    }

    public DxGrid list(AuthPermissionItem codition) {
        Pager pager = this.authPermissionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid listSelect(AuthPermissionSelectItem codition, String resourceType) {
        if (StringUtils.isNotBlank((CharSequence)resourceType) && "button".equals(resourceType)) {
            codition.setResourceType("menu");
        }
        Pager pager = this.authPermissionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public String validCode(String code) {
        AuthPermissionItem item = this.authPermissionService.getItemByCode(code);
        return String.valueOf(item == null);
    }
}

