/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthDepartmentRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentSelectDeptItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentSelectItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthDepartmentController
extends ExportController
implements AuthDepartmentRemote {
    @Autowired
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AuthUserService authUserService;

    @RequiresPermissions(value={"auth:department"})
    public ModelAndView index() {
        return new ModelAndView("auth/department/authDepartment");
    }

    @RequiresPermissions(value={"auth:department:add", "auth:department:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authDepartmentService.getItemById(id));
        }
        AuthUserItem authUserItem = this.authUserService.getLoginUser(this.request.getSession().getId());
        this.request.setAttribute("isSuperuser", (Object)authUserItem.getIsSuperuser());
        return new ModelAndView("auth/department/editAuthDepartment");
    }

    @LogRequest(module="pers_module", object="pers_department", opType="common_op_edit", requestParams={"name"}, opContent="pers_dept_deptName")
    @RequiresPermissions(value={"auth:department:add", "auth:department:edit"})
    public ZKResultMsg save(AuthDepartmentItem item) {
        if (StringUtils.isBlank((CharSequence)item.getId()) && !this.authDepartmentService.deptLicenseCheck()) {
            throw ZKBusinessException.warnException((String)"common_license_maxCount", (Object[])new Object[0]);
        }
        ZKResultMsg res = new ZKResultMsg();
        this.authDepartmentService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"auth:department:refresh"})
    public DxGrid list(AuthDepartmentItem codition) {
        Pager pager = this.authDepartmentService.loadPagerByAuthDeptFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="pers_module", object="pers_department", opType="common_op_del", requestParams={"names"}, opContent="pers_dept_deptName")
    @RequiresPermissions(value={"auth:department:del"})
    public ZKResultMsg del(String ids) {
        this.authDepartmentService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem tree(Boolean showPersonCount) {
        List authDepartmentItems = this.authDepartmentService.getAuthDeptFilter(this.request.getSession().getId(), new AuthDepartmentItem());
        List<TreeItem> treeItems = this.getTreeItems(authDepartmentItems);
        if (Objects.nonNull(showPersonCount) && showPersonCount.booleanValue()) {
            Map personCountMap = this.authDepartmentService.getAllDeptPersonCount();
            for (TreeItem node : treeItems) {
                this.buildPersonCount(node, personCountMap);
            }
        }
        return new TreeItem("0", treeItems);
    }

    public Tree dynaTree(String id, Boolean showPersonCount) {
        AuthDepartmentItem condition = new AuthDepartmentItem();
        if (!this.isQueryToDept(id)) {
            condition.setParentId(id);
        }
        List<AuthDepartmentItem> authDepartmentItems = this.authDepartmentService.getAuthDeptFilter(this.request.getSession().getId(), condition);
        Set isHasChild = null;
        if (this.isQueryToDept(id) && !CollectionUtils.isEmpty((Collection)authDepartmentItems)) {
            authDepartmentItems = this.getTopAndTwoDept(authDepartmentItems);
            isHasChild = authDepartmentItems.stream().map(AuthDepartmentItem::getParentId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        Map personCountMap = null;
        if (Objects.nonNull(showPersonCount) && showPersonCount.booleanValue() && !CollectionUtils.isEmpty(authDepartmentItems)) {
            personCountMap = this.authDepartmentService.getAllDeptPersonCount();
        }
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthDepartmentItem depart : authDepartmentItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            if (Objects.nonNull(showPersonCount) && showPersonCount.booleanValue()) {
                item.setText(String.valueOf(item.getText()) + "(" + MapUtils.getInteger((Map)personCountMap, (Object)item.getId(), (Integer)0) + ")");
            }
            item.setChild("1");
            if (this.isQueryToDept(id) && Objects.isNull(depart.getParentId())) {
                if (Objects.nonNull(isHasChild) && isHasChild.contains(depart.getId())) {
                    item.setOpen("1");
                } else {
                    item.setOpen(null);
                    item.setChild(null);
                }
            } else {
                item.setOpen(null);
            }
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    private List<TreeItem> getTreeItems(List<AuthDepartmentItem> authDepartmentItems) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthDepartmentItem depart : authDepartmentItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            item.setOpen(null);
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        return TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
    }

    private boolean isQueryToDept(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }

    private List<AuthDepartmentItem> getTopAndTwoDept(List<AuthDepartmentItem> authDepartmentItems) {
        Map authDeptMap = authDepartmentItems.stream().collect(Collectors.toMap(AuthDepartmentItem::getId, Function.identity()));
        List<AuthDepartmentItem> topAndTwo = authDepartmentItems.stream().filter(item -> Objects.isNull(item.getParentId()) || !authDeptMap.containsKey(item.getParentId())).collect(Collectors.toList());
        Map topMap = topAndTwo.stream().collect(Collectors.toMap(AuthDepartmentItem::getId, Function.identity()));
        List twoList = authDepartmentItems.stream().filter(item -> Objects.nonNull(item.getParentId()) && topMap.containsKey(item.getParentId())).collect(Collectors.toList());
        topAndTwo.addAll(twoList);
        return topAndTwo;
    }

    public DxGrid listSelect(AuthDepartmentSelectItem codition) {
        Pager pager = this.authDepartmentService.loadDeptSelectByAuthDeptFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid listSelectDept(AuthDepartmentSelectDeptItem codition) {
        AuthDepartmentSelectItem authDepartmentSelectItem = new AuthDepartmentSelectItem();
        authDepartmentSelectItem.setName(codition.getName());
        Pager pager = this.authDepartmentService.loadDeptSelectByAuthDeptFilter(this.request.getSession().getId(), authDepartmentSelectItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, authDepartmentSelectItem.getClass());
    }

    private int buildPersonCount(TreeItem item, Map<String, Integer> personCountMap) {
        int personCount = MapUtils.getInteger(personCountMap, (Object)item.getId(), (Integer)0);
        if (item.hasChildren()) {
            for (TreeItem child : item.getChildren()) {
                this.buildPersonCount(child, personCountMap);
            }
        }
        item.setText(String.valueOf(item.getText()) + "(" + personCount + ")");
        return personCount;
    }

    public String validCode(String code) {
        AuthDepartmentItem item = this.authDepartmentService.getItemByCode(code);
        return String.valueOf(item == null);
    }

    public String validName(String id, String parentId, String name) {
        boolean rs = true;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AuthDepartmentItem item = this.authDepartmentService.getItemById(id);
            StringUtils.isNotBlank((CharSequence)parentId);
        } else {
            StringUtils.isNotBlank((CharSequence)parentId);
        }
        return String.valueOf(rs);
    }

    @RequiresPermissions(value={"auth:department:import"})
    @LogRequest(module="pers_module", object="pers_department", opType="common_op_import", requestParams={}, opContent="common_op_import")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0])) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0])) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), AuthDepartmentItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, String.valueOf(I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0])) + "<br/>"));
            ZKResultMsg res = this.authDepartmentService.importData(itemList);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)res);
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public ZKResultMsg getParentsIds(@RequestParam(value="id") String id) {
        List parentIds = this.authDepartmentService.getParentsIdsByAuthDeptFilter(this.request.getSession().getId(), id);
        ZKResultMsg result = new ZKResultMsg();
        result.setData((Object)parentIds);
        return result;
    }

    @RequiresPermissions(value={"auth:department:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AuthDepartmentItem authDepartmentItem = new AuthDepartmentItem();
        this.setConditionValue((BaseItem)authDepartmentItem);
        String deptIds = this.authDepartmentService.getDeptIdsByIdAndCodeAndName(request.getSession().getId(), authDepartmentItem.getParentId(), authDepartmentItem.getCode(), authDepartmentItem.getName());
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            authDepartmentItem.setInId(deptIds);
            authDepartmentItem.setParentId(null);
        }
        List intemList = this.authDepartmentService.getItemData(AuthDepartmentItem.class, authDepartmentItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AuthDepartmentItem.class);
    }

    @RequiresPermissions(value={"auth:department:exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        String fileName;
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String gridName = fileName = I18nUtil.i18nCode((String)"auth_dept_exportTemplateFileName", (Object[])new Object[0]);
        reportType = reportType.toLowerCase();
        try {
            try {
                String agent = this.request.getHeader("User-Agent").toLowerCase();
                if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "ISO-8859-1");
                    fileName = fileName.replace("%2520", " ");
                } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                    fileName = fileName.replaceAll(" ", "%20");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    fileName = fileName.replace("%2520", " ");
                } else {
                    fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                }
                this.response.setCharacterEncoding("utf-8");
                this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
                this.response.setContentType("application/octet-stream");
                ServletOutputStream os = this.response.getOutputStream();
                ExcelUtil.excelExport(new ArrayList(), AuthDepartmentItem.class, (String)jsonColumn, (String)gridName, (OutputStream)os, (String)reportType, null);
                os.flush();
            }
            catch (Exception var14) {
                this.log.error(String.valueOf(fileName) + " export error", (Throwable)var14);
                this.response.setHeader("Content-Disposition", "");
                this.response.setContentType("application/json");
                throw new ZKBusinessException("common_report_exportFaild");
            }
        }
        finally {
            this.authDepartmentService.setExportResult(this.request.getSession().getId(), "end");
        }
    }

    public ZKResultMsg isItself(String id, String parentId) {
        Boolean isItselfOrChild = true;
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)parentId)) {
            isItselfOrChild = id.equals(parentId) ? Boolean.valueOf(false) : Boolean.valueOf(this.authDepartmentService.isChild(Arrays.asList(id), parentId) == false);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)isItselfOrChild));
    }

    public ZKResultMsg isDepartmentNameExist(String id, String parentId, String name) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.authDepartmentService.isDepartmentNameExist(id, parentId, name)));
    }
}

