/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.AuthCompanyRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthAppService;
import com.zkteco.zkbiosecurity.auth.service.AuthCompanyService;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.auth.vo.AuthCompanyItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthCompanyController
extends BaseController
implements AuthCompanyRemote {
    @Autowired
    private AuthCompanyService authCompanyService;
    @Autowired
    private AuthAppService authAppService;
    @Autowired
    private AuthDepartmentService authDepartmentService;

    @RequiresPermissions(value={"auth:company"})
    public ModelAndView index() {
        return new ModelAndView("auth/company/authCompany");
    }

    @RequiresPermissions(value={"auth:company:modifyPwd"})
    public ModelAndView modify(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authCompanyService.getItemById(id));
        }
        return new ModelAndView("auth/company/modifyAuthCompanyPwd");
    }

    @RequiresPermissions(value={"auth:company:modifyPwd"})
    public ZKResultMsg modifyPwd(AuthCompanyItem item) {
        ZKResultMsg res = ZKResultMsg.msg((boolean)this.authCompanyService.modifyPwd(item));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"auth:company:refresh"})
    public DxGrid list(AuthCompanyItem codition) {
        Pager pager = this.authCompanyService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"auth:company:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.authCompanyService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"auth:company:audit"})
    public ZKResultMsg audit(String ids) {
        ZKResultMsg retMsg = ZKResultMsg.msg((boolean)this.authCompanyService.auditByIds(ids));
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg vaildPwd(String adminPwd) {
        boolean vaild = this.authCompanyService.vaildPwd(this.request.getSession().getId(), adminPwd);
        ZKResultMsg retMsg = ZKResultMsg.msg((boolean)vaild);
        retMsg.setData((Object)vaild);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public Tree dynaTree(String id, Boolean showPersonCount) {
        List authCompanyItemList = this.authCompanyService.getAuthCompanyFilter(this.request.getSession().getId(), id);
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthCompanyItem authCompanyItem : authCompanyItemList) {
            List appIdList = this.authAppService.getAppIdsByCompanyId(authCompanyItem.getId());
            String appIds = StringUtils.join((Iterable)appIdList, (String)",");
            if (StringUtils.isBlank((CharSequence)id)) {
                item = new TreeItem();
                item.setId("appIds:" + appIds);
                item.setText(authCompanyItem.getCompanyName());
                item.setChild("1");
                item.setOpen(null);
                items.add(item);
            }
            AuthDepartmentItem authDepartmentItem = new AuthDepartmentItem();
            authDepartmentItem.setInAppId(appIds);
            if (!this.isQueryToDept(id) && !authCompanyItem.getId().equals(id)) {
                authDepartmentItem.setParentId(id);
            }
            List<AuthDepartmentItem> authDepartmentItems = this.authDepartmentService.getByCondition(authDepartmentItem);
            Set isHasChild = null;
            if (this.isQueryToDept(id) && !CollectionUtils.isEmpty((Collection)authDepartmentItems)) {
                authDepartmentItems = this.getTopAndTwoDept(authDepartmentItems);
                isHasChild = authDepartmentItems.stream().map(AuthDepartmentItem::getParentId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            }
            Map personCountMap = null;
            if (Objects.nonNull(showPersonCount) && showPersonCount.booleanValue() && !CollectionUtils.isEmpty(authDepartmentItems)) {
                personCountMap = this.authDepartmentService.getAllDeptPersonCount();
            }
            for (AuthDepartmentItem depart : authDepartmentItems) {
                item = new TreeItem();
                item.setId(depart.getId());
                item.setText(depart.getName());
                if (Objects.nonNull(showPersonCount) && showPersonCount.booleanValue()) {
                    item.setText(String.valueOf(item.getText()) + "(" + MapUtils.getInteger((Map)personCountMap, (Object)item.getId(), (Integer)0) + ")");
                }
                item.setChild("1");
                if (this.isQueryToDept(id) && Objects.isNull(depart.getParentId())) {
                    if (Objects.nonNull(isHasChild) && isHasChild.contains(depart.getId())) {
                        item.setOpen("1");
                    } else {
                        item.setOpen(null);
                        item.setChild(null);
                    }
                } else {
                    item.setOpen(null);
                }
                pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("appIds:" + appIds);
                item.setParent(pItem);
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    @RequiresPermissions(value={"auth:company:modifyPosition"})
    public ModelAndView modifyPosition(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.authCompanyService.getItemById(id));
        }
        return new ModelAndView("auth/company/modifyAuthCompanyPosition");
    }

    @RequiresPermissions(value={"auth:company:modifyPosition"})
    @LogRequest(module="system_module", object="auth_company", opType="auth_company_modifyPosition", requestParams={"companyName"}, opContent="auth_company_companyName")
    public ZKResultMsg modifyCompanyPosition(AuthCompanyItem authCompanyItem) {
        if (StringUtils.isNotBlank((CharSequence)authCompanyItem.getId())) {
            if (StringUtils.isBlank((CharSequence)authCompanyItem.getLongitude())) {
                authCompanyItem.setLongitude(null);
            }
            this.authCompanyService.modifyCompanyPosition(authCompanyItem);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    private List<AuthDepartmentItem> getTopAndTwoDept(List<AuthDepartmentItem> authDepartmentItems) {
        Map authDeptMap = authDepartmentItems.stream().collect(Collectors.toMap(AuthDepartmentItem::getId, Function.identity()));
        List<AuthDepartmentItem> topAndTwo = authDepartmentItems.stream().filter(item -> Objects.isNull(item.getParentId()) || !authDeptMap.containsKey(item.getParentId())).collect(Collectors.toList());
        Map topMap = topAndTwo.stream().collect(Collectors.toMap(AuthDepartmentItem::getId, Function.identity()));
        List twoList = authDepartmentItems.stream().filter(item -> Objects.nonNull(item.getParentId()) && topMap.containsKey(item.getParentId())).collect(Collectors.toList());
        topAndTwo.addAll(twoList);
        return topAndTwo;
    }

    private boolean isQueryToDept(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }
}

