/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.remote.AuthBioVerifyRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthBioVerifyService;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthBioVerifyController
extends BaseController
implements AuthBioVerifyRemote {
    @Autowired
    private AuthBioVerifyService authBioVerifyService;

    public ZKResultMsg fpComparison(@RequestParam(value="verifyTemplate") String verifyTemplate, @RequestParam(value="templates") String templates) {
        String msgStr = "";
        boolean isExist = false;
        String[] templateArray = null;
        if (!StringUtils.isBlank((CharSequence)templates)) {
            if (templates.contains("[") && templates.contains("]")) {
                Pattern pattern = Pattern.compile("\\[\"(.*?)\"\\]");
                Matcher matcher = pattern.matcher(templates);
                templates = matcher.group(1);
            }
            templateArray = templates.split(",");
        }
        String ret = "";
        boolean connRet = this.authBioVerifyService.existFpServer();
        if (templateArray.length > 0) {
            if (connRet) {
                int i = 0;
                while (i < templateArray.length) {
                    JSONObject retJson;
                    ret = this.authBioVerifyService.oneToOne(templateArray[i], verifyTemplate);
                    if (StringUtils.isNotBlank((CharSequence)ret) && (retJson = JSONObject.parseObject((String)ret)).containsKey((Object)"score") && !retJson.getString("score").equals("0")) {
                        isExist = true;
                        break;
                    }
                    ++i;
                }
            } else {
                msgStr = "noFingerServer";
            }
        }
        this.log.info("-----------------------------   fpComparison ret: " + isExist);
        if (isExist) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)msgStr));
    }

    public String getFingerServiceConn() {
        String retStr = "400";
        try {
            if (this.authBioVerifyService.existFpServer()) {
                retStr = "ok";
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return retStr;
    }

    public String clearFPTemplate() {
        String retStr = "";
        try {
            String ret = this.authBioVerifyService.getFPServerInfo();
            JSONObject retJson = JSONObject.parseObject((String)ret);
            if (retJson.containsKey((Object)"count")) {
                retStr = "ok";
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return retStr;
    }

    public ZKResultMsg fpComparisonOneToMany(@RequestParam(value="verifyTemplate") String verifyTemplate) {
        String userId = this.authBioVerifyService.comparison(verifyTemplate);
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

