/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.MD5Util;
import com.zkteco.zkbiosecurity.security.SessionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v1"})
public class AppAuthController {
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private AuthUserService authUserService;
    @Autowired
    protected HttpServletResponse resp;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/areaTrees"}, method={RequestMethod.POST})
    public AppResultMessage areaTrees(@RequestBody JSONObject data) {
        AppResultMessage appResultMessage = new AppResultMessage();
        String userName = this.request.getParameter("user_name");
        String areaId = data.getString("areaId");
        AuthAreaItem condition = new AuthAreaItem();
        AuthUserItem authUserItem = this.authUserService.getItemByUsername(userName);
        if (authUserItem == null) {
            return appResultMessage;
        }
        if (!authUserItem.getIsSuperuser().booleanValue()) {
            condition.setUserId(authUserItem.getId());
        }
        List authAreaItems = this.authAreaService.getByCondition(condition);
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AuthAreaItem depart : authAreaItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List<Object> treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        if (StringUtils.isNotBlank((CharSequence)areaId)) {
            item = this.findSubtree((List<TreeItem>)treeItems, areaId);
            treeItems = Objects.nonNull(item) ? Arrays.asList(item) : new ArrayList();
        }
        return appResultMessage.setData((Object)new TreeItem("0", (List)treeItems));
    }

    private TreeItem findSubtree(List<TreeItem> treeItems, String areaId) {
        for (TreeItem node : treeItems) {
            if (node.getId().equals(areaId)) {
                return node;
            }
            TreeItem found = this.findSubtree(node.getItem(), areaId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @RequestMapping(path={"/photoBase64"}, method={RequestMethod.POST})
    public AppResultMessage photoBase64Handle(@RequestBody JSONObject data) {
        String path = data.getString("path");
        if (StringUtils.isBlank((CharSequence)path)) {
            return AppResultMessage.successMessage();
        }
        String token = data.getString("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            String apitimestamp = data.getString("timestamp");
            String nonceStr = data.getString("nonce");
            String signature = data.getString("sign");
            if (StringUtils.isBlank((CharSequence)apitimestamp)) {
                return AppResultMessage.failMessage((String)"no api auth param timestamp error");
            }
            if (StringUtils.isBlank((CharSequence)nonceStr)) {
                return AppResultMessage.failMessage((String)"no api auth param nonceStr error");
            }
            if (StringUtils.isBlank((CharSequence)signature)) {
                return AppResultMessage.failMessage((String)"no api auth param signature error");
            }
            Long timestamp = System.currentTimeMillis();
            if (timestamp - Long.parseLong(apitimestamp) > 600000L) {
                return AppResultMessage.failMessage((String)"no api auth timestamp 10m");
            }
            nonceStr = StringUtils.substring((String)nonceStr, (int)4, (int)16);
            String sign = MD5Util.entype((String)(String.valueOf(path) + nonceStr + apitimestamp)).toUpperCase();
            if (StringUtils.isBlank((CharSequence)signature) || !signature.equals(sign)) {
                return AppResultMessage.failMessage((String)"no api auth signature error");
            }
        } else if (!this.sessionManager.checkToken(token).booleanValue()) {
            throw new ZKBusinessException("526", I18nUtil.i18nCode((String)"app_token_error_info1", (Object[])new Object[0]));
        }
        return AppResultMessage.successMessage().setData((Object)FileEncryptUtil.getDecryptFileBase64((String)path));
    }
}

