/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.api.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSecurityParamsService;
import com.zkteco.zkbiosecurity.auth.service.AuthVerifyCodeService;
import com.zkteco.zkbiosecurity.auth.util.AuthVerifyCodeUtil;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.security.SessionManager;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/token/api/authClient"})
public class AuthClientController
extends BaseController {
    @Autowired
    private AuthVerifyCodeService authVerifyCodeService;
    @Autowired
    private AuthSecurityParamsService authsecurityParamsService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/getVerifyCode"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void getVerifyCode(@RequestParam(value="id") String sessionId) {
        try {
            this.response.setHeader("Pragma", "No-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType("image/jpeg");
            int w = 130;
            int h = 40;
            String verifyCode = AuthVerifyCodeUtil.generateVerifyCode(4);
            AuthVerifyCodeUtil.outputImage(w, h, (OutputStream)this.response.getOutputStream(), verifyCode);
            this.authVerifyCodeService.bindVerifyCodeWhithSessionId(sessionId, verifyCode);
        }
        catch (Exception e) {
            this.log.error("Verify Code Create Error:", (Throwable)e);
        }
    }

    @RequestMapping(value={"/getIsNeedVerCodeParams"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getIsNeedVerCodeParams(@RequestParam(value="id", required=false) String sessionId) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        HashMap<String, String> resMap = new HashMap<String, String>(1);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = this.request.getSession().getId();
        }
        boolean res = this.authsecurityParamsService.getIsNeedVerCodeParams(sessionId);
        resMap.put("needVerCode", String.valueOf(res));
        resMap.put("sessionId", sessionId);
        resultMsg.setData(resMap);
        return resultMsg;
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg logout(@RequestParam(value="sessionId") String sessionId) {
        this.sessionManager.deleteOldSession(sessionId);
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        return zkResultMsg;
    }
}

