/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.aop;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.security.exception.AuthorizationException;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class PermissionAspect {
    @Autowired
    private AuthSessionServcie authSessionServcie;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    private RedisTemplate<String, SecuritySubject> redisTemplate;

    @Pointcut(value="within(com.zkteco.zkbiosecurity..controller..*)")
    public void permissionPointcut() {
    }

    @Around(value="permissionPointcut() && @annotation(requiresPermissions)")
    public Object doInterceptor(ProceedingJoinPoint pjp, RequiresPermissions requiresPermissions) throws Throwable {
        boolean isPermission = false;
        String accessToken = this.request.getParameter("access_token");
        String tokenHeader = this.request.getHeader("Access-Token");
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(WebContextUtil.getCurrentSessionId());
        if (!StringUtils.isEmpty((Object)tokenHeader)) {
            securitySubject = this.getSecuritySubjectByToken(tokenHeader);
        } else if (!StringUtils.isEmpty((Object)accessToken)) {
            securitySubject = this.getSecuritySubjectByToken(accessToken);
        }
        if (requiresPermissions != null) {
            String[] permissions;
            String[] stringArray = permissions = requiresPermissions.value();
            int n = permissions.length;
            int n2 = 0;
            while (n2 < n) {
                String per = stringArray[n2];
                if (securitySubject != null && securitySubject.hasPermission(per)) {
                    isPermission = true;
                    break;
                }
                ++n2;
            }
        } else {
            isPermission = true;
        }
        if (isPermission) {
            return pjp.proceed();
        }
        throw new AuthorizationException("not auth forbidden");
    }

    public SecuritySubject getSecuritySubjectByToken(String accessToken) {
        SecuritySubject securitySubject = new SecuritySubject();
        if (StringUtils.isEmpty((Object)accessToken)) {
            return securitySubject;
        }
        String username = (accessToken = EncrypAESUtil.decryptToString((String)accessToken)).split("_")[0];
        String key = "auth:access_token:" + username;
        if (this.redisTemplate.hasKey((Object)key).booleanValue()) {
            securitySubject = (SecuritySubject)this.redisTemplate.opsForValue().get((Object)key);
        }
        return securitySubject;
    }
}

