/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.constants.BasePrintTemplateConstants;
import com.zkteco.zkbiosecurity.system.service.BasePrintParamService;
import com.zkteco.zkbiosecurity.system.service.BasePrintTemplateService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BasePrintParamItem;
import com.zkteco.zkbiosecurity.system.vo.BasePrintTemplateItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.constants.VisTemplateConstants;
import com.zkteco.zkbiosecurity.vis.service.VisAlertTemplateService;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisReasonService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListCategoryService;
import com.zkteco.zkbiosecurity.vis.service.VisWfFlowService;
import com.zkteco.zkbiosecurity.vis.vo.VisAlertTemplateItem;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReasonItem;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=70)
public class VisInit
implements CommandLineRunner {
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired(required=false)
    private BaseSysParamService baseSysParamService;
    @Autowired(required=false)
    private VisReasonService visReasonService;
    @Autowired
    private VisPlaceService visPlaceService;
    @Autowired
    private VisWatchListCategoryService visWatchListCategoryService;
    @Autowired
    private BasePrintTemplateService basePrintTemplateService;
    @Autowired
    private BasePrintParamService basePrintParamService;
    @Autowired
    private VisAlertTemplateService visAlertTemplateService;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Autowired
    private VisLevelService visLevelService;
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisWfFlowService visWfFlowService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("VisInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initVisParams();
            this.initVisReason();
            this.initVisPlace();
            this.initPrintTemplate();
            this.initVisAlertTemplate();
            this.initVisPersonnalList();
            if ("zh_CN".equals(this.language)) {
                this.initVisWfFlow();
            }
            if (!"zh_CN".equals(this.language) && !this.isCloud.booleanValue()) {
                this.initAppMenus();
            }
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("VisInit");
        }
        this.initVisAdvancedShowLicense();
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Vis", "vis_module", "vis", "system", "true", Integer.valueOf(7));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("VisVisitorRegistration", "vis_leftMenu_register", "vis:visitor:registration", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("visPCRegistration.do");
        subMenuItem1.setImg("vis_register.png");
        subMenuItem1.setImgHover("vis_register_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("VisRegistration", "vis_leftMenu_PCRegistration", "vis:registration", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visPCRegistration.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("VisRegistrationRefresh", "common_op_refresh", "vis:registration:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisRegistrationEdit", "common_op_edit", "vis:registration:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisRegistrationRegister", "vis_leftMenu_enterRegistration", "vis:registration:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisRegistrationExit", "vis_op_exit", "vis:registration:exit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (!this.language.equals("zh_CN")) {
            subButtonItem = new AuthPermissionItem("VisPerClone", "vis_per_clone", "vis:registration:clone", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("VisRegistrationBatchCheckIn", "vis_op_batchCheckIn", "vis:registration:add", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisRegistrationBatchCheckOut", "vis_op_batchCheckOut", "vis:registration:exit", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisVisitor", "vis_leftMenu_empinfo", "vis:visitor", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visVisitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisVisitorRefresh", "common_op_refresh", "vis:visitor:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorDel", "common_op_del", "vis:visitor:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorAddBlackList", "vis_emp_disable", "vis:visitor:addBlackList", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorRemoveBlackList", "vis_emp_enable", "vis:visitor:removeBlackList", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorExport", "common_op_export", "vis:visitor:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("VisVisitorReservation", "vis_leftMenu_reservation", "vis:visitor:reservation", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("visReservation.do");
        subMenuItem1.setImg("vis_reservation.png");
        subMenuItem1.setImgHover("vis_reservation_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("VisReservation", "vis_leftMenu_reservation", "vis:reservation", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visReservation.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisReservationRefresh", "common_op_refresh", "vis:reservation:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReservationEdit", "common_op_edit", "vis:reservation:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReservationDel", "common_op_del", "vis:reservation:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReservationAuditAudit", "vis_reservation_audit", "vis:reservationAudit:audit", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReservationAuditRefuse", "vis_reservation_refuse", "vis:reservationAudit:refuse", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (!this.language.equals("zh_CN")) {
            subButtonItem = new AuthPermissionItem("VisReservationAdd", "common_op_new", "vis:reservation:add", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationImport", "common_op_import", "vis:reservation:import", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationExportTemplate", "pers_export_template", "vis:reservation:exportTemplate", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (!this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("VisReservationInvitation", "vis_leftMenu_reservationInvitation", "vis:reservationInvitation", "menu", "true", Integer.valueOf(2));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("visReservationInvitation.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisReservationInvitationRefresh", "common_op_refresh", "vis:reservationInvitation:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationInvitationEdit", "common_op_edit", "vis:reservationInvitation:edit", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationInvitationAdd", "common_op_new", "vis:reservationInvitation:add", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationInvitationDel", "common_op_del", "vis:reservationInvitation:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisReservationInvitationResend", "vis_reservation_resend", "vis:reservationInvitation:resend", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        } else {
            subMenuItem = new AuthPermissionItem("VisInvitation", "vis_leftMenu_reservationInvitation", "vis:invitation", "menu", "true", Integer.valueOf(2));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("visInvitation.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisInvitationRefresh", "common_op_refresh", "vis:invitation:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisInvitationEdit", "common_op_edit", "vis:invitation:edit", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisInvitationAudit", "vis_reservation_audit", "vis:invitation:audit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisInvitationDel", "common_op_del", "vis:invitation:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisInvitationCancel", "vis_cloud_cancelInvite", "vis:invitation:cancel", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem1 = new AuthPermissionItem("VisBasicManager", "vis_leftMenu_basicManagement", "vis:basic:manager", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("visParamSet.do");
        subMenuItem1.setImg("comm_setParam.png");
        subMenuItem1.setImgHover("comm_setParam_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("VisParams", "common_leftMenu_paramSet", "vis:params", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisParamsEdit", "common_op_edit", "vis:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisEquipment", "vis_leftMenu_equipmentDebugging", "vis:equipment", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visEquipment.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subMenuItem = new AuthPermissionItem("VisPrintTemplate", "vis_leftMenu_printSettings", "vis:printTemplate", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visPrintTemplate.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisPrintTemplateEdit", "common_op_edit", "vis:printTemplate:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisLevel", "vis_leftMenu_level", "vis:level", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisLevelRefresh", "common_op_refresh", "vis:level:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (this.visLevelService.isExistAcc()) {
            subButtonItem = new AuthPermissionItem("VisLevelSaveAccLevel", "vis_level_accLevel", "vis:level:saveAccLevel", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("ele")) {
            subButtonItem = new AuthPermissionItem("VisLevelSaveEleLevel", "vis_level_eleLevel", "vis:level:saveEleLevel", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("psg")) {
            subButtonItem = new AuthPermissionItem("VisLevelSavePsgLevel", "vis_level_psgLevel", "vis:level:savePsgLevel", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("pid")) {
            subButtonItem = new AuthPermissionItem("VisLevelSavePidDevice", "vis_level_pidDevice", "vis:level:savePidDevice", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("VisLevelSelectVisitor", "vis_level_addVisitor", "vis:level:selectVisitor", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisLevelDel", "common_op_del", "vis:level:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorLevelRefresh", "common_op_refresh", "vis:visitorLevel:refresh", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorLevelDel", "vis_level_delVisitor", "vis:visitorLevel:del", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisCommonLevel", "vis_leftMenu_common_level", "vis:commonLevel", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visCommonLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisCommonLevelRefresh", "common_op_refresh", "vis:commonLevel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (this.visLevelService.isExistAcc()) {
            subButtonItem = new AuthPermissionItem("VisCommonLevelSaveAccLevel", "vis_level_accLevel", "vis:commonLevel:saveAccLevel", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("ele")) {
            subButtonItem = new AuthPermissionItem("VisCommonLevelSaveEleLevel", "vis_level_eleLevel", "vis:commonLevel:saveEleLevel", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("psg")) {
            subButtonItem = new AuthPermissionItem("VisCommonLevelSavePsgLevel", "vis_level_psgLevel", "vis:commonLevel:savePsgLevel", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        if (this.visLevelService.isExistModuleByCode("pid")) {
            subButtonItem = new AuthPermissionItem("VisCommonLevelSavePidDevice", "vis_level_pidDevice", "vis:commonLevel:savePidDevice", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("VisCommonLevelDel", "common_op_del", "vis:commonLevel:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorCommonLevelRefresh", "common_op_refresh", "vis:visitorCommonLevel:refresh", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorCommonLevelDel", "vis_level_delVisitor", "vis:visitorCommonLevel:del", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisVisitedPerson", "vis_leftMenu_person", "vis:visitedPerson", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visVisitedPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisVisitedPersonRefresh", "common_op_refresh", "vis:visitedPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitedPersonAdd", "common_op_new", "vis:visitedPerson:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitedPersonDel", "common_op_del", "vis:visitedPerson:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (this.language.equals("zh_CN")) {
            subButtonItem = new AuthPermissionItem("VisVisitedPersonAuthorized", "vis_visitedPerson_authorizedExemptionInvitation", "vis:visitedPerson:authorized", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("VisLevelSelectPersonLevel", "vis_level_visitedLevel", "vis:level:selectPersonLevel", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPersonLevelRefresh", "common_op_refresh", "vis:personLevel:refresh", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPersonLevelDel", "common_op_del", "vis:personLevel:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisLevelSelectBatchPersonLevel", "vis_level_batchVisitedLevel", "vis:level:selectBatchPersonLevel", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisDepartment", "vis_leftMenu_department", "vis:visitedDepartment", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visVisitedDepartment.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisVisitedDepartmentRefresh", "common_op_refresh", "vis:visitedDepartment:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitedDepartmentAdd", "common_op_new", "vis:visitedDepartment:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitedDepartmentDel", "common_op_del", "vis:visitedDepartment:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisLevelSelectDeptLevel", "vis_level_visitedLevel", "vis:level:selectDeptLevel", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisDepartmentLevelRefresh", "common_op_refresh", "vis:departmentLevel:refresh", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisDepartmentLevelDel", "common_op_del", "vis:departmentLevel:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisPlace", "vis_leftMenu_place", "vis:place", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visPlace.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisPlaceRefresh", "common_op_refresh", "vis:place:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPlaceAdd", "common_op_new", "vis:place:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPlaceEdit", "common_op_edit", "vis:place:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPlaceDel", "common_op_del", "vis:place:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisPlaceSavePoint", "vis_leftMenu_autoExitPlace", "vis:autoExit:view", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisReason", "vis_leftMenu_reason", "vis:reason", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visReason.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisReasonRefresh", "common_op_refresh", "vis:reason:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReasonAdd", "common_op_new", "vis:reason:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReasonEdit", "common_op_edit", "vis:reason:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisReasonDel", "common_op_del", "vis:reason:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisAttribute", "pers_attribute", "vis:attribute", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visAttribute.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisAttributeRefresh", "common_op_refresh", "vis:attribute:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisAttributeAdd", "common_op_new", "vis:attribute:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisAttributeEdit", "common_op_edit", "vis:attribute:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisAttributeDel", "common_op_del", "vis:attribute:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (!this.language.equals("zh_CN")) {
            subMenuItem1 = new AuthPermissionItem("VisAdvanced", "vis_leftMenu_advanced", "vis:visitor:advanced", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setActionLink("watchList.do");
            subMenuItem1.setImg("vis_advanced.png");
            subMenuItem1.setImgHover("vis_advanced_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
            subMenuItem = new AuthPermissionItem("VisWatchListCategory", "vis_leftMenu_watchListCategory", "vis:watchListCategory", "menu", "true", Integer.valueOf(1));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("watchList.do?categoryView");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("ViswatchListCategoryRefresh", "common_op_refresh", "vis:watchListCategory:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("ViswatchListCategoryAdd", "common_op_new", "vis:watchListCategory:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("ViswatchListCategoryEdit", "common_op_edit", "vis:watchListCategory:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("ViswatchListCategoryDel", "common_op_del", "vis:watchListCategory:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("VisWatchList", "vis_leftMenu_watchList", "vis:watchList", "menu", "true", Integer.valueOf(2));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("watchList.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisWatchListRefresh", "common_op_refresh", "vis:watchList:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisWatchListAdd", "common_op_new", "vis:watchList:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisWatchListEdit", "common_op_edit", "vis:watchList:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisWatchListDel", "common_op_del", "vis:watchList:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisWatchListDisable", "common_disable", "vis:watchList:disable", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisWatchListEnable", "common_enable", "vis:watchList:enable", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("VisWatchListThumbnails", "vis_leftMenu_watchListThumbnails", "vis:watchListThumbnails", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("watchList.do?ThumbnailsView");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisWatchListThumbnailsRefresh", "common_op_refresh", "vis:watchListThumbnails:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("VisAlertTemplate", "vis_leftMenu_alertTemplate", "vis:alertTemplate", "menu", "true", Integer.valueOf(4));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("visAlertTemplate.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisAlertTemplateRefresh", "common_op_refresh", "vis:alertTemplate:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisAlertTemplateAdd", "common_op_new", "vis:alertTemplate:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisAlertTemplateEdit", "common_op_edit", "vis:alertTemplate:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisAlertTemplateDel", "common_op_del", "vis:alertTemplate:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("VisLinkage", "vis_leftMenu_linkage", "vis:linkage", "menu", "true", Integer.valueOf(5));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("visLinkage.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisLinkageRefresh", "common_op_refresh", "vis:linkage:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisLinkageAdd", "common_op_new", "vis:linkage:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisLinkageEdit", "common_op_edit", "vis:linkage:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisLinkageDel", "common_op_del", "vis:linkage:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisLinkageDisableLinkage", "common_disable", "vis:linkage:disableLinkage", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisLinkageEnableLinkage", "common_enable", "vis:linkage:enableLinkage", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem1 = new AuthPermissionItem("VisVisitorTransaction", "vis_leftMenu_reports", "vis:visitor:transaction", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("visTransaction.do");
        subMenuItem1.setImg("comm_reports.png");
        subMenuItem1.setImgHover("comm_reports_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("VisVisitorLastAddr", "vis_leftMenu_lastAddr", "vis:visitorLastAddr", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visVisitorLastAddr.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisVisitorLastAddrRefresh", "common_op_refresh", "vis:visitorLastAddr:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisVisitorLastAddrExport", "common_op_export", "vis:visitorLastAddr:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("VisTransaction", "vis_leftMenu_record", "vis:transaction", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("visTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("VisTransactionRefresh", "common_op_refresh", "vis:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisTransactionDel", "common_op_del", "vis:transaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("VisTransactionExport", "common_op_export", "vis:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if (this.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("VisAutoExitReport", "vis_leftMenu_autoExitRecord", "vis:autoExitReport", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("visAutoExitReport.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("VisAutoExitReportRefresh", "common_op_refresh", "vis:autoExitReport:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisAutoExitReportDel", "common_op_del", "vis:autoExitReport:del", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("VisAutoExitReportExport", "common_op_export", "vis:autoExitReport:export", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
    }

    public void initVisParams() {
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        BaseSysParamItem item = new BaseSysParamItem("visReportDataClean", values.toString(), "base_dataClean_visTrans");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isPrintReceipt", "0", "\u662f\u5426\u6253\u5370\u51ed\u6761 1\uff1a\u662f\uff0c 0\uff1a\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isNeedIssueCard", "1", "\u662f\u5426\u9700\u8981\u53d1\u5361 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isNeedFP", "0", "\u662f\u5426\u9700\u8981\u767b\u8bb0\u6307\u7eb9 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isNeedPwd", "0", "\u662f\u5426\u9700\u8981\u4f7f\u7528\u5bc6\u7801 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isNeedSC", "0", "\u662f\u5426\u9700\u8981\u626b\u7801\u5f00\u95e8 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.enableCardAutoExit", "0", "\u662f\u5426\u5f00\u542f\u5361\uff08\u6307\u7eb9\uff09\u81ea\u52a8\u7b7e\u79bb 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.enableAutoExit", "0", "\u662f\u5426\u5f00\u542f\u5b9a\u65f6\u7b7e\u79bb 1\uff1a\u662f\uff0c0\u3001\u5426"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.autoExitValidEndTime", "0 0/30 * * * ?", "\u5b9a\u65f6\u7b7e\u79bb\u65f6\u95f4\u70b9"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.alertTimeHour", "15", "\u63d0\u9192\u65f6\u95f4\u5c0f\u65f6"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.alertTimeMinute", "30", "\u63d0\u9192\u65f6\u95f4\u5206\u949f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.supportDevice", "ID", "\u662f\u5426\u4f7f\u7528\u8bc1\u4ef6\u76f8\u5173\u8bbe\u5907"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.recognition", "IDCardReader", "\u4f7f\u7528\u8bc1\u4ef6\u7c7b\u578b\uff08\u8eab\u4efd\u8bc1\u9605\u8bfb\u5668\u3001\u626b\u63cf\u4eea\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.captureType", "allow", "\u6293\u62cd\u65b9\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.printTemplate", "", "\u6253\u5370\u6a21\u677f\u5168\u5c40\u8bbe\u7f6e"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.captureTogether", "separate", "separate\u5206\u5f00\u62cd\uff0ctogether\u4e00\u8d77\u62cd"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.sendMailTime", "0 0 15 * * ?", "\u53d1\u9001\u90ae\u4ef6\u65f6\u95f4"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.autoExitTime", "0 0/5 * * * ?", "\u81ea\u52a8\u7b7e\u79bb\u65f6\u95f4"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.openExit", "1", "\u662f\u5426\u5f00\u542f\u7b7e\u79bb\u529f\u80fd"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.requiredVisitedEmp", "1", "\u62dc\u8bbf\u4eba\u5458\u662f\u5426\u5fc5\u586b"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.requiredVisitedDept", "1", "\u62dc\u8bbf\u90e8\u95e8\u662f\u5426\u5fc5\u586b"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.svn.version", "715", "svn\u7248\u672c"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.database.version", "1.0.0.7", "\u6570\u636e\u5e93\u7248\u672c"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.receiver", "", "\u6536\u4ef6\u4eba\u90ae\u7bb1"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.carAuthorization", "temporaryCar", "\u8bbf\u5ba2\u8f66\u8f86\u6388\u6743\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.goodsPhotograph", "0", "\u5f00\u542f\u7269\u62cd"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.ocrDriveVerson", "2", "ocr\u9a71\u52a8\u7248\u672c"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.cameraAdjust", "1", "\u94b1\u6797\u8bbf\u5ba2\u673a\u6444\u50cf\u5934\u8c03\u6574"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.openFloatBox", "0", "\u5f00\u542f\u6d6e\u52a8\u7a97\u53e3"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.sizeSetting", "0", "\u9ad8\u62cd\u4eea\u626b\u63cf\u5c3a\u5bf8"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.resolvingPower", "0", "\u9ad8\u62cd\u4eea\u5206\u8fa8\u7387"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.visitorReservation", "true", "\u662f\u5426\u542f\u7528\u4e91\u8bbf\u5ba2\u9884\u7ea6"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.reservation.audit", "0", "\u662f\u5426\u76f4\u63a5\u5ba1\u6838\u901a\u8fc7"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.ocrCertNoType", "1", "ocr\u56de\u586b\u8bc1\u4ef6\u53f7\u7801\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.reservation.auditOffline", "1", "\u81ea\u52a9\u9884\u7ea6\u662f\u5426\u76f4\u63a5\u5ba1\u6838\u901a\u8fc7"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.urlCreate", "", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.h5UploadPhoto", "1", "\u4e0a\u4f20\u4eba\u8138\u7167\u7247"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.defense", "0", "\u542f\u7528\u8bbf\u5ba2\u8bbe\u9632"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.isUseCKName", "1", "watchlist\u540d\u5b57\u5339\u914d\u89c4\u5219\u662f\u5426\u542f\u7528"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.wlCKName", "1", "watchlist\u59d3\u540d\u5339\u914d\u89c4\u5219"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.wlCKCertificate", "1", "watchlist\u8bc1\u4ef6\u5339\u914d"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.wlCKCountry", "1", "watchlist\u56fd\u5bb6\u5339\u914d"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.wlCKCompany", "1", "watchlist\u516c\u53f8\u5339\u914d"));
        if (this.visWatchListCategoryService.needInitCategory().booleanValue()) {
            this.visWatchListCategoryService.initCategory(VisConstants.INIT_WATCHLIST_CATEGORY);
        }
        this.baseSysParamService.initData(new BaseSysParamItem("vis.openInfoBox", "1", "\u5f00\u542f\u8bbf\u5ba2\u4fe1\u606f\u5f39\u7a97"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.backFillFingerprint", "1", "\u56de\u586b\u8bbf\u5ba2\u6307\u7eb9"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.backFillPhoto", "1", "\u56de\u586b\u8bbf\u5ba2\u7167\u7247"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.copyCardNumber", "0", "\u662f\u5426copy\u8eab\u4efd\u8bc1\u53f7\u7801\u5230\u5361\u53f7\u680f"));
        if (!this.language.equals("zh_CN")) {
            this.baseSysParamService.initData(new BaseSysParamItem("vis.openMaxVisitorForDay", "1", "\u662f\u5426\u5f00\u542f\u6bcf\u65e5\u6700\u5927\u8bbf\u5ba2"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.maxVisitorForDay", "100", "\u6700\u5927\u8bbf\u5ba2\u6570\u91cf"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.openMaxVisitorForPerson", "1", "\u662f\u5426\u5f00\u542f\u4e2a\u4eba\u6700\u5927\u8bbf\u5ba2\u6570\u91cf"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.maxVisitorForPerson", "30", "\u4e2a\u4eba\u6700\u5927\u8bbf\u5ba2\u6570\u91cf"));
        }
        this.baseSysParamService.initData(new BaseSysParamItem("vis.printingType", "receipt", "\u6253\u5370\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("visocr.version", "true", "visocr license", Boolean.valueOf(true)));
        this.baseSysParamService.initData(new BaseSysParamItem("visidreader.version", "true", "visidreader license", Boolean.valueOf(true)));
        this.baseSysParamService.initData(new BaseSysParamItem("vissignature.version", "true", "vissignature license", Boolean.valueOf(true)));
        this.baseSysParamService.initData(new BaseSysParamItem("visprintcard.version", "true", "visprintcard", Boolean.valueOf(true)));
        if (this.language.equals("zh_CN")) {
            this.baseSysParamService.initData(new BaseSysParamItem("vis.autoRegister", "0", "\u8bbf\u5ba2\u81ea\u52a8\u767b\u8bb0"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.companyName", "", "\u516c\u53f8\u540d\u79f0"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.autoDelCommmonValidEndTime", "30", "\u8bbf\u5ba2\u7b7e\u79bb\u540e\u4e0e\u6e05\u9664\u8bbf\u5ba2\u901a\u7528\u6743\u9650\u7684\u95f4\u9694\u65f6\u95f4"));
            this.baseSysParamService.initData(new BaseSysParamItem("vis.visited.park.autoSign", "0", "\u662f\u5426\u5f00\u542f\u8bbf\u5ba2\u505c\u8f66\u81ea\u52a8\u7b7e\u5230\u529f\u80fd"));
        }
        this.baseSysParamService.initData(new BaseSysParamItem("vis.enableCardAutoSign", "0", "\u8bbf\u5ba2\u81ea\u52a8\u7b7e\u5230"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.name.encryptProp", "true", "\u59d3\u540d\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.name.encryptMode", "S1", "\u59d3\u540d\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.lastName.encryptProp", "true", "\u59d3\u6c0f\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.lastName.encryptMode", "S1", "\u59d3\u6c0f\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.mobilePhone.encryptProp", "true", "\u624b\u673a\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.mobilePhone.encryptMode", "S2", "\u624b\u673a\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.gender.encryptProp", "true", "\u6027\u522b\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.gender.encryptMode", "S0F1", "\u6027\u522b\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.certNumber.encryptProp", "true", "\u8bc1\u4ef6\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.certNumber.encryptMode", "S2", "\u8bc1\u4ef6\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.email.encryptProp", "true", "\u90ae\u7bb1\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.email.encryptMode", "S2", "\u90ae\u7bb1\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.carPlate.encryptProp", "true", "\u8f66\u724c\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.carPlate.encryptMode", "S2", "\u8f66\u724c\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.cardNo.encryptProp", "true", "\u5361\u53f7\u52a0\u5bc6\u663e\u793a"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.cardNo.encryptMode", "S2", "\u5361\u53f7\u52a0\u5bc6\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("vis.photo.encryptProp", "true", "\u7167\u7247\u52a0\u5bc6\u663e\u793a"));
    }

    public void initVisReason() {
        VisReasonItem visReasonItem = new VisReasonItem("visitReason", I18nUtil.i18nCode((String)"vis_reason_visit", (Object[])new Object[0]));
        this.visReasonService.initData(visReasonItem);
    }

    public void initVisWfFlow() {
        this.visWfFlowService.initData();
    }

    private void initVisPlace() {
        VisPlaceItem visPlaceItem = new VisPlaceItem("server", "127.0.0.1", VisConstants.VIS_MACHINE_PC, "USB", "127.0.0.1", Short.valueOf((short)1), Boolean.valueOf(false), Boolean.valueOf(true), "0", "1");
        this.visPlaceService.initData(visPlaceItem);
    }

    public void initPrintTemplate() {
        BasePrintTemplateItem basePrintTemplateItem = new BasePrintTemplateItem();
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_visCardDefalut", (Object[])new Object[0]), BasePrintTemplateConstants.TEMPLATE_VERTICAL_VISCARDDEFAULT + this.language, Integer.valueOf(635), Integer.valueOf(1010), "vis", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_VERTICAL), Boolean.valueOf(true)));
        this.initVisVerticalPrintParam(basePrintTemplateItem.getId());
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_visCardDefalutHZ", (Object[])new Object[0]), BasePrintTemplateConstants.TEMPLATE_HORIZONTAL_VISCARDDEFAULT + this.language, Integer.valueOf(1010), Integer.valueOf(635), "vis", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_HORIZONTAL), Boolean.valueOf(true)));
        this.initVisHorizontalPrintParam(basePrintTemplateItem.getId());
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_visReceiptDefalut", (Object[])new Object[0]), BasePrintTemplateConstants.TEMPLATE_VERTICAL_VISRECEIPTDEFAULT + this.language, Integer.valueOf(635), Integer.valueOf(1010), "vis", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_VERTICAL), Boolean.valueOf(true)));
        this.initVisReceiptPrintParam(basePrintTemplateItem.getId());
    }

    private void initVisVerticalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "635", "1010", "background", "/images/printTemplate/vertical_front.jpg"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visTitle", (Object[])new Object[0]), "104px", "2px", "100", "20", "txt", "draggable text ui-draggable textTitle", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTitle", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0]) + ":", "32px", "35px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0]) + ":"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.enterTime", "133px", "35px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.photo", "102px", "70px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0]), "30px", "225px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visEmpName", "175px", "220px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "245px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0]), "30px", "260px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.gender", "175px", "255px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "280px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0]), "30px", "295px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visitReason", "175px", "290px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "315px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0]), "30px", "330px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.certType", "175px", "325px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "350px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0]), "30px", "365px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visEmpCertNumber", "175px", "365px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "12px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "385px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0]), "30px", "400px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visCompany", "175px", "395px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "420px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0]), "30px", "435px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.employee.name", "175px", "430px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "455px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0]), "30px", "470px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.carriedGoodsIn", "175px", "465px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "170px", "490px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "635", "1010", "background", "/images/printTemplate/verticalUS_opposite.jpg"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "printData.visTransaction.qrcode", "102px", "180px", "130", "130", "qrcode", "draggable qrcodeType ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_qrCode", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initVisHorizontalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "1010", "635", "background", "/images/printTemplate/horizontal_front.jpg"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.photo", "185px", "10px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0]), "85px", "160px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visEmpName", "225px", "155px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "220px", "180px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0]), "85px", "200px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.employee.name", "225px", "195px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "220px", "220px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0]), "85px", "240px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visitReason", "225px", "235px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "220px", "260px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0]), "85px", "280px", "100", "20", "txt", "draggable text ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visCompany", "225px", "275px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "220px", "300px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "1010", "635", "background", "/images/printTemplate/horizontal_front.jpg"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "printData.visTransaction.qrcode", "185px", "65px", "130", "130", "qrcode", "draggable qrcodeType ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_qrCode", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initVisReceiptPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visTitle", (Object[])new Object[0]), "109px", "2px", "100", "20", "txt", "draggable text ui-draggable textTitle", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTitle", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0]) + ":", "36px", "23px", "60", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0]) + ":"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.enterTime", "133px", "23px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visTime", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.photo", "109px", "38px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0]), "30px", "180px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visEmpName", "150px", "175px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visitorName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "192px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0]), "30px", "205px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.gender", "150px", "200px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "217px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0]), "30px", "230px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visitReason", "150px", "225px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_reason", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "242px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0]), "30px", "257px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.certType", "150px", "250px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_leftMenu_certType", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "267px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0]), "30px", "280px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visEmpCertNumber", "145px", "275px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "12px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_ocr_documentNo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "292px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0]), "30px", "305px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.visCompany", "150px", "300px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_company", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "317px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0]), "30px", "330px", "56", "11", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.employee.name", "150px", "325px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_visited", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "342px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0]), "30px", "357px", "56", "55", "txt", "draggable text ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.carriedGoodsIn", "150px", "351px", "56", "11", "text", "draggable ui-draggable", "0,0,0", "14px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_carriedGoods", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "draggable line", "145px", "368px", "130", "0", "line", "draggable line ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1"));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.visTransaction.qrcode", "100px", "376px", "130", "130", "qrcode", "draggable qrcodeType ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_qrCode", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initVisAlertTemplate() {
        String body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)1);
        String fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)1);
        String bottom = VisTemplateConstants.DEFAULT_EMAIL_BOTTOM;
        VisAlertTemplateItem visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_checkinEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)1), I18nUtil.i18nCode((String)"vis_alertTemplate_checkinSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)2);
        fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)2);
        visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_checkoutEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)2), I18nUtil.i18nCode((String)"vis_alertTemplate_checkoutSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)3);
        fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)3);
        visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_reservationEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)3), I18nUtil.i18nCode((String)"vis_alertTemplate_reservationSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)4);
        fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)4);
        visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_watchListEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)4), I18nUtil.i18nCode((String)"vis_alertTemplate_watchListSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)5);
        fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)5);
        visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_expiredVisEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)5), I18nUtil.i18nCode((String)"vis_alertTemplate_expiredVisSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)6);
        fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)6);
        visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_expiredResnEmailName", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)6), I18nUtil.i18nCode((String)"vis_alertTemplate_expiredResnSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
        this.visAlertTemplateService.initData(visAlertTemplateItem);
        if (!"zh_CN".equals(this.language)) {
            body = (String)VisTemplateConstants.DEFAULT_BODY_MAP.get((short)7);
            fields = (String)VisTemplateConstants.DEFAULT_FIELD_MAP.get((short)7);
            visAlertTemplateItem = new VisAlertTemplateItem(I18nUtil.i18nCode((String)"vis_alertTemplate_ResnAudit", (Object[])new Object[0]), Boolean.valueOf(true), Short.valueOf((short)1), Short.valueOf((short)7), I18nUtil.i18nCode((String)"vis_alertTemplate_resnAuditSubject", (Object[])new Object[0]), body, bottom, fields, Boolean.valueOf(false), null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, null);
            this.visAlertTemplateService.initData(visAlertTemplateItem);
        }
    }

    private void initVisAdvancedShowLicense() {
        BaseSysParamItem baseSysParamItem = new BaseSysParamItem("visadvanced.version", "true", "visadvanced license", Boolean.valueOf(true));
        this.baseSysParamService.initData(baseSysParamItem);
    }

    private void initAppMenus() {
        AuthPermissionItem appModuleItem = null;
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        appModuleItem = this.authPermissionService.getItemByCode("App");
        if (null == appModuleItem) {
            appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
            this.authPermissionService.initData(appModuleItem);
        }
        appMenuItem = new AuthPermissionItem("AppVis", "app_vis", "app:APPvis", "app_menu", "true", Integer.valueOf(3));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("AppVisReserve", "app_vis_reserve", "app:APPvisReserve", "app_button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisReserveMgr", "app_vis_reserve_mgr", "app:APPvisReserveMgr", "app_button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisRecord", "app_vis_record", "app:APPvisRecord", "app_button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisLevel", "app_vis_level", "app:APPvisLevel", "app_button", "true", Integer.valueOf(4));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisSet", "app_vis_set", "app:APPvisSet", "app_button", "true", Integer.valueOf(5));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisRegister", "app_vis_register", "app:APPvisRegister", "app_button", "true", Integer.valueOf(6));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppVisReports", "app_vis_reports", "app:APPvisReports", "app_button", "true", Integer.valueOf(7));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"vis");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("VisUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("VisUpgradeVersion", curVersion, "Vis Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }

    private void initVisPersonnalList() {
        this.visTransactionService.initVisPersonnalList();
    }
}

