/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.sendToCS;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkDeviceComm {
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ChannelService channelService;

    public String serialSend(String devIp, byte[] pData, int opType) {
        ParkWebsocketMsg websocketMsg = new ParkWebsocketMsg("voiceDisplay");
        JSONObject dataObj = new JSONObject();
        String base64Str = ParkWebCommonUtil.byteToBase64(pData);
        dataObj.put("devIp", (Object)devIp);
        dataObj.put("opType", (Object)opType);
        dataObj.put("content", (Object)base64Str);
        websocketMsg.setData(dataObj.toJSONString());
        return JSONObject.toJSONString((Object)websocketMsg);
    }

    public String serialSend(String devIp, String base64Data, int opType) {
        ParkWebsocketMsg websocketMsg = new ParkWebsocketMsg("voiceDisplay");
        JSONObject dataObj = new JSONObject();
        dataObj.put("devIp", (Object)devIp);
        dataObj.put("opType", (Object)opType);
        dataObj.put("content", (Object)base64Data);
        websocketMsg.setData(dataObj.toJSONString());
        return JSONObject.toJSONString((Object)websocketMsg);
    }

    public String openGate(String devIp, int chnId) {
        ParkWebsocketMsg websocketMsg = new ParkWebsocketMsg("openChannelGate");
        JSONObject data = new JSONObject();
        String nDuration = this.parkParamsService.getOpenChannelTime();
        data.put("devIp", (Object)devIp);
        data.put("ChnId", (Object)chnId);
        data.put("NDuration", (Object)nDuration);
        websocketMsg.setData(data.toString());
        return JSONObject.toJSONString((Object)websocketMsg);
    }

    public String searchDev() {
        ParkWebsocketMsg websocketMsg = new ParkWebsocketMsg("searchDevice");
        this.channelService.groupPush(JSONObject.toJSONString((Object)websocketMsg));
        return websocketMsg.getMsgId();
    }
}

