/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.sendToCS;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkCarTypeService;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkDiscountStrategyService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkReleaseReasonService;
import com.zkteco.zkbiosecurity.park.service.ParkShopService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkCarTypeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDiscountStrategyItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkShopItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class ParkCSPavilioMsg {
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkReleaseReasonService parkReleaseReasonService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkShopService parkShopService;
    @Autowired
    private ParkCarTypeService parkCarTypeService;
    @Autowired
    private ParkDiscountStrategyService parkDiscountStrategyService;
    @Autowired
    private ParkParkingAreaService parkParkingAreaService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Resource
    private MessageSource messageSource;

    private String getI18nByLanguage(String language, String code) {
        Locale locale = null;
        if (language.contains("_")) {
            String[] languageCountry = language.split("_");
            locale = new Locale(languageCountry[0], languageCountry[1]);
        } else {
            locale = new Locale(language);
        }
        return this.messageSource.getMessage(code, null, code, locale);
    }

    public String sendMsgToPavilio(String msgType, ParkCheckOutInfo cheOutInfo) {
        ParkWebsocketMsg websocketMsg = new ParkWebsocketMsg(msgType);
        if ("search".equals(msgType) || "freeMinutes".equals(msgType)) {
            websocketMsg.setData(JSONObject.toJSONString((Object)cheOutInfo));
        } else if ("parkingLot".equals(msgType)) {
            String lotCount = this.parkCacheService.getStr("park:parkingLot:" + cheOutInfo.getAreaId());
            JSONObject dataObj = new JSONObject();
            dataObj.put("parkingAreaId", (Object)cheOutInfo.getAreaId());
            dataObj.put("count", (Object)cheOutInfo.getParkLot());
            dataObj.put("parkingLot", (Object)lotCount);
            websocketMsg.setData(dataObj.toJSONString());
        } else {
            if (StringUtils.isNotBlank((CharSequence)cheOutInfo.getMsgInfo())) {
                boolean isCsClient = this.parkDeviceService.isCsClient(cheOutInfo.getIpAddress());
                if (isCsClient) {
                    String language = this.parkPavilioService.getCSLanguage(cheOutInfo.getPavilioIP());
                    cheOutInfo.setMsgInfo(this.getI18nByLanguage(language, cheOutInfo.getMsgInfo()));
                } else {
                    cheOutInfo.setMsgInfo(I18nUtil.i18nCode((String)cheOutInfo.getMsgInfo(), (Object[])new Object[0]));
                }
            }
            websocketMsg.setFuncId("CSInfo");
            if (StringUtils.isNotBlank((CharSequence)cheOutInfo.getUuid())) {
                websocketMsg.setMsgId(cheOutInfo.getUuid());
            }
            JSONObject obj = new JSONObject();
            obj.put("msgType", (Object)msgType);
            obj.put("msgContent", JSONObject.toJSON((Object)cheOutInfo));
            websocketMsg.setData(obj.toJSONString());
        }
        return JSONObject.toJSONString((Object)websocketMsg);
    }

    public void syncPavilioInfoToCS(String ipAddr, boolean isAll) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("synchPavilioInfo");
        ParkPavilioItem item = this.parkPavilioService.getPavilioByIpAddress(ipAddr);
        JSONObject paviJson = this.setPavilioInfo(item, isAll);
        if (isAll) {
            JSONArray channelAry = this.getChnanelByPavilio(item);
            paviJson.put("parkingChannel", (Object)channelAry);
        }
        msg.setData(JSONObject.toJSONString((Object)paviJson));
        this.channelService.single(ipAddr, JSONObject.toJSONString((Object)msg));
    }

    private JSONObject setPavilioInfo(ParkPavilioItem paviItem, boolean isAll) {
        List smallAreaItemList;
        JSONObject paviJson = new JSONObject();
        paviJson.put("pavilioName", (Object)paviItem.getName());
        paviJson.put("pavilioId", (Object)paviItem.getId());
        paviJson.put("tempCarFree", (Object)paviItem.getTemporaryCarFree());
        paviJson.put("replacement", (Object)paviItem.getReplacement());
        paviJson.put("manualRelease", (Object)paviItem.getOpengagebyhandFlag());
        paviJson.put("parkingAreaId", (Object)paviItem.getParkingAreaId());
        paviJson.put("parkingAreaName", (Object)paviItem.getParkingAreaName());
        ParkParkingAreaItem areaItem = this.parkParkingAreaService.getItemById(paviItem.getParkingAreaId());
        int parkingLotCount = areaItem.getParkingLot();
        if (ParkConstants.PARKAREA_BIG.equals(areaItem.getAreaType()) && this.parkParamsService.isShowSmallParkingLot() && CollectionUtils.isNotEmpty((Collection)(smallAreaItemList = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(paviItem.getParkingAreaId())))) {
            for (ParkParkingAreaItem item : smallAreaItemList) {
                parkingLotCount += item.getParkingLot().intValue();
            }
        }
        paviJson.put("parkingAreaLot", (Object)parkingLotCount);
        if (isAll) {
            JSONArray releaJsonAry = new JSONArray();
            List selectItems = this.parkReleaseReasonService.getAllReleaseReason();
            for (SelectItem item : selectItems) {
                JSONObject releaJson = new JSONObject();
                releaJson.put("id", (Object)item.getValue());
                releaJson.put("value", item.getText());
                releaJsonAry.add((Object)releaJson);
            }
            paviJson.put("releaseReason", (Object)releaJsonAry);
        } else {
            paviJson.put("opType", (Object)"edit");
        }
        return paviJson;
    }

    private JSONArray getChnanelByPavilio(ParkPavilioItem paviItem) {
        JSONArray channelAry = new JSONArray();
        List chnanelItemAry = this.parkChannelService.getByPavilioId(paviItem.getId());
        if (CollectionUtils.isNotEmpty((Collection)chnanelItemAry)) {
            JSONObject channelJson = null;
            for (ParkChannelItem item : chnanelItemAry) {
                channelJson = new JSONObject();
                channelJson.put("channelId", (Object)item.getId());
                channelJson.put("channelName", (Object)item.getName());
                channelJson.put("status", (Object)item.getState());
                channelJson.put("limitInMode", (Object)item.getLimitMode());
                JSONArray deviceAry = this.getDevicesByChannel(item);
                channelJson.put("devices", (Object)deviceAry);
                channelAry.add((Object)channelJson);
            }
        }
        return channelAry;
    }

    public void syncChannelInfoToCS(String pavilioIp, ParkChannelItem channelItem, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("channelInfo");
        JSONObject channelJson = new JSONObject();
        channelJson.put("channelId", (Object)channelItem.getId());
        channelJson.put("channelName", (Object)channelItem.getName());
        channelJson.put("status", (Object)channelItem.getState());
        channelJson.put("opType", (Object)opType);
        JSONArray deviceAry = this.getDevicesByChannel(channelItem);
        channelJson.put("devices", (Object)deviceAry);
        msg.setData(channelJson.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    private JSONArray getDevicesByChannel(ParkChannelItem channelItem) {
        JSONArray deviceAry = new JSONArray();
        List deviceItemAry = this.parkDeviceService.getByChannelId(channelItem.getId());
        if (CollectionUtils.isNotEmpty((Collection)deviceItemAry)) {
            for (ParkDeviceItem item : deviceItemAry) {
                JSONObject deviceJson = new JSONObject();
                deviceJson.put("deviceId", (Object)item.getId());
                deviceJson.put("deviceIp", (Object)item.getIpAddress());
                deviceJson.put("userName", (Object)item.getUsername());
                deviceJson.put("passWord", (Object)item.getPassword());
                deviceJson.put("port", (Object)item.getPort());
                deviceJson.put("channelId", (Object)channelItem.getId());
                deviceJson.put("avoption", (Object)item.getAvoption());
                deviceJson.put("priorities", (Object)item.getPriorities());
                deviceJson.put("displayType", (Object)item.getDisplayType());
                deviceJson.put("lprDeviceType", (Object)item.getLprDeviceType());
                deviceJson.put("IsSupportCarRecog", (Object)"0");
                if ("enable".equals(item.getP2p())) {
                    deviceJson.put("DevUid", (Object)item.getSn());
                    deviceJson.put("UseP2PConn", (Object)"1");
                } else {
                    deviceJson.put("DevUid", (Object)"");
                    deviceJson.put("UseP2PConn", (Object)"0");
                }
                int maxLogId = this.parkDeviceService.getMaxRecordLogId(item.getIpAddress());
                deviceJson.put("maxLogId", (Object)maxLogId);
                deviceJson.put("fromTime", (Object)"");
                String lastTime = this.parkDeviceService.getLastTimeRecordByChannelId(channelItem.getState(), channelItem.getId());
                if (StringUtils.isNotBlank((CharSequence)lastTime)) {
                    deviceJson.put("fromTime", (Object)lastTime);
                }
                deviceAry.add((Object)deviceJson);
            }
        }
        return deviceAry;
    }

    public void syncDeviceInfoToCS(String pavilioIp, ParkDeviceItem item) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("deviceEdit");
        JSONObject devJson = new JSONObject();
        devJson.put("id", (Object)item.getId());
        devJson.put("ip", (Object)item.getIpAddress());
        devJson.put("deviceName", (Object)item.getName());
        devJson.put("userName", (Object)item.getUsername());
        devJson.put("passWord", (Object)item.getPassword());
        devJson.put("displayType", (Object)item.getDisplayType());
        devJson.put("lprDeviceType", (Object)item.getLprDeviceType());
        devJson.put("IsSupportCarRecog", (Object)"0");
        if ("enable".equals(item.getP2p())) {
            devJson.put("DevUid", (Object)item.getSn());
            devJson.put("UseP2PConn", (Object)"1");
        } else {
            devJson.put("DevUid", (Object)"");
            devJson.put("UseP2PConn", (Object)"0");
        }
        devJson.put("port", (Object)item.getPort());
        msg.setData(devJson.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public void syncReleaInfoToCS(String id, String name, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("releaseInfo");
        JSONObject devJson = new JSONObject();
        devJson.put("id", (Object)id);
        devJson.put("value", (Object)name);
        devJson.put("opType", (Object)opType);
        msg.setData(devJson.toJSONString());
        this.channelService.groupPush(JSONObject.toJSONString((Object)msg));
    }

    public void syncParkingSetInfoToCS(String pavilioIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("paramsSetting");
        JSONObject paramJson = new JSONObject();
        paramJson.put("consDiscount", (Object)this.parkParamsService.isConsumptionDiscount());
        paramJson.put("pringReceipts", (Object)this.parkParamsService.isPrintReceipts());
        paramJson.put("shift", (Object)this.parkParamsService.isShift());
        paramJson.put("pass", (Object)this.parkParamsService.getPass());
        paramJson.put("manualProcess", (Object)this.parkParamsService.getManualProcess());
        paramJson.put("chargeOpen", (Object)this.parkParamsService.getChargeOpen());
        paramJson.put("showParkingLot", (Object)this.parkParamsService.isShowParkingLot());
        paramJson.put("ledTimeInterval", (Object)this.parkParamsService.getIdleTimeInterval());
        if (this.parkParamsService.isChineseLanguage()) {
            paramJson.put("defaultPlate", (Object)this.parkParamsService.getDefaultPlate());
            paramJson.put("province", (Object)this.parkParamsService.getProvinceStr());
            paramJson.put("vioceProvince", (Object)this.parkParamsService.getVoiceProvince());
        }
        paramJson.put("displayContentIn", (Object)this.parkParamsService.getCompanyName());
        paramJson.put("displayContentOut", (Object)this.parkParamsService.getCompanyName());
        paramJson.put("weChatPay", (Object)this.parkParamsService.getWeChatPay());
        paramJson.put("vioceCarNumber", (Object)this.parkParamsService.isVioceCarNumber());
        paramJson.put("firstLineColor", (Object)this.parkParamsService.getFirstLineColor());
        paramJson.put("secondLineColor", (Object)this.parkParamsService.getSecondLineColor());
        paramJson.put("thirdLineColor", (Object)this.parkParamsService.getThirdLineColor());
        paramJson.put("fourthLineColor", (Object)this.parkParamsService.getFourthLineColor());
        paramJson.put("language", (Object)LocaleMessageSourceUtil.language);
        paramJson.put("countryCode", (Object)this.parkParamsService.getCountryCode());
        paramJson.put("oneChanWaitTime", (Object)this.parkParamsService.getOneChannelWaitTime());
        paramJson.put("normalModelWaitTime", (Object)this.parkParamsService.getNormalModelWaitTime());
        paramJson.put("customCurrency", (Object)this.parkParamsService.getCustomCurrency());
        paramJson.put("onlineFlag", (Object)this.parkParamsService.onlineFlag());
        msg.setData(paramJson.toJSONString());
        if (StringUtils.isNotBlank((CharSequence)pavilioIp)) {
            this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        } else {
            this.channelService.groupPush(JSONObject.toJSONString((Object)msg));
        }
    }

    public void syncDiscountInfoToCS(String pavilioIp, String shopId) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("discountInfo");
        JSONArray shopAry = new JSONArray();
        List shopItemAry = this.parkShopService.getShopById(shopId);
        if (CollectionUtils.isNotEmpty((Collection)shopItemAry)) {
            JSONObject shop = null;
            for (ParkShopItem shopItem : shopItemAry) {
                shop = new JSONObject();
                shop.put("shopId", (Object)shopItem.getId());
                shop.put("shopName", (Object)shopItem.getName());
                String discountIds = shopItem.getDiscountStrategyIds();
                List discountItemAry = this.parkDiscountStrategyService.getByIds(Arrays.asList(discountIds.split(",")));
                if (!CollectionUtils.isNotEmpty((Collection)discountItemAry)) continue;
                JSONArray discountAry = new JSONArray();
                for (ParkDiscountStrategyItem item : discountItemAry) {
                    JSONObject discountJson = new JSONObject();
                    discountJson.put("discountId", (Object)item.getId());
                    discountJson.put("discountName", (Object)item.getName());
                    discountJson.put("discountType", (Object)item.getDiscountType());
                    int type = Integer.parseInt(item.getDiscountType().toString());
                    discountJson.put("content", type == 1 ? "0" : Double.valueOf(type == 2 ? item.getDeductibleAmount() : (type == 3 ? (double)item.getDeductibleHours().shortValue() : item.getDeductiblePercent())));
                    discountAry.add((Object)discountJson);
                }
                shop.put("discount", (Object)discountAry);
                shopAry.add((Object)shop);
            }
        }
        msg.setData(shopAry.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public void syncAllCarTypeToCS(String pavilioIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("allCarTypeInfo");
        JSONArray dataAry = new JSONArray();
        List carTypeWithCharge = this.parkCarTypeService.getExistTemporaryCharge();
        List carTypeItemAry = this.parkCarTypeService.getCarTypeByFilter("all");
        for (ParkCarTypeItem item : carTypeItemAry) {
            JSONObject carObj = new JSONObject();
            carObj.put("carTypeName", (Object)item.getName());
            carObj.put("carTypeId", (Object)item.getId());
            Short carType = ParkConstants.CAR_TYPE_FIX;
            Short flag = 0;
            if (ParkConstants.CAR_TYPE_TEMP.equals(item.getType())) {
                carType = ParkConstants.CAR_TYPE_TEMP;
                for (SelectItem carTypeItem : carTypeWithCharge) {
                    if (!carTypeItem.getValue().equals(item.getId())) continue;
                    flag = 1;
                    break;
                }
            }
            carObj.put("flag", (Object)flag);
            carObj.put("carType", (Object)carType);
            dataAry.add((Object)carObj);
        }
        msg.setData(dataAry.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public void recordinListToPavilio(String pavilioIp, List<ParkRecordinItem> recordinAry) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("searchCarNumber");
        if (ParkWebCommonUtil.isNotNull(recordinAry)) {
            msg.setRet(1);
            JSONArray dataAry = new JSONArray();
            for (ParkRecordinItem item : recordinAry) {
                JSONObject dataJson = new JSONObject();
                dataJson.put("checkinId", (Object)item.getId());
                dataJson.put("carNumber", (Object)("Empty".equalsIgnoreCase(item.getCarNumber()) ? "" : item.getCarNumber()));
                dataJson.put("carTypeId", (Object)item.getCarTypeId());
                dataJson.put("carTypeName", (Object)item.getCarTypeName());
                dataJson.put("checkinTime", (Object)item.getCheckInTime());
                dataJson.put("placeEntry", (Object)item.getPavilioName());
                String photoPath = item.getPhotoPathIn();
                dataJson.put("photoPath", (Object)photoPath);
                dataAry.add((Object)dataJson);
            }
            msg.setData(dataAry.toJSONString());
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public void syncTempCarTypeToCS(String id, String name, Short carType, Short flag, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("carTypeInfo");
        JSONObject carObj = new JSONObject();
        carObj.put("carTypeName", (Object)name);
        carObj.put("carTypeId", (Object)id);
        carObj.put("carType", (Object)carType);
        carObj.put("flag", (Object)flag);
        carObj.put("opType", (Object)opType);
        msg.setData(carObj.toJSONString());
        this.channelService.groupPush(JSONObject.toJSONString((Object)msg));
    }

    public void syncShopInfo(String shopId, String shopName, List<ParkDiscountStrategyItem> discountAry, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("shopInfo");
        JSONObject dataObj = new JSONObject();
        dataObj.put("shopId", (Object)shopId);
        dataObj.put("shopName", (Object)shopName);
        dataObj.put("opType", (Object)opType);
        if (ParkWebCommonUtil.isNotNull(discountAry)) {
            JSONArray discObjAry = new JSONArray();
            for (ParkDiscountStrategyItem item : discountAry) {
                JSONObject discObj = new JSONObject();
                discObj.put("discountId", (Object)item.getId());
                discObj.put("discountName", (Object)item.getName());
                discObj.put("discountType", (Object)item.getDiscountType());
                short type = item.getDiscountType();
                discObj.put("content", type == 1 ? "0" : Double.valueOf(type == 2 ? item.getDeductibleAmount() : (type == 3 ? (double)item.getDeductibleHours().shortValue() : item.getDeductiblePercent())));
                discObjAry.add((Object)discObj);
            }
            dataObj.put("discount", (Object)discObjAry.toJSONString());
        }
        msg.setData(dataObj.toJSONString());
        this.channelService.groupPush(JSONObject.toJSONString((Object)msg));
    }

    public void delPavilioToCS(String pavilioIp, String opMsg) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("synchPavilioInfo");
        JSONObject dataObj = new JSONObject();
        dataObj.put("opType", (Object)"del");
        dataObj.put("opMsg", (Object)opMsg);
        msg.setData(dataObj.toJSONString());
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }
}

