/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.receiveFromCS;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkVehiclePlateInfo;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.DataCallFuntion;
import com.zkteco.zkbiosecurity.park.websocketService.IDataHandle;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class ParkCSRealTimeInfo
implements IDataHandle {
    private static final Logger log = LoggerFactory.getLogger(ParkCSRealTimeInfo.class);
    private static final int VZ_LPRC_ONLINE = 3;
    private static final int VZ_LPRC_OFFLINE = 4;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    @DataCallFuntion(value="commonNotify")
    public void commonNotify(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String eNotify = data.getString("eNotify");
        if (Integer.parseInt(eNotify) == 3) {
            this.onGateRunStatusFun(data);
        } else if (Integer.parseInt(eNotify) == 4) {
            this.onCommonNotifyFun(data);
        }
    }

    private void onCommonNotifyFun(JSONObject msgObj) {
        JSONObject devObj;
        String devIp = msgObj.getString("deviceIp");
        Long handle = Long.valueOf(msgObj.getString("handle"));
        if (StringUtils.isNotBlank((CharSequence)devIp) && "enable".equals((devObj = this.parkCacheService.getJson("park:dev_info_" + devIp)).getString("enabled"))) {
            log.info("Park=CS====onCommonNotifyFun=====Device offline Callback==IpAddr:{}==Msg:{}=", (Object)devObj.getString("ipAddr"), (Object)msgObj.toString());
            String keyStr = "park:view_defa_content:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            keyStr = "park:dev_handle:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            devObj.put("pavilioMode", (Object)"cs");
            this.parkCacheService.updateDevOffLine(devObj);
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
        }
    }

    private void onGateRunStatusFun(JSONObject msgObj) {
        String devIp = msgObj.getString("deviceIp");
        String handle = msgObj.getString("handle");
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj) && Long.parseLong(handle) > 0L) {
            log.info("Park=CS====onCommonNotifyFun=====Device offline Callback==IpAddr:{}==", (Object)devObj.getString("ipAddr"));
            devObj.put("handle", (Object)handle);
            devObj.put("state", (Object)"onLine");
            devObj.put("pavilioMode", (Object)"cs");
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            this.parkCacheService.set("park:dev_handle:" + handle, (Object)devIp, 0L);
            this.parkCacheService.set("park:view_defa_content:" + handle, (Object)"0", 0L);
        }
    }

    @DataCallFuntion(value="searchDevice")
    public void searchDevice(JSONObject msg) {
        JSONArray dataAry = msg.getJSONArray("data");
        if (Objects.nonNull(dataAry)) {
            for (int i = 0; i < dataAry.size(); ++i) {
                JSONObject data = dataAry.getJSONObject(i);
                String ipAddr = data.getString("ip");
                ParkDeviceItem item = this.parkDeviceService.getByIpAddress(ipAddr);
                if (!Objects.isNull(item)) continue;
                String code = data.getString("vendorsType");
                ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
                cheOutInfo.setMsgType("search");
                cheOutInfo.setDevName(data.getString("deviceName"));
                cheOutInfo.setVendorsType(code);
                if (data.containsKey((Object)"lprDevType") && StringUtils.isNotBlank((CharSequence)data.getString("lprDevType"))) {
                    cheOutInfo.setLprDeviceType(Short.valueOf(data.getString("lprDevType")));
                } else {
                    cheOutInfo.setLprDeviceType(Short.valueOf("0"));
                }
                cheOutInfo.setMsgInfo(code);
                cheOutInfo.setIpAddress(ipAddr);
                cheOutInfo.setPort(Long.parseLong(data.getString("portListen")));
                cheOutInfo.setSn("");
                String comm = this.parkCSPavilioMsg.sendMsgToPavilio("search", cheOutInfo);
                this.channelService.groupPush(comm);
                this.messagingTemplate.convertAndSend((Object)"/topic/parkDevice/message", (Object)comm);
            }
        }
    }

    @DataCallFuntion(value="checkinOut")
    public void checkinOut(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        String channelId = data.getString("channelId");
        String status = data.getString("channelStatus");
        String devIp = data.getString("deviceIp");
        String carNumber = data.getString("carNumber");
        String picBase64 = data.getString("picBase64");
        String isManual = data.getString("isManual");
        String manualId = data.getString("manualId");
        String dataPath = ParkWebCommonUtil.getDatePhotoPath();
        String rootPath = ParkWebCommonUtil.getSystemFilePath() + dataPath;
        ParkWebCommonUtil.createDir(rootPath);
        String photoName = this.getPhotoPathForCS(devIp, carNumber);
        String relativePath = dataPath + photoName;
        rootPath = rootPath + photoName;
        boolean opRet = Base64Util.generateImage((String)picBase64, (String)rootPath);
        if (!opRet) {
            log.info("ParkCSRealTimeInfo checkinOut Save Photo {}---{} Fail! ", (Object)photoName, (Object)new Date());
            return;
        }
        if ("true".equals(isManual)) {
            ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
            parkCheckOutInfo.setLicense(carNumber);
            parkCheckOutInfo.setParkChannelId(channelId);
            parkCheckOutInfo.setPhotoPath(relativePath);
            parkCheckOutInfo.setPavilioIP(pavilioIp);
            parkCheckOutInfo.setManual(true);
            parkCheckOutInfo.setReleaseReasonId(manualId);
            parkCheckOutInfo.setUuid(msgId);
            Short state = Short.valueOf(status);
            List<Short> channelState = Arrays.asList(ParkConstants.CHANNEL_STATE_CART_IN, ParkConstants.CHANNEL_STATE_CAR_IN);
            if (channelState.contains(state)) {
                this.parkRecordinService.manualReleaseIn(parkCheckOutInfo, ParkConstants.PAVILIO_CS);
            } else {
                this.parkRecordoutService.manualReleaseOut(parkCheckOutInfo, ParkConstants.PAVILIO_CS);
            }
        } else {
            ParkVehiclePlateInfo vehiclePlate = new ParkVehiclePlateInfo(carNumber);
            this.parkDeviceService.routeBusiness(vehiclePlate, devIp, relativePath, msgId);
        }
    }

    private String getPhotoPathForCS(String ipAddress, String carNumber) {
        StringBuffer photoName = new StringBuffer(ipAddress).append("_");
        photoName.append(DateUtil.dateToString((Date)new Date(), (String)"HH:mm:ss.SSS").replaceAll(":", "").replace(".", ""));
        if (Objects.nonNull(carNumber)) {
            photoName.append("_").append(carNumber);
        }
        photoName.append(".jpg");
        return photoName.toString();
    }

    @DataCallFuntion(value="deviceFunList")
    public void deviceFunList(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String deviceIp = data.getString("deviceIp");
        String fun = data.getString("fun");
        if (StringUtils.isNotBlank((CharSequence)fun)) {
            String msgId = msg.getString("msgId");
            if (StringUtils.isBlank((CharSequence)msgId)) {
                this.parkDeviceService.saveDevFunWithCS(deviceIp, fun);
                this.parkDeviceService.startSaveOfflineRecordThread(deviceIp);
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Ret", (Object)msg.getIntValue("ret"));
                jsonObject.put("OpType", (Object)msg.getString("funcId"));
                jsonObject.put("Data", (Object)fun);
                this.parkCacheService.setJson("park:ws_msgid:" + msgId, jsonObject, 600L);
            }
        }
    }
}

