/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.receiveFromCS;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTicketRecordItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.DataCallFuntion;
import com.zkteco.zkbiosecurity.park.websocketService.IDataHandle;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkCSOperation
implements IDataHandle {
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired(required=false)
    private AuthUserService authUserService;

    @DataCallFuntion(value="checkinOk")
    public void checkinOk(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String channelId = data.getString("channelId");
        String deviceIp = data.getString("deviceIp");
        String carNumber = data.getString("carNumber");
        String photoPath = data.getString("photoPath");
        String msgId = msg.getString("msgId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setIpAddress(deviceIp);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setUuid(msgId);
        this.parkRecordinService.confirmIn(parkCheckOutInfo);
    }

    @DataCallFuntion(value="checkoutOk")
    public void checkoutTemp(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String carTypeId = data.getString("carTypeId");
        String parkingMeterId = data.getString("parkingMeterId");
        Timestamp checkinTime = null;
        if (data.containsKey((Object)"checkinTime") && !"0".equals(data.getString("checkinTime"))) {
            checkinTime = (Timestamp)data.getTimestamp("checkinTime");
        }
        Timestamp checkoutTime = (Timestamp)data.getTimestamp("checkoutTime");
        long lastTime = data.getLong("lastCheckinTime");
        Timestamp lastCheckinTime = lastTime == 0L ? null : new Timestamp(lastTime);
        Double receivableAmount = data.getDouble("receivableAmount");
        Double discountAmount = data.getDouble("discountAmount");
        Double receiveAmount = data.getDouble("receiveAmount");
        boolean isDiscount = data.getBoolean("isDiscount");
        Double haveFees = data.getDouble("haveFees");
        String devIp = data.getString("devIp");
        String channelId = data.getString("channelId");
        String recordinId = data.getString("recordinId");
        String msgId = msg.getString("msgId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setCarTypeId(carTypeId);
        parkCheckOutInfo.setRecordinTime(checkinTime);
        parkCheckOutInfo.setRecordoutTime(checkoutTime);
        parkCheckOutInfo.setRecordinId(recordinId);
        parkCheckOutInfo.setParkingMeterId(parkingMeterId);
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLastTime(lastCheckinTime);
        parkCheckOutInfo.setHaveFees(haveFees);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setAmountReceivable(receivableAmount);
        parkCheckOutInfo.setAmountReceiveble(receiveAmount);
        parkCheckOutInfo.setAmountDiscount(discountAmount);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setUuid(msgId);
        parkCheckOutInfo.setDiscount(isDiscount);
        ParkTicketRecordItem parkTicketRecordItem = null;
        if (isDiscount) {
            JSONObject ticketRecord = data.getJSONObject("ticketRecord");
            String shopId = ticketRecord.getString("shopId");
            String ticketNumber = ticketRecord.getString("ticketNumber");
            String discountStrategyId = ticketRecord.getString("discountStrategyId");
            parkTicketRecordItem = new ParkTicketRecordItem();
            parkTicketRecordItem.setTicketNumber(ticketNumber);
            parkTicketRecordItem.setParkShopId(shopId);
            parkTicketRecordItem.setParkDiscountStrategyId(discountStrategyId);
        }
        this.parkRecordoutService.tempCheckoutConfirm(parkCheckOutInfo, parkTicketRecordItem);
    }

    @DataCallFuntion(value="checkoutCancel")
    public void checkoutCancel(JSONObject msg) {
        ParkParkingMeterItem parkingMeterItem;
        JSONObject data = msg.getJSONObject("data");
        String parkingMeterId = data.getString("parkingMeterId");
        if (StringUtils.isNotBlank((CharSequence)parkingMeterId) && Objects.nonNull(parkingMeterItem = this.parkParkingMeterService.getItemById(parkingMeterId))) {
            this.parkRecordoutService.restoreData(parkingMeterItem);
        }
    }

    @DataCallFuntion(value="changeCarType")
    public void changeCarType(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String channelId = data.getString("channelId");
        String carNumber = data.getString("carNumber");
        String devIp = data.getString("devIp");
        String photoPath = data.getString("photoPath");
        String parkingMeterId = data.getString("parkingMeterId");
        boolean isManual = data.getBoolean("isManual");
        String manualId = data.getString("manualId");
        String carTypeId = data.getString("carTypeId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setParkingMeterId(parkingMeterId);
        parkCheckOutInfo.setManual(isManual);
        parkCheckOutInfo.setReleaseReasonId(manualId);
        parkCheckOutInfo.setCarTypeId(carTypeId);
        this.parkRecordoutService.changeCarTypeCharge(parkCheckOutInfo);
    }

    @DataCallFuntion(value="freeTime")
    public void freeTime(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String photoPath = data.getString("photoPath");
        String devIp = data.getString("devIp");
        String parkingMeterId = data.getString("parkingMeterId");
        String freeTime = data.getString("freeTime");
        boolean isManual = data.getBoolean("isManual");
        String manualId = data.getString("manualId");
        String carTypeId = data.getString("carTypeId");
        Timestamp checkinTime = null;
        if (data.containsKey((Object)"checkinTime") && !"0".equals(data.getString("checkinTime"))) {
            checkinTime = (Timestamp)data.getTimestamp("checkinTime");
        }
        Timestamp checkoutTime = (Timestamp)data.getTimestamp("checkoutTime");
        String channelId = data.getString("channelId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setParkingMeterId(parkingMeterId);
        parkCheckOutInfo.setRecordinTime(checkinTime);
        parkCheckOutInfo.setRecordoutTime(checkoutTime);
        parkCheckOutInfo.setCarTypeId(carTypeId);
        parkCheckOutInfo.setManual(isManual);
        parkCheckOutInfo.setReleaseReasonId(manualId);
        parkCheckOutInfo.setParkChannelId(channelId);
        this.parkRecordoutService.freeMinutesCharge(parkCheckOutInfo, freeTime);
    }

    @DataCallFuntion(value="checkouFree")
    public void checkouFree(JSONObject msg) {
        String msgId = msg.getString("msgId");
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String photoPath = data.getString("photoPath");
        String devIp = data.getString("devIp");
        String channelId = data.getString("channelId");
        String parkingMeterId = data.getString("parkingMeterId");
        String carTypeId = data.getString("carTypeId");
        String recordinId = data.getString("recordinId");
        ParkParkingMeterItem meterItem = this.parkParkingMeterService.getItemById(parkingMeterId);
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setRecordinId(recordinId);
        parkCheckOutInfo.setParkingMeterId(parkingMeterId);
        parkCheckOutInfo.setCarTypeId(carTypeId);
        parkCheckOutInfo.setUuid(msgId);
        parkCheckOutInfo.setRecordinTime(meterItem.getRecordinTime());
        parkCheckOutInfo.setRecordoutTime(meterItem.getRecordoutTime());
        this.parkRecordoutService.tempCheckoutFree(parkCheckOutInfo);
    }

    @DataCallFuntion(value="searchCarNumber")
    public void searchCarNumber(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String channelId = data.getString("channelId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setLicense(carNumber);
        List itemList = this.parkRecordinService.searchRecordinInfo(parkCheckOutInfo);
        this.parkCSPavilioMsg.recordinListToPavilio(pavilioIp, itemList);
    }

    @DataCallFuntion(value="manualCorrectFree")
    public void manualCorrectFree(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String channelId = data.getString("channelId");
        String photoPath = data.getString("photoPath");
        boolean isManual = data.getBoolean("isManual");
        String manualId = data.getString("manualId");
        String devIp = data.getString("devIp");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setIsFree(Short.valueOf((short)0));
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setManual(isManual);
        parkCheckOutInfo.setReleaseReasonId(manualId);
        this.parkRecordoutService.unMatchFree(parkCheckOutInfo);
    }

    @DataCallFuntion(value="manualCorrectCharge")
    public void manualCorrectCharge(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String channelId = data.getString("channelId");
        String photoPath = data.getString("photoPath");
        boolean isManual = data.getBoolean("isManual");
        String manualId = data.getString("manualId");
        String devIp = data.getString("devIp");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setManual(isManual);
        parkCheckOutInfo.setReleaseReasonId(manualId);
        this.parkRecordoutService.unMatchCharge(parkCheckOutInfo);
    }

    @DataCallFuntion(value="manualCorrect")
    public void manualCorrect(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        String channelId = data.getString("channelId");
        String checkinId = data.getString("checkinId");
        String devIp = data.getString("devIp");
        String photoPath = data.getString("photoPath");
        boolean isManual = data.getBoolean("isManual");
        String manualId = data.getString("manualId");
        ParkCheckOutInfo parkCheckOutInfo = new ParkCheckOutInfo();
        parkCheckOutInfo.setPavilioIP(pavilioIp);
        parkCheckOutInfo.setLicense(carNumber);
        parkCheckOutInfo.setParkChannelId(channelId);
        parkCheckOutInfo.setRecordinId(checkinId);
        parkCheckOutInfo.setIpAddress(devIp);
        parkCheckOutInfo.setPhotoPath(photoPath);
        parkCheckOutInfo.setManual(isManual);
        parkCheckOutInfo.setReleaseReasonId(manualId);
        this.parkRecordoutService.manualCorrect(parkCheckOutInfo);
    }

    @DataCallFuntion(value="isWechatPay")
    public void isWechatPay(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        JSONObject data = msg.getJSONObject("data");
        String carNumber = data.getString("carNumber");
        boolean ret = this.parkRecordoutService.whetherPay(carNumber);
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("isWechatPay");
        retMsg.setMsgId(msgId);
        retMsg.setRet(ret ? 1 : -1);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="limitInMode")
    public void limitInMode(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String limitlnChannelIds = data.getString("limitlnChannelIds");
        String channelIds = data.getString("channelIds");
        this.parkChannelService.saveLimitLineMode(limitlnChannelIds, channelIds);
    }

    @DataCallFuntion(value="getSystemTime")
    public void getSystemTime(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("systemTime");
        retMsg.setMsgId(msgId);
        retMsg.setData(String.valueOf(System.currentTimeMillis()));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="getViewInfo")
    public void getViewInfo(JSONObject msg) {
        JSONObject data = msg.getJSONObject("data");
        String license = data.getString("license");
        String ipAddress = data.getString("ipAddress");
        String amountReceiveble = data.getString("amountReceiveble");
        this.parkRecordoutService.viewInfo(license, ipAddress, amountReceiveble);
    }

    @DataCallFuntion(value="checkPassword")
    public void checkPassword(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        JSONObject data = msg.getJSONObject("data");
        String userName = data.getString("userName");
        String passWord = data.getString("passWord");
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("checkPassword");
        retMsg.setMsgId(msgId);
        if (!this.authUserService.isExistUserName(userName).booleanValue()) {
            retMsg.setRet(-1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_checkPassword_noUserName", (Object[])new Object[0]));
        } else {
            AuthUserItem authUserItem = this.authUserService.getUserByNameAndLoginPwd(userName, passWord);
            retMsg.setRet(authUserItem == null ? -2 : 1);
            retMsg.setData(I18nUtil.i18nCode((String)"park_checkPassword_passwordError", (Object[])new Object[0]));
        }
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }

    @DataCallFuntion(value="setLanguage")
    public void setLanguage(JSONObject msg) {
        String pavilioIp = msg.getString("channelId");
        String msgId = msg.getString("msgId");
        JSONObject data = msg.getJSONObject("data");
        String language = data.getString("language");
        this.parkPavilioService.setCSLanguage(pavilioIp, language);
        ParkWebsocketMsg retMsg = new ParkWebsocketMsg("setLanguage");
        retMsg.setMsgId(msgId);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)retMsg));
    }
}

