/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.RequestParser;
import com.zkteco.zkbiosecurity.park.websocketService.WsDispatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebsocketServerHandler.class);
    private ParkParamsService parkParamsService = (ParkParamsService)SpringUtil.getBean(ParkParamsService.class);
    private WebSocketServerHandshaker handshaker;
    private WsDispatcher wsDispatcher;
    private ChannelService channelService;

    public WebsocketServerHandler(WsDispatcher wsDispatcher, ChannelService channelService) {
        this.wsDispatcher = wsDispatcher;
        this.channelService = channelService;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelService.add(ctx.channel());
        log.info("PARK_CS == Channel Connect, channelId: " + ctx.channel().id().asLongText() + " Client IP\uff1a" + ctx.channel().remoteAddress().toString());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.channelService.remove(ctx.channel());
        log.info("PARK_CS == Channel Disconnect, channelId: " + ctx.channel().id().asLongText());
        String sn = this.channelService.getSNByChannelId(ctx.channel().id().asLongText());
        this.channelService.modifyPavilioStatus(sn);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (!req.decoderResult().isSuccess() || !"websocket".equalsIgnoreCase(req.headers().get("Upgrade"))) {
            WebsocketServerHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory("ws://" + this.channelService.getWebcocketUrl() + ":" + this.channelService.getPort() + "/websocket", null, false, 10000000);
        this.handshaker = wsFactory.newHandshaker(req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
        }
        try {
            Map<String, String> parmMap = new RequestParser(req).parse();
            this.channelService.bindChannel(parmMap.get("channelId"), ctx.channel());
            this.channelService.bindSNByChannelId(ctx.channel().id().asLongText(), parmMap.get("channelId"));
            if (ParkWebCommonUtil.isNotNull(parmMap.get("tag"))) {
                this.channelService.bindGroup(parmMap.get("channelId"), parmMap.get("tag"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame || frame instanceof PongWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        String request = ((TextWebSocketFrame)frame).text();
        String funcId = JSON.parseObject((String)request).getString("funcId");
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_CS == Received Message <<<<< " + funcId + " \uff1a " + request);
        }
        TextWebSocketFrame tws = new TextWebSocketFrame(request);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)tws.text());
            this.wsDispatcher.handleMessage(jsonObject);
        }
        catch (Exception e) {
            ctx.channel().writeAndFlush((Object)"\u65e0\u6548\u7684\u8bbf\u95ee");
            ctx.channel().close();
        }
        ctx.channel().writeAndFlush((Object)"ok");
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, DefaultFullHttpResponse res) {
        if (res.status().code() != HttpResponseStatus.OK.code()) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != HttpResponseStatus.OK.code()) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)((FullHttpRequest)msg));
        } else if (msg instanceof DefaultHttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)((DefaultHttpRequest)msg));
        } else if (msg instanceof WebSocketFrame) {
            this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }
}

