/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.task;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.cmd.service.ParkHttpCmdService;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkSDKServerTask {
    private static final Logger log = LoggerFactory.getLogger(ParkSDKServerTask.class);
    @Autowired
    private ScheduleService scheduleService;
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkHttpCmdService parkHttpCmdService;

    public void startTask() {
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> this.websocketServiceMonitor(), "0/30 * * * * ?");
    }

    private void websocketServiceMonitor() {
        boolean parkLogger = this.parkParamsService.printParkLogger();
        if (this.parkParamsService.isLprCamera()) {
            if (Objects.isNull(this.parkWebsocketService.getSDKSession()) || !this.parkWebsocketService.getSDKSession().isOpen()) {
                this.updateDeviceStatus();
                if (parkLogger) {
                    log.info("PARK_SDK == SDK Create Connected ...");
                }
                this.parkWebsocketService.createSDKService();
            } else {
                String devIpStr;
                if (parkLogger) {
                    log.info("PARK_SDK == Connected isOpen: " + this.parkWebsocketService.getSDKSession().isOpen());
                }
                if (StringUtils.isNotBlank((CharSequence)(devIpStr = this.parkCacheService.getStr("park:alldev_ip")))) {
                    String[] devIpAry;
                    for (String devIp : devIpAry = devIpStr.split(",")) {
                        JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
                        if (Objects.isNull(devJson) || StringUtils.isBlank((CharSequence)devJson.getString("channelId")) || !"offLine".equals(devJson.getString("state"))) continue;
                        if ("http".equals(devJson.getString("protype"))) {
                            this.parkHttpCmdService.getDevHeart(devIp);
                            continue;
                        }
                        this.parkWebsocketService.reconnDevice(devIp);
                    }
                }
            }
        }
    }

    private void updateDeviceStatus() {
        String devIpStr;
        String parkingLotCommMode = this.parkParamsService.getParkingLotCommMode();
        if ("sdk".equals(parkingLotCommMode)) {
            this.parkCacheService.dels("park:dev_handle:");
        }
        if (StringUtils.isNotBlank((CharSequence)(devIpStr = this.parkCacheService.getStr("park:alldev_ip")))) {
            String[] devIpAry;
            for (String devIp : devIpAry = devIpStr.split(",")) {
                long timeDifference;
                JSONObject devObj;
                String protype;
                String devInfo = "park:dev_info_" + devIp;
                if (!this.parkCacheService.exists(devInfo) || !"sdk".equals(protype = (devObj = this.parkCacheService.getJson(devInfo)).getString("protype"))) continue;
                boolean update = true;
                if (!"sdk".equals(parkingLotCommMode) && devObj.containsKey((Object)"updateTime") && (timeDifference = ParkWebCommonUtil.timeDifference(0L, devObj.getLongValue("updateTime"))) < 300000L) {
                    update = false;
                }
                if (!update) continue;
                this.parkCacheService.delExistsKey("park:view_defa_content:" + devObj.getString("handle"));
                this.parkCacheService.delExistsKey("park:dev_handle:" + devObj.getString("handle"));
                this.parkCacheService.updateDevOffLine(devObj);
                this.parkCacheService.setJson(devInfo, devObj, 0L);
            }
        }
    }
}

