/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.task;

import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkPhotoFileTask {
    private static final Logger log = LoggerFactory.getLogger(ParkPhotoFileTask.class);
    @Autowired
    private ScheduleService scheduleService;
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkParamsService parkParamsService;

    public void startTask() {
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> this.delOldPhotos(), "0 0 3 * * ?");
    }

    private void delOldPhotos() {
        String systemFilePath;
        File root;
        int photoSaveDay = this.parkParamsService.getPhotoSaveDays();
        if (ParkWebCommonUtil.isNotNull(photoSaveDay) && photoSaveDay != 0 && (root = new File(systemFilePath = ParkWebCommonUtil.getSystemFilePath())).exists()) {
            Date date = null;
            Date beforeDate = DateUtil.getDateBefore((Date)new Date(), (int)photoSaveDay);
            File[] files = root.listFiles();
            if (Objects.isNull(files) || files.length <= 0) {
                return;
            }
            for (File file : files) {
                String fullPath;
                File dir;
                String dirName;
                if (!file.isDirectory() || (date = DateUtil.stringToDate((String)(dirName = file.getName()), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD)).getTime() > beforeDate.getTime() || !(dir = new File(fullPath = systemFilePath + file.getName())).exists()) continue;
                ParkPhotoFileTask.deleteAllFilesOfDir(dir);
            }
        }
    }

    private static void deleteAllFilesOfDir(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        if (Objects.isNull(files) || files.length <= 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            ParkPhotoFileTask.deleteAllFilesOfDir(files[i]);
        }
        path.delete();
    }
}

