/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.task;

import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkAuthStatusAndSpaceTask {
    private static final Logger log = LoggerFactory.getLogger(ParkAuthStatusAndSpaceTask.class);
    @Autowired
    private ScheduleService scheduleService;
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;

    public void startTask() {
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> {
            this.parkAuthorizeService.updateExpireAuthStatus();
            this.offlineTotalLot();
        }, "0 0/5 * * * ?");
    }

    private void offlineTotalLot() {
        if (this.parkParamsService.isOnlineFlag() == 0) {
            this.parkWebsocketService.totalParkingSpaces();
        }
    }
}

