/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.websocketService.Service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.bean.ParkWebsocketMsg;
import com.zkteco.zkbiosecurity.park.cmd.service.ParkCommProtocolAdapterService;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.enums.ParkVoiceEnum;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkWebSocketSDKClient;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkWebSocketSDKFun;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.Park485Protocol;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.ZKLprBlackWhite;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkBlackWhiteService;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.service.ParkCarTypeService;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceOpRecordService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkDisplayDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkDoubleVerifyAccDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingSpaceService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberItem;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDiscountStrategyItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDisplayDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkDeviceComm;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.websocket.ContainerProvider;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
@Order(value=83)
public class ParkWebsocketServiceImpl
implements ParkWebsocketService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ParkWebsocketServiceImpl.class);
    private static VoiceAndViewThread voiceAndViewThread;
    private static boolean WEBSOCKETINIT;
    private static boolean OPENFLAG;
    private static Session sdkSession;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkCarTypeService parkCarTypeService;
    @Autowired
    private ParkWebSocketSDKFun webSocketSDKFun;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCarNumberService parkCarNumberService;
    @Autowired
    private Park485Protocol park485Protocol;
    @Autowired
    private ParkParkingAreaService parkParkingAreaService;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkParkingSpaceService parkParkingSpaceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkDeviceComm parkDeviceComm;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkDeviceOpRecordService parkDeviceOpRecordService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private ParkDisplayDeviceService parkDisplayDeviceService;
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkBlackWhiteService parkBlackWhiteService;
    @Autowired
    private ParkCommProtocolAdapterService parkCommProtocolAdapterService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired
    private ParkDoubleVerifyAccDeviceService parkDoubleVerifyAccDeviceService;
    private final int defaultScreemWidth = 128;
    private final int defaultScreemHeight = 32;

    public void run(String ... arg0) {
        new WebsocketServiceInit("ParkWebsocketServiceInitThread").start();
    }

    private void delOldDataFromRedis() {
        this.parkCacheService.del("park:alldev_ip");
        this.parkCacheService.del("park:doubleCheck:allDoor_id");
        this.parkCacheService.del("park:doubleCheck:allChannel_id");
        this.parkCacheService.del("park:commMode");
        this.parkCacheService.dels("park:areaid:");
        this.parkCacheService.dels("park:cartype_code:");
        this.parkCacheService.dels("park:dev_info_");
        this.parkCacheService.dels("park:dev_handle:");
        this.parkCacheService.dels("park:view_defa_content:");
        this.parkCacheService.dels("park:dev_sn_ip:");
        this.parkCacheService.dels("park:photo_in_out:");
        this.parkCacheService.dels("park:channel:");
        this.parkCacheService.dels("park:callback_voiceview:");
        this.parkCacheService.dels("park:ws_msgid:");
        this.parkCacheService.dels("park:pavilio_mode:");
        this.parkCacheService.dels("park:parkingLot:");
        this.parkCacheService.dels("park:pavilio_status:");
        this.parkCacheService.dels("park:biosecurity_");
        this.parkCacheService.dels("park:channel_id_");
        this.parkCacheService.dels("park:displaydev_info_");
        this.parkCacheService.dels("park:offline_time:channel_id_");
        this.parkCacheService.dels("park:parkingLot_id:");
        this.parkCacheService.dels("park:doubleCheck:singleDoor");
        this.parkCacheService.dels("park:doubleCheck:parkChannel_id:");
        this.parkCacheService.dels("park:ticketInfo:");
        this.parkCacheService.dels("park:channelTicketCode_devIp:");
        this.parkCacheService.dels("park:trafficLights_devIp:");
    }

    public void createSDKService() {
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (WEBSOCKETINIT && StringUtils.isBlank((CharSequence)devIpStr)) {
            return;
        }
        List deviceItemAry = this.parkDeviceService.findAll();
        if (CollectionUtils.isNotEmpty((Collection)deviceItemAry)) {
            deviceItemAry.forEach(dev -> {
                if (StringUtils.isNotBlank((CharSequence)dev.getIpAddress())) {
                    this.parkParamsService.setIP(dev.getIpAddress());
                }
            });
            this.sdkService(deviceItemAry);
        }
    }

    public void sdkService(List<ParkDeviceItem> deviceItemAry) {
        List parkDisplayDeviceItemList;
        boolean connected = true;
        String parkingLotCommMode = this.parkParamsService.getParkingLotCommMode();
        if ("sdk".equals(parkingLotCommMode)) {
            try {
                String uri = this.parkParamsService.getSDKURL();
                OPENFLAG = false;
                this.setSDKSession();
                WebSocketContainer container = ContainerProvider.getWebSocketContainer();
                sdkSession = container.connectToServer(ParkWebSocketSDKClient.class, new URI(uri));
                if (Objects.nonNull(sdkSession)) {
                    log.info("PARK_SDK == Websocket Connection Success SessionID = " + sdkSession.getId());
                    ParkWebSocketSDKFun.session = sdkSession;
                    String init = this.webSocketSDKFun.setParameter("init");
                    int ret = this.parkCacheService.searchRedisByKey(init);
                    if (ret == 0) {
                        OPENFLAG = true;
                    }
                }
            }
            catch (Exception e) {
                connected = false;
                log.warn("PARK == SDK Websocket Connection Failed ", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(deviceItemAry)) {
            for (ParkDeviceItem item : deviceItemAry) {
                if (StringUtils.isNotBlank((CharSequence)item.getIpAddress()) && "best-w".equals(parkingLotCommMode)) {
                    this.parkCacheService.getCacheDevInfo(item.getIpAddress());
                }
                if (!OPENFLAG || !"sdk".equals(parkingLotCommMode)) continue;
                String msgId = this.connDevWS(item);
                CompletableFuture.runAsync(() -> {
                    int operRet = this.parkCacheService.searchRedisByKey(msgId);
                    this.parkDeviceOpRecordService.saveItemByConnect(item, operRet);
                });
            }
        }
        if (connected && "sdk".equals(parkingLotCommMode) && CollectionUtils.isNotEmpty((Collection)(parkDisplayDeviceItemList = this.parkDisplayDeviceService.getByCondition(new ParkDisplayDeviceItem())))) {
            for (ParkDisplayDeviceItem item : parkDisplayDeviceItemList) {
                this.connectDisplayDevice(item, "init");
            }
            log.info("PARK == DisplayDevice Activate device status detection after connection");
            this.parkDisplayDeviceService.startDevReconnectScheduled();
        }
    }

    public Session getSDKSession() {
        if (Objects.nonNull(sdkSession)) {
            return sdkSession;
        }
        return null;
    }

    public void setSDKSession() {
        if (Objects.nonNull(sdkSession)) {
            try {
                sdkSession.close();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sdkSession = null;
                ParkWebSocketSDKFun.session = null;
            }
        }
    }

    public void setSDKPhotoSavePath() {
        this.webSocketSDKFun.setParameter("photoSavePath");
    }

    public void stopSDKWebsocketService() {
        try {
            this.setSDKSession();
            this.parkCacheService.dels("park:dev_handle:");
            this.parkCacheService.dels("park:view_defa_content:");
            this.parkCacheService.delExistsKey("park:alldev_ip");
            this.parkCacheService.dels("park:dev_info_");
            this.parkCacheService.dels("park:channel:");
            this.parkCacheService.dels("park:callback_voiceview:");
            this.parkCacheService.dels("park:ws_msgid:");
            this.parkCacheService.dels("park:pavilio_mode:");
            this.parkCacheService.dels("park:pavilio_status:");
            this.parkCacheService.dels("park:trafficLights_devIp:");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String connDevWS(ParkDeviceItem deviceItem) {
        JSONObject devInfo;
        String msgId = "-1";
        JSONObject devObj = this.assembleJson(deviceItem);
        if (ParkWebCommonUtil.isNotNull(devObj) && ParkConstants.ENABLED.equals(deviceItem.getStatus()) && "bs".equals((devInfo = this.parkCacheService.getCacheDevInfo(deviceItem.getIpAddress())).getString("pavilioMode"))) {
            msgId = this.webSocketSDKFun.deviceOpen(devObj);
            log.info("PARK_DEVICE == Init Open Device IpAddress:{}-username:{}-password:{}-msgId:{}", new Object[]{deviceItem.getIpAddress(), deviceItem.getUsername(), deviceItem.getPassword(), msgId});
        }
        return msgId;
    }

    public void reconnDevice(String devIp) {
        String reconTime = this.parkCacheService.getStr("park:dev_open:" + devIp);
        if (StringUtils.isBlank((CharSequence)reconTime)) {
            reconTime = "0";
        }
        long lastTime = Long.parseLong(reconTime);
        long startTime = System.currentTimeMillis();
        if (startTime - lastTime < 30000L) {
            return;
        }
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && "offLine".equals(devObj.getString("state")) && "bs".equals(devObj.getString("pavilioMode")) && "enable".equals(devObj.getString("enabled"))) {
            JSONObject data = new JSONObject();
            data.put("DeviceType", (Object)devObj.getString("vendorsType"));
            data.put("LprDevType", (Object)devObj.getString("lprDevType"));
            data.put("IpAddr", (Object)devObj.getString("ipAddr"));
            data.put("Port", (Object)String.valueOf(devObj.getString("port")));
            data.put("UserName", (Object)devObj.getString("userName"));
            data.put("Password", (Object)devObj.getString("passWd"));
            data.put("P2PConn", (Object)devObj.getString("p2pConn"));
            data.put("DevUid", (Object)devObj.getString("devSn"));
            this.zsBuilderJson(devObj.getString("channelId"), devObj.getString("channelStatus"), data);
            String msgId = this.webSocketSDKFun.deviceOpen(data);
            devObj.put("msgId", (Object)msgId);
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            this.parkCacheService.set("park:dev_open:" + devIp, (Object)Instant.now().toEpochMilli(), 0L);
            log.info("PARK_DEVICE == Reconnection Device IpAddress:{}-UserName:{}-Password:{}-MsgId:{}", new Object[]{devIp, devObj.getString("userName"), devObj.getString("passWd"), msgId});
        }
    }

    private JSONObject assembleJson(ParkDeviceItem dev) {
        String isP2P;
        String msgId = "";
        String pavilioMode = "bs";
        String pavilioIp = "";
        String channelId = "";
        String channelStatus = "";
        String parkingAreaId = "";
        JSONObject devParamJson = new JSONObject();
        JSONObject data = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)dev.getChannelId())) {
            ParkChannelItem channelItem = this.parkChannelService.getItemById(dev.getChannelId());
            channelId = dev.getChannelId();
            channelStatus = String.valueOf(channelItem.getState());
            parkingAreaId = channelItem.getParkingAreaId();
            ParkPavilioItem pavilioItem = this.parkPavilioService.getPavilioByChannelId(dev.getChannelId());
            pavilioIp = pavilioItem.getIpAddress();
            if (ParkConstants.PAVILIO_CS.equals(pavilioItem.getClientMode())) {
                pavilioMode = "cs";
            }
        }
        String isEnabled = ParkConstants.DISABLE.equals(dev.getStatus()) ? "disable" : "enable";
        Short lprDeviceType = Objects.isNull(dev.getLprDeviceType()) ? (short)0 : dev.getLprDeviceType();
        String string = isP2P = "enable".equals(dev.getP2p()) ? "1" : "0";
        if (!"cs".equals(pavilioMode)) {
            data.put("DeviceType", (Object)dev.getVendorsType());
            data.put("LprDevType", (Object)lprDeviceType);
            data.put("IpAddr", (Object)dev.getIpAddress());
            data.put("Port", (Object)String.valueOf(dev.getPort()));
            data.put("UserName", (Object)dev.getUsername());
            data.put("Password", (Object)dev.getPassword());
            data.put("IsSupportCarRecog", (Object)"0");
            String sn = "";
            if ("enable".equals(dev.getP2p())) {
                sn = dev.getSn();
            }
            data.put("DevUid", (Object)sn);
            data.put("P2PConn", (Object)isP2P);
            data.put("DetectionCar", (Object)"1");
            data.put("AntifakePlate", (Object)"1");
            data.put("RecogCarLogo", (Object)"0");
            data.put("RecogCarType", (Object)"0");
            data.put("RecogCarColor", (Object)"0");
            data.put("UnlicensedCar", (Object)"0");
            this.zsBuilderJson(channelId, channelStatus, data);
        }
        String devIp = dev.getIpAddress();
        if (this.parkCacheService.exists("park:dev_info_" + devIp)) {
            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
            long handle = devObj.getLong("handle");
            String keyStr = "park:view_defa_content:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            keyStr = "park:dev_handle:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            this.parkCacheService.delExistsKey("park:dev_info_" + devIp);
        }
        JSONObject devJson = new JSONObject();
        devJson.put("pavilioIp", (Object)pavilioIp);
        devJson.put("pavilioMode", (Object)pavilioMode);
        devJson.put("channelId", (Object)channelId);
        devJson.put("channelStatus", (Object)channelStatus);
        devJson.put("parkingAreaId", (Object)parkingAreaId);
        devJson.put("displayType", (Object)dev.getDisplayType());
        devJson.put("p2pConn", (Object)isP2P);
        devJson.put("sn", (Object)(StringUtils.isBlank((CharSequence)dev.getSn()) ? "" : dev.getSn()));
        devJson.put("protype", (Object)dev.getProtype());
        devJson.put("ipAddr", (Object)dev.getIpAddress());
        devJson.put("port", (Object)dev.getPort());
        devJson.put("userName", (Object)dev.getUsername());
        devJson.put("passWd", (Object)dev.getPassword());
        devJson.put("enabled", (Object)isEnabled);
        devJson.put("handle", (Object)0);
        devJson.put("serialHand", (Object)0);
        devJson.put("state", (Object)"offLine");
        devJson.put("vendorsType", (Object)dev.getVendorsType());
        devJson.put("carTeamSignal", (Object)false);
        devJson.put("lprDevType", (Object)lprDeviceType);
        devJson.put("devId", (Object)dev.getId());
        devJson.put("devName", (Object)dev.getName());
        devJson.put("firmVersion", (Object)dev.getFirmVersion());
        devJson.put("msgId", (Object)msgId);
        this.parkCacheService.setJson("park:dev_info_" + devIp, devJson, 0L);
        return data;
    }

    public int addDevice(ParkDeviceItem item) {
        this.parkParamsService.setIP(item.getIpAddress());
        String msgId = this.connDevWS(item);
        int operRet = this.parkCacheService.searchRedisByKey(msgId);
        this.parkDeviceOpRecordService.saveItemByConnect(item, operRet);
        return operRet;
    }

    public String getFunlist(long handle) {
        return this.webSocketSDKFun.getFunlist(handle);
    }

    public String getDevVerInfo(long handle) {
        return this.webSocketSDKFun.getDevVerInfo(handle);
    }

    public boolean editDevice(String devIP, ParkDeviceItem item) {
        boolean ret = false;
        if (this.parkDeviceService.delDeviceCache(devIP)) {
            this.addDevice(item);
            ret = true;
        }
        return ret;
    }

    public int delDevice(String devIp) {
        int ret = 0;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj)) {
            String devHandle = devObj.getString("handle");
            if ("onLine".equals(devObj.get((Object)"state")) && StringUtils.isNotBlank((CharSequence)devHandle)) {
                String msgId = this.webSocketSDKFun.deviceClose(Long.parseLong(devHandle));
                ret = this.parkCacheService.searchRedisByKey(msgId);
            }
            String handleStr = "park:dev_handle:" + devObj.getString("handle");
            this.parkCacheService.delExistsKey(handleStr);
            String keyStr = "park:view_defa_content:" + devObj.getString("handle");
            this.parkCacheService.delExistsKey(keyStr);
        }
        return ret;
    }

    public int enableDevice(String devIp) {
        int ret = 0;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj)) {
            if ("sdk".equals(this.parkParamsService.getParkingLotCommMode())) {
                String handle = devObj.getString("handle");
                String msgId = this.webSocketSDKFun.isDeviceConnected(Long.parseLong(handle));
                ret = this.parkCacheService.searchRedisByKey(msgId);
                if (ret != -10001 && ret < 0) {
                    ParkDeviceItem parkDevice = this.parkDeviceService.getByIpAddress(devIp);
                    parkDevice.setStatus(ParkConstants.ENABLED);
                    ret = this.addDevice(parkDevice);
                }
            } else {
                devObj.put("enabled", (Object)"enable");
                this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            }
        }
        return ret;
    }

    public int disableDevice(String devIp) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj) && "enable".equals(devObj.getString("enabled"))) {
            long handle = devObj.getLong("handle");
            this.deviceClose(handle);
            devObj.put("enabled", (Object)"disable");
            this.parkCacheService.updateDevOffLine(devObj);
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
        }
        return 0;
    }

    public int deviceClose(long handle) {
        String msgId = this.webSocketSDKFun.deviceClose(handle);
        int ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public int setDeviceTime(String devIp) {
        int ret = 0;
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj)) {
            long handle = Long.parseLong(devObj.getString("handle"));
            SimpleDateFormat dateformat = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
            String newTime = dateformat.format(new Date());
            String msgId = this.webSocketSDKFun.setDateTime(handle, newTime);
            ret = this.parkCacheService.searchSyncByKey(msgId);
        }
        return ret;
    }

    public int syncParams(String paramObj) {
        String msgId = this.webSocketSDKFun.setOfflineParam(paramObj);
        int ret = this.parkCacheService.searchSyncByKey(msgId);
        return ret;
    }

    public int syncCharging(String paramObj) {
        String msgId = this.webSocketSDKFun.setDeviceData(paramObj);
        int ret = this.parkCacheService.searchSyncByKey(msgId);
        return ret;
    }

    public String readParams(String paramObj) {
        String msgId = this.webSocketSDKFun.getOfflineParam(paramObj);
        return msgId;
    }

    public String readPlateList(String paramObj) {
        String msgId = this.webSocketSDKFun.exportPlateList(paramObj);
        return msgId;
    }

    public String getDeviceDataCount(long handle, int type, int offset) {
        JSONObject params = new JSONObject();
        params.put("Handle", (Object)handle);
        params.put("Type", (Object)type);
        params.put("Offset", (Object)offset);
        String msgId = this.webSocketSDKFun.getDeviceDataCount(params);
        return msgId;
    }

    public String getDeviceData(String paramObj) {
        String msgId = this.webSocketSDKFun.getDeviceData(paramObj);
        return msgId;
    }

    public String readVersion() {
        String msgId = this.webSocketSDKFun.getSysInfo();
        return msgId;
    }

    public int cleanCharging(String paramObj) {
        String msgId = this.webSocketSDKFun.clearDeviceData(paramObj);
        int ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public int resetFactory(String paramObj) {
        String msgId = this.webSocketSDKFun.resetFactory(paramObj);
        int ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public void searchDev() {
        this.webSocketSDKFun.startFindDevice();
        this.parkDeviceComm.searchDev();
    }

    public void stopSearchDev() {
        this.webSocketSDKFun.stopFindDevice();
    }

    public int openChannelGate(String devIp, long handle, int chnId) {
        int ret = 0;
        if (StringUtils.isNotBlank((CharSequence)devIp)) {
            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
            String pavilioMode = devObj.getString("pavilioMode");
            if ("bs".equals(pavilioMode)) {
                if ("onLine".equals(devObj.get((Object)"state"))) {
                    String msgId = this.webSocketSDKFun.openChannelGate(handle, chnId);
                    ret = this.parkCacheService.searchRedisByKey(msgId);
                    log.info("Open Gate device {} --- {}", (Object)devIp, (Object)ret);
                } else {
                    ret = -1;
                }
            } else {
                String comm = this.parkDeviceComm.openGate(devIp, chnId);
                String pavilioIp = devObj.getString("pavilioIp");
                this.channelService.single(pavilioIp, comm);
            }
            if (ret == 0 && ParkConstants.DEVICE_TYPE_ZS.equals(devObj.getShort("lprDevType"))) {
                byte[] msgBag;
                List<Short> lcd = Arrays.asList(ParkConstants.LCD_HALFSCREEN, ParkConstants.LCD_FULLSCREEN);
                if (lcd.contains(devObj.getShort("displayType"))) {
                    this.sendLcdLight2Dev(devIp, 1);
                } else if (ParkConstants.LED_TWOVERTICAL.equals(devObj.getShort("displayType"))) {
                    msgBag = this.park485Protocol.sendTrafficLights153(ParkConstants.LED_TWOVERTICAL, 1);
                    this.sendMsg(devIp, msgBag, 153);
                } else {
                    msgBag = this.park485Protocol.sendTrafficLights153(ParkConstants.LED_FOURCOLOR, 1);
                    this.sendMsg(devIp, msgBag, 153);
                }
                JSONObject jsonLight = new JSONObject();
                jsonLight.put("timeLight", (Object)System.currentTimeMillis());
                jsonLight.put("statusLight", (Object)1);
                this.parkCacheService.setJson("park:trafficLights_devIp:" + devIp, jsonLight, 0L);
            }
        }
        return ret;
    }

    public int closeChannelGate(String devIp, long handle, int chnId) {
        int ret = 0;
        if (StringUtils.isNotBlank((CharSequence)devIp)) {
            JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
            String pavilioMode = devObj.getString("pavilioMode");
            if ("bs".equals(pavilioMode)) {
                if ("onLine".equals(devObj.get((Object)"state"))) {
                    String msgId = this.webSocketSDKFun.closeChannelGate(handle, chnId);
                    ret = this.parkCacheService.searchRedisByKey(msgId);
                } else {
                    ret = -1;
                }
            } else {
                ret = -1;
            }
        }
        return ret;
    }

    public int saveSnapImageToJpeg(long handle, String filePathName) {
        int ret = 0;
        String msgId = this.webSocketSDKFun.saveSnapImage(handle, filePathName);
        ret = this.parkCacheService.searchRedisByKey(msgId);
        return ret;
    }

    public void sendMsg(String devIp, byte[] msg, int opType) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && Objects.nonNull(msg)) {
            String base64Str = ParkWebCommonUtil.byteToBase64(msg);
            if ("onLine".equals(devObj.get((Object)"state"))) {
                if ("best-w".equals(devObj.getString("protype"))) {
                    this.parkCommProtocolAdapterService.sendLedAndVoice(devIp, base64Str);
                } else {
                    String pavilioMode = devObj.getString("pavilioMode");
                    if ("bs".equals(pavilioMode)) {
                        this.webSocketSDKFun.serialSend((long)devObj.getLong("serialHand"), base64Str);
                    } else {
                        String comm = this.parkDeviceComm.serialSend(devIp, base64Str, opType);
                        String pavilioIp = devObj.getString("pavilioIp");
                        this.channelService.single(pavilioIp, comm);
                    }
                }
            }
        }
    }

    public int sendBlackWhites(long handle, int type, List<ParkBlackWhiteItem> blackWhiteItemAry, String opType) {
        int ret = 0;
        if (this.parkParamsService.isChineseLanguage()) {
            int carNumSize = 0;
            byte[] buffer = null;
            if (CollectionUtils.isNotEmpty(blackWhiteItemAry)) {
                carNumSize = blackWhiteItemAry.size();
                int size = carNumSize * 24;
                int npos = 0;
                buffer = new byte[size];
                for (ParkBlackWhiteItem blackWhite : blackWhiteItemAry) {
                    ZKLprBlackWhite zkBW = this.putCarNumber(blackWhite.getCarNumber(), blackWhite.getStartTime(), blackWhite.getEndTime());
                    zkBW.packet(buffer, npos);
                    npos += 24;
                }
            }
            String msgId = this.webSocketSDKFun.sendPlateList(handle, type, buffer, carNumSize, opType);
            return this.parkCacheService.searchSyncByKey(msgId);
        }
        if ("ImportPlateList".equals(opType)) {
            ret = this.sendBlackWhitesForeign(handle, type, blackWhiteItemAry, "ClearPlateListExt");
            opType = "AddPlateListExt";
        } else {
            opType = opType + "Ext";
        }
        if (ret >= 0) {
            ret = this.sendBlackWhitesForeign(handle, type, blackWhiteItemAry, opType);
        }
        return ret;
    }

    private int sendBlackWhitesForeign(long handle, int type, List<ParkBlackWhiteItem> parkBlackWhites, String opType) {
        ArrayList<JSONObject> plateInfos = new ArrayList<JSONObject>();
        if (CollectionUtils.isNotEmpty(parkBlackWhites)) {
            SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
            try {
                for (ParkBlackWhiteItem parkBlackWhiteItem : parkBlackWhites) {
                    JSONObject plateInfo = new JSONObject();
                    plateInfo.put("Plate", (Object)parkBlackWhiteItem.getCarNumber());
                    plateInfo.put("Name", (Object)"");
                    plateInfo.put("FromDate", (Object)sdf.format(parkBlackWhiteItem.getStartTime()).split(" ")[0]);
                    plateInfo.put("ToDate", (Object)sdf.format(parkBlackWhiteItem.getEndTime()).split(" ")[0]);
                    plateInfos.add(plateInfo);
                }
            }
            catch (Exception exception) {
                log.error("sendAuthorizesForeign", (Throwable)exception);
            }
        }
        String msgId = this.webSocketSDKFun.sendPlateListForeign(handle, type, plateInfos, parkBlackWhites.size(), opType);
        return this.parkCacheService.searchSyncByKey(msgId);
    }

    public int sendAuthorizes(long handle, List<ParkAuthorizeItem> parkAuthorizes, String type) {
        if (this.parkParamsService.isChineseLanguage()) {
            int carNumSize = 0;
            byte[] buffer = null;
            if (CollectionUtils.isNotEmpty(parkAuthorizes)) {
                carNumSize = parkAuthorizes.size();
                int size = carNumSize * 24;
                int npos = 0;
                buffer = new byte[size];
                for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
                    ZKLprBlackWhite zkBW = this.putCarNumber(parkAuthorize.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
                    zkBW.packet(buffer, npos);
                    npos += 24;
                }
            }
            String msgId = this.webSocketSDKFun.sendPlateList(handle, ParkConstants.OPEN_TYPE_AUTH.shortValue(), buffer, carNumSize, type);
            return this.parkCacheService.searchSyncByKey(msgId);
        }
        int ret = 0;
        if ("ImportPlateList".equals(type)) {
            ret = this.sendAuthorizesForeign(handle, parkAuthorizes, "ClearPlateListExt");
            type = "AddPlateListExt";
        } else {
            type = type + "Ext";
        }
        if (ret >= 0) {
            ret = this.sendAuthorizesForeign(handle, parkAuthorizes, type);
        }
        return ret;
    }

    private int sendAuthorizesForeign(long handle, List<ParkAuthorizeItem> parkAuthorizes, String opType) {
        ArrayList<JSONObject> plateInfos = new ArrayList<JSONObject>();
        if (CollectionUtils.isNotEmpty(parkAuthorizes)) {
            SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
            try {
                for (ParkAuthorizeItem parkAuthorizeItem : parkAuthorizes) {
                    JSONObject plateInfo = new JSONObject();
                    String carNumber = this.parkCarNumberService.getCarNumByAuthId(parkAuthorizeItem.getId());
                    plateInfo.put("Plate", (Object)carNumber);
                    plateInfo.put("Name", (Object)(StringUtils.isBlank((CharSequence)parkAuthorizeItem.getPersonName()) ? "" : parkAuthorizeItem.getPersonName()));
                    plateInfo.put("FromDate", (Object)sdf.format(parkAuthorizeItem.getStartTime()).split(" ")[0]);
                    plateInfo.put("ToDate", (Object)sdf.format(parkAuthorizeItem.getEndTime()).split(" ")[0]);
                    plateInfos.add(plateInfo);
                }
            }
            catch (Exception exception) {
                log.error("sendAuthorizesForeign", (Throwable)exception);
            }
        }
        String msgId = this.webSocketSDKFun.sendPlateListForeign(handle, ParkConstants.OPEN_TYPE_AUTH.shortValue(), plateInfos, parkAuthorizes.size(), opType);
        return this.parkCacheService.searchSyncByKey(msgId);
    }

    private ZKLprBlackWhite putCarNumber(String carNumber, Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
        try {
            byte[] carNo = carNumber.getBytes("GB2312");
            byte[] license = new byte[16];
            for (int i = 0; i < carNo.length; ++i) {
                license[i] = carNo[i];
            }
            zkBW.szLicense = license;
            if (ParkWebCommonUtil.isNotNull(startTime)) {
                String startStr = sdf.format(startTime);
                String[] stratTime = startStr.split(" ");
                zkBW.fromDate.nYear = Short.parseShort(stratTime[0].split("-")[0]);
                zkBW.fromDate.nMonth = (char)Integer.parseInt(stratTime[0].split("-")[1]);
                zkBW.fromDate.nDay = (char)Integer.parseInt(stratTime[0].split("-")[2]);
            }
            if (ParkWebCommonUtil.isNotNull(endTime)) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(endTime);
                String endStr = sdf.format(calendar.getTime());
                String[] endTimeAry = endStr.split(" ");
                zkBW.toDate.nYear = Short.parseShort(endTimeAry[0].split("-")[0]);
                zkBW.toDate.nMonth = (char)Integer.parseInt(endTimeAry[0].split("-")[1]);
                zkBW.toDate.nDay = (char)Integer.parseInt(endTimeAry[0].split("-")[2]);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return zkBW;
    }

    public String getCarTeamSignal(long handle) {
        String msgId = this.webSocketSDKFun.getCarTeamSignal(handle);
        return msgId;
    }

    public int setCarTeamSignal(long handle, int signal) {
        String msgId = this.webSocketSDKFun.setCarTeamSignal(handle, signal);
        return this.parkCacheService.searchRedisByKey(msgId);
    }

    private void sendCommandLcd4Lines(String devIp, String license, String displayCont) {
        try {
            if (StringUtils.isNotBlank((CharSequence)displayCont)) {
                String voiceCont = this.park485Protocol.getDigitalVoice(license, displayCont);
                this.sendLcdVoice2Dev(devIp, voiceCont);
                Thread.sleep(200L);
            }
            JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
            String protype = devJson.getString("protype");
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
            if ("best-w".equals(protype)) {
                String sn = devJson.getString("sn");
                String handleStr = "park:view_defa_content:" + sn;
                this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
            } else {
                String handleStr;
                long handle = this.parkCacheService.getHandleByIp(devIp);
                if (ParkWebCommonUtil.isNotNull(handle) && handle != 0L && this.parkCacheService.exists(handleStr = "park:view_defa_content:" + handle)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                }
            }
            String companyName = this.parkParamsService.getCompanyName();
            String viewCode = this.parkParamsService.getViewCode();
            String currTime = ParkViewEnum.getFormatTime((String)viewCode);
            this.sendLcdDisplay2Dev(devIp, companyName, currTime, license, displayCont);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendCommandNewSingleLines(String devIp, String license, String displayCont, String voiceCont) {
        try {
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                byte[] msgBag = this.park485Protocol.sendVoice177ForSingleLine(codeByte, devIp);
                this.sendMsg(devIp, msgBag, 177);
                Thread.sleep(200L);
            }
            JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
            String protype = devJson.getString("protype");
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
            if ("best-w".equals(protype)) {
                String sn = devJson.getString("sn");
                String handleStr = "park:view_defa_content:" + sn;
                this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                byte[] msgBag = this.park485Protocol.setRealTimeDisplay174SingleLine(license, displayCont, devIp);
                this.sendMsg(devIp, msgBag, 174);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandNew(String devIp, String license, String displayCont, String voiceCont) {
        try {
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                byte[] msgBag = this.park485Protocol.sendVoice177(codeByte, devIp);
                this.sendMsg(devIp, msgBag, 177);
                Thread.sleep(200L);
            }
            JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
            String protype = devJson.getString("protype");
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
            byte[] msgBag = null;
            if ("best-w".equals(protype)) {
                String sn = devJson.getString("sn");
                String handleStr = "park:view_defa_content:" + sn;
                this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                msgBag = this.park485Protocol.setRealTimeDisplay174(license, displayCont, devIp);
            } else {
                String handleStr;
                long handle = devJson.getLong("handle");
                if (ParkWebCommonUtil.isNotNull(handle) && handle != 0L && this.parkCacheService.exists(handleStr = "park:view_defa_content:" + handle)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                    msgBag = this.park485Protocol.setRealTimeDisplay174(license, displayCont, devIp);
                }
            }
            this.sendMsg(devIp, msgBag, 174);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandNewTwoVertical(String devIp, String license, String displayCont, String voiceCont) {
        try {
            String handleStr;
            long handle;
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                byte[] msgBag = this.park485Protocol.sendVoice177(codeByte, devIp);
                this.sendMsg(devIp, msgBag, 177);
                Thread.sleep(200L);
            }
            JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
            String protype = devJson.getString("protype");
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
            if ("sdk".equals(protype) && ParkWebCommonUtil.isNotNull(handle = devJson.getLong("handle").longValue()) && handle != 0L && this.parkCacheService.exists(handleStr = "park:view_defa_content:" + handle)) {
                this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                byte[] msgBag = this.park485Protocol.setRealTimeDisplay174TwoVertical(license, displayCont, devIp);
                this.sendMsg(devIp, msgBag, 174);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandNewFor4Lines(String devIp, String license, String displayCont, String voiceCont) {
        try {
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                byte[] codeByte = this.park485Protocol.getVoiceByteByCode(voiceCont);
                byte[] msgBag = this.park485Protocol.sendVoice177For4Lines(codeByte, devIp);
                this.sendMsg(devIp, msgBag, 177);
                Thread.sleep(200L);
            }
            JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
            String protype = devJson.getString("protype");
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
            if ("best-w".equals(protype)) {
                String sn = devJson.getString("sn");
                String handleStr = "park:view_defa_content:" + sn;
                this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
            } else {
                String handleStr;
                long handle = this.parkCacheService.getHandleByIp(devIp);
                if (ParkWebCommonUtil.isNotNull(handle) && handle != 0L && this.parkCacheService.exists(handleStr = "park:view_defa_content:" + handle)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                }
            }
            String companyName = this.parkParamsService.getCompanyName();
            String viewCode = this.parkParamsService.getViewCode();
            String currTime = ParkViewEnum.getFormatTime((String)viewCode);
            byte[] msgBag = this.park485Protocol.setRealTimeDisplay174For4Lines(companyName, currTime, license, displayCont, devIp);
            this.sendMsg(devIp, msgBag, 174);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendCommandOld(String devIp, String license, String displayCont, String voiceCont) {
        try {
            byte[] msgBag;
            if (StringUtils.isNotBlank((CharSequence)voiceCont)) {
                msgBag = this.park485Protocol.voiceInfo(voiceCont, devIp);
                this.sendMsg(devIp, msgBag, 2);
                Thread.sleep(200L);
            }
            msgBag = this.park485Protocol.viewInfo(license, displayCont, devIp);
            this.sendMsg(devIp, msgBag, 1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void startVoiceAndViewThread() {
        if (Objects.isNull(voiceAndViewThread) || !voiceAndViewThread.isAlive()) {
            voiceAndViewThread = new VoiceAndViewThread("ParkVoiceAndViewThread");
            voiceAndViewThread.start();
        }
    }

    public void totalParkingSpaces() {
        boolean isFixedStatistical = this.parkParamsService.isFixedStatistical();
        List fieldList = isFixedStatistical ? this.parkParkingAreaService.getOnSiteCarCount() : this.parkParkingAreaService.getOnSiteTempCarCount();
        this.statisticsParkingSpaces(fieldList, isFixedStatistical);
    }

    public void totalParkingSpacesByAreaId(String parkingAreaId) {
        boolean isFixedStatistical = this.parkParamsService.isFixedStatistical();
        ArrayList<Object[]> fieldList = new ArrayList<Object[]>();
        if (isFixedStatistical) {
            int count = this.parkRecordinService.getCountByParkAreaId(parkingAreaId);
            Object[] object = new Object[]{parkingAreaId, count + ""};
            fieldList.add(object);
        } else {
            int count = this.parkRecordinService.getCountByParkAreaIdAndCarType(parkingAreaId, ParkConstants.CAR_TYPE_TEMP);
            Object[] object = new Object[]{parkingAreaId, count + ""};
            fieldList.add(object);
        }
        this.statisticsParkingSpaces(fieldList, isFixedStatistical);
    }

    private void statisticsParkingSpaces(List<Object[]> fieldList, boolean isFixedStatistical) {
        block19: {
            boolean isShowSmallParkingLot;
            block18: {
                List validWhiteList;
                isShowSmallParkingLot = this.parkParamsService.isShowSmallParkingLot();
                if (!CollectionUtils.isNotEmpty(fieldList)) break block18;
                List parkParkingAreaItemList = this.parkParkingAreaService.getByCondition(new ParkParkingAreaItem());
                Map parkParkingAreaItemMap = CollectionUtil.listToKeyMap((Collection)parkParkingAreaItemList, ParkParkingAreaItem::getId);
                boolean isDisplayParkingSpace = this.parkParamsService.isDisplayParkingSpace();
                boolean allowListStatistical = this.parkParamsService.isAllowListStatistical();
                boolean allowPlate = false;
                Set<Object> allowList = new HashSet();
                if (!allowListStatistical && CollectionUtils.isNotEmpty((Collection)(validWhiteList = this.parkBlackWhiteService.getValidWhiteList()))) {
                    allowPlate = true;
                    allowList = validWhiteList.stream().map(ParkBlackWhiteItem::getCarNumber).collect(Collectors.toSet());
                }
                for (Object[] field : fieldList) {
                    List parkParkingAreaAry;
                    List carNumberRecordIn;
                    String areaId = field[0].toString();
                    ParkParkingAreaItem parkingArea = (ParkParkingAreaItem)parkParkingAreaItemMap.get(areaId);
                    int allowCount = 0;
                    int authCount = 0;
                    int smallParkingLot = 0;
                    int smallSurplusCount = 0;
                    int smallAuthCount = 0;
                    String recordinCount = field[1].toString();
                    if (isDisplayParkingSpace) {
                        authCount = this.parkParkingSpaceService.getCountByAreaIdAndStatus(areaId, ParkConstants.PARKINGSPACE_USED);
                    } else if (!isFixedStatistical) {
                        authCount = this.parkAuthorizeService.getValidAuthCountByAreaId(areaId);
                    }
                    if (allowPlate && CollectionUtils.isNotEmpty((Collection)(carNumberRecordIn = this.parkRecordinService.getCarNumbersByParkAreaIdAndCarType(areaId, ParkConstants.CAR_TYPE_TEMP)))) {
                        HashSet recordInList = new HashSet(carNumberRecordIn);
                        allowCount = Sets.intersection(allowList, recordInList).size();
                    }
                    if (ParkConstants.PARKAREA_BIG.equals(parkingArea.getAreaType()) && CollectionUtils.isNotEmpty((Collection)(parkParkingAreaAry = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(parkingArea.getId())))) {
                        if (isShowSmallParkingLot) {
                            for (ParkParkingAreaItem smallParkingArea : parkParkingAreaAry) {
                                int authCountSmall = 0;
                                int recordinCountSmall = 0;
                                smallParkingLot += smallParkingArea.getParkingLot().intValue();
                                if (isFixedStatistical) {
                                    recordinCountSmall = this.parkRecordinService.getCountByParkAreaId(smallParkingArea.getId());
                                } else {
                                    recordinCountSmall = this.parkRecordinService.getCountByParkAreaIdAndCarType(smallParkingArea.getId(), ParkConstants.CAR_TYPE_TEMP);
                                    if (isDisplayParkingSpace) {
                                        authCountSmall = this.parkParkingSpaceService.getCountByAreaIdAndStatus(smallParkingArea.getId(), ParkConstants.PARKINGSPACE_USED);
                                    }
                                }
                                int surplusCountSmall = smallParkingArea.getParkingLot() - recordinCountSmall - authCountSmall;
                                smallSurplusCount += surplusCountSmall;
                            }
                        } else if (!isFixedStatistical || isDisplayParkingSpace) {
                            ArrayList<String> samllareaIds = new ArrayList<String>();
                            for (ParkParkingAreaItem smallParkingArea : parkParkingAreaAry) {
                                smallParkingLot += smallParkingArea.getParkingLot().intValue();
                                samllareaIds.add(smallParkingArea.getId());
                            }
                            smallAuthCount = this.parkAuthorizeService.getValidAuthCountByAreaIds(samllareaIds);
                            authCount -= smallAuthCount;
                        }
                    }
                    int surplusCount = parkingArea.getParkingLot() + smallSurplusCount - Integer.parseInt(recordinCount) - authCount + allowCount;
                    this.parkCacheService.set("park:areaid:" + areaId, (Object)(surplusCount + ""), 0L);
                    this.parkCacheService.set("park:parkingLot:" + areaId, (Object)(parkingArea.getParkingLot() + smallParkingLot), 0L);
                    this.parkRecordinService.sendMsgFreeParkingSpace(areaId);
                }
                break block19;
            }
            List areaList = this.parkParkingAreaService.getAllParkingAreaExt();
            if (!CollectionUtils.isNotEmpty((Collection)areaList)) break block19;
            for (ParkParkingAreaItem area : areaList) {
                List parkParkingAreaAry;
                String areaId = area.getId();
                int smallParkingLot = 0;
                if (isShowSmallParkingLot && area.getAreaType().equals(ParkConstants.PARKAREA_BIG) && CollectionUtils.isNotEmpty((Collection)(parkParkingAreaAry = this.parkParkingAreaService.getSmallParkingAreaByMaxParkingAreaId(areaId)))) {
                    for (ParkParkingAreaItem parkParkingArea : parkParkingAreaAry) {
                        smallParkingLot += parkParkingArea.getParkingLot().intValue();
                    }
                }
                this.parkCacheService.set("park:areaid:" + areaId, (Object)area.getParkingLot().toString(), 0L);
                this.parkCacheService.set("park:parkingLot:" + areaId, (Object)(area.getParkingLot() + smallParkingLot), 0L);
                this.parkRecordinService.sendMsgFreeParkingSpace(areaId);
            }
        }
    }

    public void sendWebsocketMsg(String pavilioIP, ParkCheckOutInfo cheOutInfo) {
        cheOutInfo.setPavilioIP(pavilioIP);
        String comm = this.parkCSPavilioMsg.sendMsgToPavilio(cheOutInfo.getMsgType(), cheOutInfo);
        if (StringUtils.isNotBlank((CharSequence)pavilioIP)) {
            boolean isCsClient = this.parkDeviceService.isCsClient(cheOutInfo.getIpAddress());
            if (isCsClient) {
                this.channelService.single(pavilioIP, comm);
            }
            this.messagingTemplate.convertAndSend((Object)("/topic/parkTerminalManage/message/" + pavilioIP), (Object)comm);
            if (cheOutInfo.getMsgType().equals("carInfo")) {
                if (isCsClient) {
                    this.channelService.broadcast("manager", comm);
                }
                this.messagingTemplate.convertAndSend((Object)"/topic/parkMonitorRoom/message", (Object)comm);
            }
        } else {
            List parkPavilioItemList = this.parkPavilioService.getByCondition(new ParkPavilioItem());
            for (ParkPavilioItem parkPavilioItem : parkPavilioItemList) {
                this.channelService.single(parkPavilioItem.getIpAddress(), comm);
                this.messagingTemplate.convertAndSend((Object)("/topic/parkTerminalManage/message/" + parkPavilioItem.getIpAddress()), (Object)comm);
            }
        }
    }

    public String getNumberCodeByUnit(BigDecimal num, int type) {
        return this.park485Protocol.getNumberCodeByUnit(num, type);
    }

    public String getAscllMoney(double money) {
        return this.park485Protocol.getAscllMoney(money);
    }

    public String isDeviceConnected(long handle) {
        return this.webSocketSDKFun.isDeviceConnected(handle);
    }

    public void syncDeviceToCS(String pavilioIp, ParkDeviceItem item) {
        this.parkCSPavilioMsg.syncDeviceInfoToCS(pavilioIp, item);
    }

    public void syncChannelToCS(String pavilioIp, ParkChannelItem channelItem, String opType) {
        this.parkCSPavilioMsg.syncChannelInfoToCS(pavilioIp, channelItem, opType);
    }

    public void syncReleaToCS(String id, String name, String opType) {
        this.parkCSPavilioMsg.syncReleaInfoToCS(id, name, opType);
    }

    public void syncCarTypeToCS(String id, String name, Short carType, Short flag, String opType) {
        this.parkCSPavilioMsg.syncTempCarTypeToCS(id, name, carType, flag, opType);
    }

    public void syncShopToCS(String shopId, String shopName, List<ParkDiscountStrategyItem> discountAry, String opType) {
        this.parkCSPavilioMsg.syncShopInfo(shopId, shopName, discountAry, opType);
    }

    public void delPavilioToCS(String pavilioIp, String msg) {
        this.parkCSPavilioMsg.delPavilioToCS(pavilioIp, msg);
    }

    public void syncPavilioToCS(String pavilioIp) {
        this.parkCSPavilioMsg.syncPavilioInfoToCS(pavilioIp, false);
    }

    public void syncParamsToCS(String pavilioIp) {
        this.parkCSPavilioMsg.syncParkingSetInfoToCS(pavilioIp);
    }

    public String syncOfflineParams(String pavilioIp, String deviceIp, String paramObj) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setOfflineParam");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("params", JSONObject.parse((String)paramObj));
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineTime(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setDateTime");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("dateTime", (Object)System.currentTimeMillis());
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getParameter(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getDeviceFunList");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getDevVerInfo(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getDevVerInfo");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineChargeParam(String pavilioIp, String deviceIp, String paramStr) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("setDeviceData");
        JSONObject paramObj = JSONObject.parseObject((String)paramStr);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)paramObj.getInteger("Type"));
        data.put("count", (Object)paramObj.getInteger("Count"));
        data.put("dataBuf", (Object)paramObj.getString("DataBuf"));
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineBlackWhites(String pavilioIp, String deviceIp, int type, List<ParkBlackWhiteItem> blackWhiteItemAry, String opType) {
        int size = blackWhiteItemAry.size() * 24;
        int npos = 0;
        byte[] buffer = new byte[size];
        for (ParkBlackWhiteItem blackWhite : blackWhiteItemAry) {
            ZKLprBlackWhite zkBW = this.putCarNumber(blackWhite.getCarNumber(), blackWhite.getStartTime(), blackWhite.getEndTime());
            zkBW.packet(buffer, npos);
            npos += 24;
        }
        String base64Str = ParkWebCommonUtil.byteToBase64(buffer);
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        data.put("count", (Object)blackWhiteItemAry.size());
        data.put("plateList", (Object)base64Str);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String syncOfflineAuth(String pavilioIp, String deviceIp, List<ParkAuthorizeItem> parkAuthorizes, String opType) {
        int size = 0;
        int carNumSize = 0;
        String mode = this.parkParamsService.getParkingLotModel();
        if (ParkWebCommonUtil.isNotNull(mode) && "many".equalsIgnoreCase(mode)) {
            for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
                Set carNumSet = this.parkCarNumberService.getByAuthorId(parkAuthorize.getId());
                size += carNumSet.size() * 24;
                carNumSize += carNumSet.size();
            }
        } else {
            size += parkAuthorizes.size() * 24;
            carNumSize += parkAuthorizes.size();
        }
        int npos = 0;
        byte[] buffer = new byte[size];
        ZKLprBlackWhite zkBW = new ZKLprBlackWhite();
        for (ParkAuthorizeItem parkAuthorize : parkAuthorizes) {
            if (ParkWebCommonUtil.isNotNull(mode) && "many".equalsIgnoreCase(mode)) {
                Set carNumItemSet = this.parkCarNumberService.getByAuthorId(parkAuthorize.getId());
                for (ParkCarNumberItem carNumItem : carNumItemSet) {
                    zkBW = this.putCarNumber(carNumItem.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
                    zkBW.packet(buffer, npos);
                    npos += 24;
                }
                continue;
            }
            zkBW = this.putCarNumber(parkAuthorize.getCarNumber(), parkAuthorize.getStartTime(), parkAuthorize.getEndTime());
            zkBW.packet(buffer, npos);
            npos += 24;
        }
        String base64Str = ParkWebCommonUtil.byteToBase64(buffer);
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)ParkConstants.OPEN_TYPE_AUTH);
        data.put("count", (Object)carNumSize);
        data.put("plateList", (Object)base64Str);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflineDeviceData(String pavilioIp, String deviceIp, int offset, int type, String funcId) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg(funcId);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        if (!funcId.equals("getDeviceData")) {
            data.put("type", (Object)type);
            data.put("offset", (Object)offset);
        }
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflineParam(String pavilioIp, String deviceIp) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getOfflineParam");
        msg.setData(deviceIp);
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String getOfflinePlateList(String pavilioIp, String deviceIp, int type, int total) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("getOfflinePlateList");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        data.put("count", (Object)total);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public String clearOfflineDeviceData(String pavilioIp, String deviceIp, int type, String opType) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg(opType);
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
        return msg.getMsgId();
    }

    public void resetFactoryWithOffline(String pavilioIp, String deviceIp, int type) {
        ParkWebsocketMsg msg = new ParkWebsocketMsg("resetFactoryWithOffline");
        JSONObject data = new JSONObject();
        data.put("deviceIp", (Object)deviceIp);
        data.put("type", (Object)type);
        msg.setData(JSONObject.toJSONString((Object)data));
        this.channelService.single(pavilioIp, JSONObject.toJSONString((Object)msg));
    }

    public void sendLcdVoice2Dev(String devIp, String voiceString) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        long handle = devObj.getLongValue("handle");
        if (handle > 0L) {
            String voiceCont = ParkWebCommonUtil.convertBase64Char(voiceString);
            this.webSocketSDKFun.playVoice(handle, voiceCont);
        }
    }

    public void sendLcdDisplay2Dev(String devIp, String first, String second, String third, String fourth) {
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        Short channelStatus = devObj.getShort("channelStatus");
        Short displayType = devObj.getShort("displayType");
        long handle = devObj.getLongValue("handle");
        if (handle > 0L) {
            String base64Display = this.park485Protocol.setRealTimeLcdDisplayFor4Lines(first, second, third, fourth, channelStatus, displayType);
            this.webSocketSDKFun.tcpTransSend(handle, base64Display);
        }
    }

    public void sendLcdLight2Dev(String devIp, int colId) {
        long handle = this.parkCacheService.getHandleByIp(devIp);
        this.webSocketSDKFun.setIOLight(handle, colId);
    }

    public int connectDisplayDevice(ParkDisplayDeviceItem item, String type) {
        String msgId;
        int ret;
        JSONObject data = new JSONObject();
        data.put("IP", (Object)item.getIpAddress());
        data.put("CardType", (Object)"21");
        data.put("NetPort", (Object)"5005");
        data.put("ColorStyle", (Object)"1");
        data.put("ScreemHeight", (Object)32);
        data.put("ScreemWidth", (Object)128);
        JSONObject devInfo = this.parkCacheService.getJson("park:displaydev_info_" + item.getIpAddress());
        if (devInfo == null) {
            devInfo = new JSONObject((Map)data);
            devInfo.put("LineType", (Object)item.getLineType());
            devInfo.put("AreaId", (Object)item.getParkParkingAreaId());
            devInfo.put("Status", (Object)"offLine");
            devInfo.put("ScreemNum", (Object)-1);
        }
        if ((ret = this.parkCacheService.searchRedisByKey(msgId = this.webSocketSDKFun.connectDisplayDevice("Park_EQ2013", data))) >= 0) {
            devInfo.put("Status", (Object)"onLine");
            devInfo.put("ScreemNum", (Object)ret);
        }
        if ("init".equals(type)) {
            this.parkCacheService.setJson("park:displaydev_info_" + item.getIpAddress(), devInfo, 0L);
            if (ret >= 0) {
                JSONObject close = new JSONObject();
                close.put("ScreemNum", (Object)ret);
                this.webSocketSDKFun.closeDisplayDevice("Park_EQ2013", close);
                this.totalParkingSpacesByAreaId(item.getParkParkingAreaId());
            }
        } else if (ret >= 0) {
            this.parkCacheService.setJson("park:displaydev_info_" + item.getIpAddress(), devInfo, 0L);
            if ("reconnect".equals(type)) {
                this.parkRecordinService.sendMsgFreeParkingSpace(item.getParkParkingAreaId());
            }
        }
        return ret;
    }

    public int sentDoubleLineDisplay(String ipAddress, String firstLine, String secondLine) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.parseInt(screemNum) > 0) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_DISPALY_DEVICE_SENT firstLine = " + firstLine + " secondLine = " + secondLine);
            }
            JSONObject firstLineData = this.getSentData(screemNum, firstLine, 0);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", firstLineData);
            JSONObject secondLineData = this.getSentData(screemNum, secondLine, 1);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", secondLineData);
            return 0;
        }
        return -1;
    }

    public int sentSingleLineDisplay(String ipAddress, String content) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.parseInt(screemNum) > 0) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_DISPALY_DEVICE_SENT firstLine = " + content);
            }
            JSONObject data = this.getSentData(screemNum, content, 2);
            this.webSocketSDKFun.sentDisplayData("Park_EQ2013", data);
            return 0;
        }
        return -1;
    }

    public int closeDisplayDevice(String ipAddress) {
        this.parkCacheService.delExistsKey("park:displaydev_info_" + ipAddress);
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.parseInt(screemNum) > 0) {
            JSONObject data = new JSONObject();
            data.put("ScreemNum", (Object)screemNum);
            String msgId = this.webSocketSDKFun.closeDisplayDevice("Park_EQ2013", data);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        return -1;
    }

    private JSONObject getSentData(String screemNum, String text, int type) {
        JSONObject data = new JSONObject();
        data.put("ScreemNum", (Object)screemNum);
        data.put("Text", (Object)text);
        data.put("FontBold", (Object)0);
        data.put("FontItaic", (Object)0);
        data.put("FontUnderline", (Object)0);
        data.put("ColorFont", (Object)"0xFF");
        data.put("FontName", (Object)"\u5b8b\u4f53");
        data.put("AlignStyle", (Object)1);
        data.put("VAlignerStyle", (Object)1);
        data.put("RowSpace", (Object)0);
        data.put("Width", (Object)128);
        data.put("PosX", (Object)0);
        int fontSize = 10;
        int posY = 0;
        int height = 16;
        if (type == 1) {
            posY = height;
        } else if (type == 2) {
            fontSize = 13;
            height = 32;
        }
        data.put("PosY", (Object)posY);
        data.put("Height", (Object)height);
        data.put("FontSize", (Object)fontSize);
        return data;
    }

    public int getDisplayDeviceStatus(String ipAddress) {
        String screemNum = this.getScreemNum(ipAddress);
        if (Integer.parseInt(screemNum) > 0) {
            JSONObject data = new JSONObject();
            data.put("ScreemNum", (Object)screemNum);
            String msgId = this.webSocketSDKFun.getDisplayDeviceStatus("Park_EQ2013", data);
            return this.parkCacheService.searchRedisByKey(msgId);
        }
        return -1;
    }

    private String getScreemNum(String ipAddress) {
        String screemNum = "-1";
        JSONObject devInfo = this.parkCacheService.getJson("park:displaydev_info_" + ipAddress);
        if (devInfo != null) {
            screemNum = devInfo.getString("ScreemNum");
        }
        return screemNum;
    }

    private void zsBuilderJson(String channelId, String channelStatus, JSONObject data) {
        String lastTime = "";
        data.put("FromTime", (Object)lastTime);
        if ("zs-LPR".equals(data.getString("DeviceType"))) {
            if (StringUtils.isNotBlank((CharSequence)channelStatus)) {
                Short status = Short.valueOf(channelStatus);
                if (ParkConstants.CHANNEL_STATE_CART_IN.equals(status) || ParkConstants.CHANNEL_STATE_CAR_IN.equals(status)) {
                    lastTime = this.parkRecordinSideService.getRecordLastTimeByChannelId(channelId);
                    channelStatus = "0";
                } else {
                    lastTime = this.parkRecordoutService.getRecordLastTimeByChannelId(channelId);
                    channelStatus = "1";
                }
            }
            data.put("ChannelStatus", (Object)channelStatus);
            if (StringUtils.isNotBlank((CharSequence)lastTime)) {
                data.put("FromTime", (Object)lastTime);
            }
        }
    }

    static {
        WEBSOCKETINIT = false;
        OPENFLAG = false;
    }

    class VoiceAndViewThread
    extends Thread {
        private volatile boolean stop = false;

        VoiceAndViewThread(String threadName) {
            super.setName(threadName);
        }

        public void stopThread() {
            Thread thisThread = Thread.currentThread();
            this.stop = true;
            thisThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.stop) {
                Set keySet = ParkWebsocketServiceImpl.this.parkCacheService.keys("park:callback_voiceview:*");
                if (CollectionUtils.isNotEmpty((Collection)keySet)) {
                    for (String key : keySet) {
                        JSONObject msgObj = ParkWebsocketServiceImpl.this.parkCacheService.getJson(key);
                        String devIp = msgObj.getString("devIp");
                        Short devType = msgObj.getShort("devType");
                        String content1 = msgObj.getString("content1");
                        String content2 = msgObj.getString("content2");
                        String voiceContNew = msgObj.getString("voiceContNew");
                        String voiceContOld = msgObj.getString("voiceContOld");
                        boolean isVoiceCarNumber = msgObj.getBoolean("isVoiceCarNumber");
                        String vehicleType = msgObj.getString("vehicleType");
                        ParkWebsocketServiceImpl.this.parkCacheService.delExistsKey(key);
                        this.sendVoiceAndView(devIp, devType, content1, content2, voiceContNew, voiceContOld, isVoiceCarNumber, vehicleType);
                    }
                    continue;
                }
                this.stopThread();
            }
        }

        private void sendVoiceAndView(String devIp, Short devType, String content1, String content2, String voiceContNew, String voiceContOld, boolean isVoiceCarNumber, String vehicleType) {
            if (ParkConstants.LED_ONECOLOR.equals(devType)) {
                ParkWebsocketServiceImpl.this.sendCommandOld(devIp, content1, content2, voiceContOld);
            } else {
                if (ParkWebsocketServiceImpl.this.parkParamsService.isChineseLanguage() && isVoiceCarNumber && "true".equals(ParkWebsocketServiceImpl.this.parkParamsService.isVioceCarNumber()) && StringUtils.isNotBlank((CharSequence)content1) && !I18nUtil.i18nCode((String)"park_cmd_unknow", (Object[])new Object[0]).equals(content1) && !"Empty".equals(content1)) {
                    log.info("view device {}---{}", (Object)devIp, (Object)content1);
                    voiceContNew = ParkWebsocketServiceImpl.this.park485Protocol.getCarNumberCode(content1) + voiceContNew;
                    if (ParkWebsocketServiceImpl.this.parkParamsService.isVoiceVehicleType()) {
                        if ("fixedVehicle".equals(vehicleType)) {
                            voiceContNew = ParkVoiceEnum.VOICE_FIXEDVEHICLE.getValueByLanguage() + "," + voiceContNew;
                            content1 = ParkViewEnum.getViewContent((String)"fixedVehicle") + content1;
                        } else if ("vipVehicle".equals(vehicleType)) {
                            voiceContNew = ParkVoiceEnum.VOICE_VIPVEHICLE.getValueByLanguage() + "," + voiceContNew;
                            content1 = ParkViewEnum.getViewContent((String)"vipVehicle") + content1;
                        } else if ("tempVehicle".equals(vehicleType)) {
                            voiceContNew = ParkVoiceEnum.VOICE_TEMPVEHICLE.getValueByLanguage() + "," + voiceContNew;
                            content1 = ParkViewEnum.getViewContent((String)"tempVehicle") + content1;
                        }
                    }
                }
                List<Short> lcdType = Arrays.asList(ParkConstants.LCD_HALFSCREEN, ParkConstants.LCD_FULLSCREEN);
                if (ParkConstants.LED_FOURCOLOR.equals(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandNewFor4Lines(devIp, content1, content2, voiceContNew);
                } else if (ParkConstants.LED_TWOCOLOR.equals(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandNew(devIp, content1, content2, voiceContNew);
                } else if (ParkConstants.LED_TWOVERTICAL.equals(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandNewTwoVertical(devIp, content1, content2, voiceContNew);
                } else if (ParkConstants.LED_ONEROW.equals(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandNewSingleLines(devIp, content1, content2, voiceContNew);
                } else if (lcdType.contains(devType)) {
                    ParkWebsocketServiceImpl.this.sendCommandLcd4Lines(devIp, content1, content2);
                }
            }
        }
    }

    class WebsocketServiceInit
    extends Thread {
        public WebsocketServiceInit(String name) {
            super(name);
        }

        @Override
        public void run() {
            if (!ParkWebsocketServiceImpl.this.parkCacheService.exists("park:logger")) {
                ParkWebsocketServiceImpl.this.parkCacheService.set("park:logger", (Object)"0", 0L);
            }
            ParkWebsocketServiceImpl.this.delOldDataFromRedis();
            ParkWebsocketServiceImpl.this.parkCarTypeService.setCarTypeToCache();
            ParkWebsocketServiceImpl.this.parkPavilioService.setPavilioModeToCache();
            ParkWebsocketServiceImpl.this.totalParkingSpaces();
            if (ParkWebsocketServiceImpl.this.parkParamsService.isLprCamera()) {
                ParkWebsocketServiceImpl.this.parkParkingLotService.setParkingLotInfoToCache(null);
                ParkWebsocketServiceImpl.this.parkDoubleVerifyAccDeviceService.setAllDetailToCache();
                ParkWebsocketServiceImpl.this.parkDeviceService.setAllDeviceDetailToCache();
                ParkWebsocketServiceImpl.this.parkChannelService.setAllChannelDetailToCache();
                ParkWebsocketServiceImpl.this.createSDKService();
            }
            WEBSOCKETINIT = true;
        }
    }
}

