/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient.protocol;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.sdkClient.protocol.Park485Protocol;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkSendCmd {
    @Autowired
    private Park485Protocol park485Protocol;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    private Map<String, Short> viewContentMap = new ConcurrentHashMap<String, Short>();

    public String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private void hexStringToByte(String strHex, byte[] buf) {
        while (strHex.length() < 4) {
            strHex = "0" + strHex;
        }
        int nLen = strHex.length() / 2;
        for (int i = 0; i < nLen; ++i) {
            buf[i] = Integer.valueOf(strHex.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
    }

    public void test(int d) {
        String[] str = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] ss = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf"};
        String s = String.valueOf(d);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String index = String.valueOf(s.charAt(i));
            sb = sb.append(str[Integer.parseInt(index)]);
        }
        String sss = String.valueOf(sb);
        int i = 0;
        for (int j = sss.length(); j > 0; --j) {
            sb = sb.insert(j, ss[i++]);
        }
    }

    public void viewDefaContent() {
        if ("zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            return;
        }
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (StringUtils.isNotBlank((CharSequence)devIpStr) && this.parkParamsService.onlineFlag()) {
            String[] devIpAry;
            List<Short> lcd = Arrays.asList(ParkConstants.LCD_HALFSCREEN, ParkConstants.LCD_FULLSCREEN);
            for (String devIp : devIpAry = devIpStr.split(",")) {
                JSONObject devJson = this.parkCacheService.getCacheDevInfo(devIp);
                String state = devJson.getString("state");
                if (StringUtils.isBlank((CharSequence)devJson.getString("channelId")) || "offLine".equals(state)) continue;
                String protype = devJson.getString("protype");
                if ("best-w".equals(protype)) {
                    String sn = devJson.getString("sn");
                    String viewTimeRedis = this.parkCacheService.getStr("park:view_defa_content:" + sn);
                    if (!StringUtils.isNotBlank((CharSequence)viewTimeRedis)) continue;
                    this.ldeIdleDisplay(devJson, viewTimeRedis);
                    continue;
                }
                long handle = devJson.getLong("handle");
                String viewTimeRedis = this.parkCacheService.getStr("park:view_defa_content:" + handle);
                if (StringUtils.isNotBlank((CharSequence)viewTimeRedis)) {
                    this.ldeIdleDisplay(devJson, viewTimeRedis);
                }
                this.sendLights(lcd, devIp, devJson);
            }
        }
    }

    private void sendLights(List<Short> lcd, String devIp, JSONObject devJson) {
        if (ParkConstants.DEVICE_TYPE_ZS.equals(devJson.getShort("lprDevType"))) {
            JSONObject jsonLight;
            String lightKey = "park:trafficLights_devIp:" + devIp;
            long timeMillis = System.currentTimeMillis();
            if (this.parkCacheService.exists(lightKey)) {
                jsonLight = this.parkCacheService.getJson(lightKey);
                long time = jsonLight.getLong("timeLight");
                if (1 == jsonLight.getIntValue("statusLight") && timeMillis - time >= 6000L) {
                    if (lcd.contains(devJson.getShort("displayType"))) {
                        this.parkWebsocketService.sendLcdLight2Dev(devIp, 2);
                    } else if (ParkConstants.LED_TWOVERTICAL.equals(devJson.getShort("displayType"))) {
                        byte[] msgBag = this.park485Protocol.sendTrafficLights153(ParkConstants.LED_TWOVERTICAL, 2);
                        this.parkWebsocketService.sendMsg(devIp, msgBag, 153);
                    } else {
                        byte[] msgBag = this.park485Protocol.sendTrafficLights153(ParkConstants.LED_FOURCOLOR, 2);
                        this.parkWebsocketService.sendMsg(devIp, msgBag, 153);
                    }
                    jsonLight.put("statusLight", (Object)2);
                }
            } else {
                jsonLight = new JSONObject();
                jsonLight.put("timeLight", (Object)timeMillis);
                jsonLight.put("statusLight", (Object)1);
            }
            this.parkCacheService.setJson("park:trafficLights_devIp:" + devIp, jsonLight, 0L);
        }
    }

    private void ldeIdleDisplay(JSONObject devObj, String viewTimeRedis) {
        String ipAddr = devObj.getString("ipAddr");
        String viewCode = this.parkParamsService.getViewCode();
        Long currentTimeMillis = System.currentTimeMillis();
        Long viewTime = Long.valueOf(viewTimeRedis);
        long idleTimeInterval = Long.parseLong(this.parkParamsService.getIdleTimeInterval());
        if (currentTimeMillis >= viewTime || (viewTime - currentTimeMillis) / 1000L < idleTimeInterval / 3L) {
            String displayType = devObj.getString("displayType");
            String channelId = devObj.getString("channelId");
            Short channelStatus = Short.valueOf(devObj.getString("channelStatus"));
            String first = this.parkParamsService.getCompanyName();
            String second = ParkViewEnum.getFormatTime((String)viewCode);
            String freeParking = this.getFreeParking(devObj.getString("parkingAreaId"));
            switch (displayType) {
                case "1": {
                    this.sendIdleDisplay2Lines(ipAddr, viewCode, channelStatus, first, second, freeParking, channelId, ParkConstants.LED_TWOCOLOR);
                    break;
                }
                case "2": {
                    this.sendIdleDisplay4Lines(ipAddr, viewCode, channelStatus, first, second, freeParking, ParkConstants.LED_FOURCOLOR);
                    break;
                }
                case "9": {
                    this.sendIdleDisplaySingleLine(ipAddr, viewCode, first, channelStatus, freeParking);
                    break;
                }
                case "8": {
                    this.sendIdleDisplay2Lines(ipAddr, viewCode, channelStatus, first, second, freeParking, channelId, ParkConstants.LED_TWOVERTICAL);
                    break;
                }
                case "0": {
                    this.sendIdleDisplay2Lines(ipAddr, viewCode, channelStatus, first, second, freeParking, channelId, ParkConstants.LED_ONECOLOR);
                    break;
                }
                case "11": 
                case "12": {
                    this.sendIdleDisplay4Lines(ipAddr, viewCode, channelStatus, first, second, freeParking, ParkConstants.LCD_HALFSCREEN);
                    break;
                }
            }
        }
    }

    private void sendIdleDisplaySingleLine(String devIp, String viewCode, String second, Short channelStatus, String freeParking) {
        List<Short> channelStatusOut;
        if ("true".equals(this.parkParamsService.isShowParkingLot())) {
            second = ParkViewEnum.getViewContent((String)viewCode, (String)"remainPark") + freeParking;
        }
        if ((channelStatusOut = Arrays.asList(ParkConstants.CHANNEL_STATE_CART_OUT, ParkConstants.CHANNEL_STATE_CAR_OUT, ParkConstants.CHANNEL_STATE_CENT_EXPORT)).contains(channelStatus)) {
            second = ParkViewEnum.getViewContent((String)viewCode, (String)"displayTicket");
        }
        byte[] msgBag = this.park485Protocol.setRealTimeDisplay174SingleLine("", second, devIp);
        this.parkWebsocketService.sendMsg(devIp, msgBag, 174);
    }

    private void sendIdleDisplay2Lines(String devIp, String viewCode, Short channelStatus, String first, String second, String freeParking, String channelId, Short displayType) {
        byte[] msgBag;
        String[] viewStr = new String[]{first, second};
        List<Short> channelStateIn = Arrays.asList(ParkConstants.CHANNEL_STATE_CART_IN, ParkConstants.CHANNEL_STATE_CAR_IN);
        if ("true".equals(this.parkParamsService.isShowParkingLot()) && channelStateIn.contains(channelStatus)) {
            Short viewContent = 0;
            if (this.viewContentMap.containsKey(channelId)) {
                viewContent = this.viewContentMap.get(channelId);
            }
            if (viewContent == 0 && !"0000".equals(freeParking)) {
                viewContent = 1;
            } else {
                viewStr[0] = ParkViewEnum.getViewContent((String)viewCode, (String)"remainPark");
                viewStr[1] = freeParking;
                viewContent = 0;
            }
            this.viewContentMap.put(channelId, viewContent);
        }
        if (ParkConstants.LED_TWOCOLOR.equals(displayType)) {
            msgBag = this.park485Protocol.setRealTimeDisplay174(viewStr[0], viewStr[1], devIp);
            this.parkWebsocketService.sendMsg(devIp, msgBag, 174);
        } else if (ParkConstants.LED_TWOVERTICAL.equals(displayType)) {
            msgBag = this.park485Protocol.setRealTimeDisplay174TwoVertical(viewStr[0], viewStr[1], devIp);
            this.parkWebsocketService.sendMsg(devIp, msgBag, 1);
        } else if (ParkConstants.LED_ONECOLOR.equals(displayType)) {
            msgBag = this.park485Protocol.assembleMsg(viewStr, devIp, 1);
            this.parkWebsocketService.sendMsg(devIp, msgBag, 1);
        }
    }

    private void sendIdleDisplay4Lines(String devIp, String viewCode, Short channelStatus, String first, String second, String freeParking, Short displayType) {
        String third = ParkViewEnum.getViewContent((String)viewCode, (String)"displayRecognition");
        String fourth = ParkViewEnum.getViewContent((String)viewCode, (String)"displaySlowDown");
        List<Short> channelStateIn = Arrays.asList(ParkConstants.CHANNEL_STATE_CART_IN, ParkConstants.CHANNEL_STATE_CAR_IN);
        if ("true".equals(this.parkParamsService.isShowParkingLot()) && channelStateIn.contains(channelStatus)) {
            third = ParkViewEnum.getViewContent((String)viewCode, (String)"remainPark");
            fourth = freeParking;
        }
        if (ParkConstants.LED_FOURCOLOR.equals(displayType)) {
            byte[] msgBag = this.park485Protocol.setRealTimeDisplay174For4Lines(first, second, third, fourth, devIp);
            this.parkWebsocketService.sendMsg(devIp, msgBag, 174);
        } else if (ParkConstants.LCD_HALFSCREEN.equals(displayType)) {
            this.parkWebsocketService.sendLcdDisplay2Dev(devIp, first, second, third, fourth);
        }
    }

    private String getFreeParking(String parkingAreaId) {
        String parkLot;
        int freeParking = 0;
        if (this.parkCacheService.exists("park:areaid:" + parkingAreaId) && StringUtils.isNotBlank((CharSequence)(parkLot = this.parkCacheService.getStr("park:areaid:" + parkingAreaId))) && Integer.parseInt(parkLot) > 0) {
            freeParking = Integer.parseInt(parkLot);
        }
        return String.format("%04d", freeParking);
    }
}

