/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient.protocol;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.enums.ParkVoiceEnum;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkCRC16Util;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Park485Protocol {
    private static final Logger log = LoggerFactory.getLogger(Park485Protocol.class);
    private static final int devAddrSingleLine = 65;
    private static final int devAddr2Lines4Words = 66;
    private static final int devAddr4Lines4Words = 67;
    private static final int devAddr2Lines2Words = 68;
    private static final int devAddr4Lines8Words = 69;
    private static final int FIRST_35 = 35;
    private static final int SECOND_36 = 36;
    private static final int THIRD_37 = 37;
    private static final int FOURTH_38 = 38;
    private static final int MONEY_PRECISION = 2;
    private static int count = 0;
    private static final int countMax = Short.MAX_VALUE;
    private final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private final String CN_NEGATIVE = "\u8d1f";
    private final String CN_ZERO_FULL = "\u96f6\u5143";
    private final String PARK_PAY = "\u8bf7\u7f34\u8d39";
    private final String PARK_VLD = "\u6709\u6548\u671f";
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkCacheService parkCacheService;
    private static final Map<String, String> carNumberCodeMap = new HashMap<String, String>(){
        {
            this.put("0", "001");
            this.put("1", "002");
            this.put("2", "003");
            this.put("3", "004");
            this.put("4", "005");
            this.put("5", "006");
            this.put("6", "007");
            this.put("7", "008");
            this.put("8", "009");
            this.put("9", "010");
            this.put("A", "011");
            this.put("B", "012");
            this.put("C", "013");
            this.put("D", "014");
            this.put("E", "015");
            this.put("F", "016");
            this.put("G", "017");
            this.put("H", "018");
            this.put("I", "019");
            this.put("J", "020");
            this.put("K", "021");
            this.put("L", "022");
            this.put("M", "023");
            this.put("N", "024");
            this.put("O", "025");
            this.put("P", "026");
            this.put("Q", "027");
            this.put("R", "028");
            this.put("S", "029");
            this.put("T", "030");
            this.put("U", "031");
            this.put("V", "032");
            this.put("W", "033");
            this.put("X", "034");
            this.put("Y", "035");
            this.put("Z", "036");
            this.put("\u4eac", "051");
            this.put("\u6d25", "052");
            this.put("\u6caa", "053");
            this.put("\u6e1d", "054");
            this.put("\u6842", "055");
            this.put("\u5b81", "056");
            this.put("\u65b0", "057");
            this.put("\u85cf", "058");
            this.put("\u8499", "059");
            this.put("\u5180", "060");
            this.put("\u664b", "061");
            this.put("\u8fbd", "062");
            this.put("\u5409", "063");
            this.put("\u9ed1", "064");
            this.put("\u82cf", "065");
            this.put("\u6d59", "066");
            this.put("\u7696", "067");
            this.put("\u95fd", "068");
            this.put("\u8d63", "069");
            this.put("\u9c81", "070");
            this.put("\u8c6b", "071");
            this.put("\u9102", "072");
            this.put("\u6e58", "073");
            this.put("\u7ca4", "074");
            this.put("\u743c", "075");
            this.put("\u5ddd", "076");
            this.put("\u8d35", "077");
            this.put("\u4e91", "078");
            this.put("\u9655", "079");
            this.put("\u7518", "080");
            this.put("\u9752", "081");
            this.put("\u5b66", "082");
            this.put("\u6302", "083");
            this.put("\u9886", "084");
            this.put("\u4f7f", "085");
            this.put("\u6e2f", "086");
            this.put("\u6fb3", "087");
            this.put("\u8b66", "088");
            this.put("\u7a7a", "089");
            this.put("\u519b", "090");
            this.put("\u5317", "091");
            this.put("\u6c88", "092");
            this.put("\u5170", "093");
            this.put("\u6d4e", "094");
            this.put("\u5357", "095");
            this.put("\u5e7f", "096");
            this.put("\u6210", "097");
        }
    };

    public String getNumberCodeByUnit(BigDecimal num, int type) {
        String[] VOICE_NUMBER_CODE = new String[]{ParkVoiceEnum.VOICE_ZERO.getValueByLanguage(), ParkVoiceEnum.VOICE_ONE.getValueByLanguage(), ParkVoiceEnum.VOICE_TWO.getValueByLanguage(), ParkVoiceEnum.VOICE_THREE.getValueByLanguage(), ParkVoiceEnum.VOICE_FOUR.getValueByLanguage(), ParkVoiceEnum.VOICE_FIVE.getValueByLanguage(), ParkVoiceEnum.VOICE_SIX.getValueByLanguage(), ParkVoiceEnum.VOICE_SEVEN.getValueByLanguage(), ParkVoiceEnum.VOICE_EIGHT.getValueByLanguage(), ParkVoiceEnum.VOICE_NINE.getValueByLanguage()};
        String[] VOICE_UNIT_CODE = new String[]{"040", "039", "038", "043", "044", "045", "046", "043", "044", "045", "002", "043", "044", "045"};
        if (1 == type) {
            VOICE_UNIT_CODE[2] = ParkVoiceEnum.VOICE_DAY.getValueByLanguage();
        }
        StringBuffer sb = new StringBuffer();
        int signum = num.signum();
        if (signum == 0) {
            if (1 == type) {
                return "001,050";
            }
            return "001,038";
        }
        long number = num.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, VOICE_UNIT_CODE[6] + ",");
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, VOICE_UNIT_CODE[10] + ",");
                }
                sb.insert(0, VOICE_UNIT_CODE[numIndex] + ",");
                sb.insert(0, VOICE_NUMBER_CODE[numUnit] + ",");
                zeroSize = 0;
            } else {
                if (numIndex > 2 && ++zeroSize == 1) {
                    sb.insert(0, VOICE_NUMBER_CODE[0] + ",");
                }
                if (numIndex == 2) {
                    sb.insert(0, VOICE_UNIT_CODE[numIndex] + ",");
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, VOICE_UNIT_CODE[numIndex] + ",");
                }
            }
            number /= 10L;
            ++numIndex;
        }
        return ParkWebCommonUtil.replaceExComma(sb.toString());
    }

    public String getCarNumberCode(String carNumber) {
        char[] carNumberChar;
        if (!this.parkParamsService.getVoiceProvince()) {
            carNumber = carNumber.substring(1);
        }
        StringBuffer carNumberCodeBuffer = new StringBuffer();
        for (char carChar : carNumberChar = carNumber.toCharArray()) {
            String plateChar = String.valueOf(carChar);
            if (!carNumberCodeMap.containsKey(plateChar)) continue;
            carNumberCodeBuffer.append(carNumberCodeMap.get(plateChar)).append(",");
        }
        return carNumberCodeBuffer.toString();
    }

    private String number2CNMontrayUnit(BigDecimal numberOfMoney, int type) {
        StringBuffer sb = new StringBuffer();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            if (type == 1) {
                return "\u96f6";
            }
            return "\u96f6\u5143";
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[10]);
                }
                if (numIndex != 2 || type == 0) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                sb.insert(0, this.CN_UPPER_NUMBER[numUnit]);
                zeroSize = 0;
            } else {
                if (numIndex > 2 && number > 0L && ++zeroSize == 1) {
                    sb.insert(0, this.CN_UPPER_NUMBER[0]);
                }
                if (numIndex == 2 && number > 0L && type == 0) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, this.CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, "\u8d1f");
        }
        return sb.toString();
    }

    public byte[] getVoiceByteByCode(String voiceCode) {
        String[] voiceLocalArray = voiceCode.split(",");
        byte[] voiceByte = new byte[voiceLocalArray.length * 2];
        for (int i = 0; i < voiceLocalArray.length; ++i) {
            if ("null".equals(voiceLocalArray[i])) continue;
            voiceByte[i * 2] = (byte)Integer.parseInt(voiceLocalArray[i]);
        }
        return voiceByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] basicFormatSingleLine(int dataLen, int comm) {
        byte[] msgBag = new byte[dataLen + 9];
        msgBag[0] = -86;
        msgBag[1] = 65;
        Class<Park485Protocol> clazz = Park485Protocol.class;
        synchronized (Park485Protocol.class) {
            byte[] len = new byte[2];
            String lenStr = this.getSerialNum();
            this.hexStringToByte(lenStr, len);
            msgBag[2] = len[1];
            msgBag[3] = len[0];
            msgBag[4] = (byte)comm;
            len = new byte[2];
            lenStr = Integer.toHexString(dataLen);
            this.hexStringToByte(lenStr, len);
            msgBag[5] = len[1];
            msgBag[6] = len[0];
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return msgBag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] basicFormat(int dataLen, int comm) {
        byte[] msgBag = new byte[dataLen + 9];
        msgBag[0] = -86;
        msgBag[1] = 66;
        Class<Park485Protocol> clazz = Park485Protocol.class;
        synchronized (Park485Protocol.class) {
            byte[] len = new byte[2];
            String lenStr = this.getSerialNum();
            this.hexStringToByte(lenStr, len);
            msgBag[2] = len[1];
            msgBag[3] = len[0];
            msgBag[4] = (byte)comm;
            len = new byte[2];
            lenStr = Integer.toHexString(dataLen);
            this.hexStringToByte(lenStr, len);
            msgBag[5] = len[1];
            msgBag[6] = len[0];
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return msgBag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] basicFormatFor4Lines(int dataLen, int comm) {
        byte[] msgBag = new byte[dataLen + 9];
        msgBag[0] = -86;
        msgBag[1] = 67;
        Class<Park485Protocol> clazz = Park485Protocol.class;
        synchronized (Park485Protocol.class) {
            byte[] len = new byte[2];
            String lenStr = this.getSerialNum();
            this.hexStringToByte(lenStr, len);
            msgBag[2] = len[1];
            msgBag[3] = len[0];
            msgBag[4] = (byte)comm;
            len = new byte[2];
            lenStr = Integer.toHexString(dataLen);
            this.hexStringToByte(lenStr, len);
            msgBag[5] = len[1];
            msgBag[6] = len[0];
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return msgBag;
        }
    }

    private synchronized String getSerialNum() {
        if (Short.MAX_VALUE <= count) {
            count = 0;
        }
        String lenStr = Integer.toHexString(count + 1);
        ++count;
        if (this.parkParamsService.printParkLogger()) {
            log.info("Park485Protocol basicFormat2/4Lines serials number:{}", (Object)count);
        }
        return lenStr;
    }

    public byte[] setCountryCode170(int countCode, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(2, 170);
            byte[] len = new byte[2];
            String lenStr = Integer.toHexString(countCode);
            this.hexStringToByte(lenStr, len);
            msgBag[7] = len[1];
            msgBag[8] = len[0];
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] setMovingDire171(int direction, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 171);
            msgBag[7] = (byte)this.hexStringToInt(direction);
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] setMovingSpeed172(int speed, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(2, 172);
            msgBag[7] = (byte)speed;
            msgBag[8] = 0;
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] setDefaultDisplay173(String content_F, String content_S, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            byte[] msg_F = this.transcodingForLPR(content_F);
            byte[] msg_S = this.transcodingForLPR(content_S);
            int paramLen = msg_F.length + msg_S.length + 8;
            msgBag = this.basicFormat(paramLen, 173);
            byte[] dataBag = new byte[paramLen];
            dataBag[0] = 35;
            byte[] len1 = this.integerToByte(msg_F.length + 1);
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = 1;
            System.arraycopy(msg_F, 0, dataBag, 4, msg_F.length);
            paramLen = msg_F.length + 4;
            dataBag[paramLen] = 36;
            byte[] len2 = this.integerToByte(msg_S.length + 1);
            dataBag[paramLen + 1] = len2[1];
            dataBag[paramLen + 2] = len2[0];
            dataBag[paramLen + 3] = 1;
            System.arraycopy(msg_S, 0, dataBag, paramLen + 4, msg_S.length);
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] setRealTimeDisplay174(String content_F, String content_S, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("Park485Protocol SetRealTimeDisplay174: ipAddr = " + devIp + " , " + content_F + ";" + content_S);
            }
            byte[] msg_F = this.transcodingForLPR(content_F);
            byte[] msg_S = this.transcodingForLPR(content_S);
            int paramLen = msg_F.length + msg_S.length + 8;
            msgBag = this.basicFormat(paramLen, 174);
            byte[] dataBag = new byte[paramLen];
            dataBag[0] = 35;
            byte[] len1 = this.integerToByte(msg_F.length + 1);
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = Integer.valueOf(this.parkParamsService.getFirstLineColor()).byteValue();
            System.arraycopy(msg_F, 0, dataBag, 4, msg_F.length);
            paramLen = msg_F.length + 4;
            dataBag[paramLen] = 36;
            byte[] len2 = this.integerToByte(msg_S.length + 1);
            dataBag[paramLen + 1] = len2[1];
            dataBag[paramLen + 2] = len2[0];
            dataBag[paramLen + 3] = Integer.valueOf(this.parkParamsService.getSecondLineColor()).byteValue();
            System.arraycopy(msg_S, 0, dataBag, paramLen + 4, msg_S.length);
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] setRealTimeDisplay174SingleLine(String content_F, String content_S, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("Park485Protocol SetRealTimeDisplay174SingleLine: ipAddr = " + devIp + " , " + content_F + ";" + content_S);
            }
            byte[] msg_F = this.transcodingForTBM(content_S);
            int paramLen = msg_F.length + 8;
            msgBag = this.basicFormatSingleLine(paramLen, 174);
            byte[] dataBag = new byte[paramLen];
            dataBag[0] = 35;
            byte[] len1 = this.integerToByte(msg_F.length + 1);
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = 0;
            System.arraycopy(msg_F, 0, dataBag, 4, msg_F.length);
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] setRealTimeDisplay174TwoVertical(String content_F, String content_S, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("Park485Protocol setRealTimeDisplay174TwoVertical: ipAddr = " + devIp + " , " + content_F + ";" + content_S);
            }
            byte[] msg_F = this.transcodingForLPR(content_F);
            byte[] msg_S = this.transcodingForLPR(content_S);
            int paramLen = msg_F.length + msg_S.length + 8;
            msgBag = this.basicFormat(paramLen, 174);
            byte[] dataBag = new byte[paramLen];
            dataBag[0] = 35;
            byte[] len1 = this.integerToByte(msg_F.length + 1);
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = Integer.valueOf("0").byteValue();
            System.arraycopy(msg_F, 0, dataBag, 4, msg_F.length);
            paramLen = msg_F.length + 4;
            dataBag[paramLen] = 36;
            byte[] len2 = this.integerToByte(msg_S.length + 1);
            dataBag[paramLen + 1] = len2[1];
            dataBag[paramLen + 2] = len2[0];
            dataBag[paramLen + 3] = Integer.valueOf("0").byteValue();
            System.arraycopy(msg_S, 0, dataBag, paramLen + 4, msg_S.length);
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] setRealTimeDisplay174For4Lines(String first, String second, String third, String fourth, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("Park485Protocol SetRealTimeDisplay174For4Lines: ipAddr = " + devIp + " , " + first + ";" + second + ";" + third + ";" + fourth);
            }
            byte[] msg_first = this.transcodingForLPR(first);
            byte[] msg_second = this.transcodingForLPR(second);
            byte[] msg_third = this.transcodingForLPR(third);
            byte[] msg_fourth = this.transcodingForLPR(fourth);
            int paramLen = msg_first.length + msg_second.length + msg_third.length + msg_fourth.length + 16;
            msgBag = this.basicFormatFor4Lines(paramLen, 174);
            byte[] dataBag = new byte[paramLen];
            dataBag[0] = 35;
            byte[] len1 = this.integerToByte(msg_first.length + 1);
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = Integer.valueOf(this.parkParamsService.getFirstLineColor()).byteValue();
            System.arraycopy(msg_first, 0, dataBag, 4, msg_first.length);
            paramLen = msg_first.length + 4;
            dataBag[paramLen] = 36;
            byte[] len2 = this.integerToByte(msg_second.length + 1);
            dataBag[paramLen + 1] = len2[1];
            dataBag[paramLen + 2] = len2[0];
            dataBag[paramLen + 3] = Integer.valueOf(this.parkParamsService.getSecondLineColor()).byteValue();
            System.arraycopy(msg_second, 0, dataBag, paramLen + 4, msg_second.length);
            paramLen = paramLen + msg_second.length + 4;
            dataBag[paramLen] = 37;
            byte[] len3 = this.integerToByte(msg_third.length + 1);
            dataBag[paramLen + 1] = len3[1];
            dataBag[paramLen + 2] = len3[0];
            dataBag[paramLen + 3] = Integer.valueOf(this.parkParamsService.getThirdLineColor()).byteValue();
            System.arraycopy(msg_third, 0, dataBag, paramLen + 4, msg_third.length);
            paramLen = paramLen + msg_third.length + 4;
            dataBag[paramLen] = 38;
            byte[] len4 = this.integerToByte(msg_fourth.length + 1);
            dataBag[paramLen + 1] = len4[1];
            dataBag[paramLen + 2] = len4[0];
            dataBag[paramLen + 3] = Integer.valueOf(this.parkParamsService.getFourthLineColor()).byteValue();
            System.arraycopy(msg_fourth, 0, dataBag, paramLen + 4, msg_fourth.length);
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public String getDigitalVoice(String license, String voice) {
        if ("true".equals(this.parkParamsService.isVioceCarNumber())) {
            if (!this.parkParamsService.getVoiceProvince()) {
                license = license.substring(1);
            }
        } else {
            license = "";
        }
        String amount = voice;
        if (voice.contains("\u8bf7\u7f34\u8d39") || voice.contains("\u6709\u6548\u671f")) {
            String amountOld = ParkWebCommonUtil.getDigits(voice);
            BigDecimal numberOfMoney = new BigDecimal(amountOld);
            if (voice.contains("\u8bf7\u7f34\u8d39")) {
                amount = amount.substring(0, amount.indexOf(amountOld)) + this.number2CNMontrayUnit(numberOfMoney, 0);
            }
            if (voice.contains("\u6709\u6548\u671f")) {
                amount = amount.replace(amountOld, this.number2CNMontrayUnit(numberOfMoney, 1));
            }
        }
        return license + amount;
    }

    public String getAscllMoney(double money) {
        BigDecimal numberOfMoney = new BigDecimal(Double.toString(money));
        numberOfMoney = numberOfMoney.setScale(1, 4);
        String ascMoney = this.number2CNMontrayUnit(numberOfMoney, 0);
        ascMoney = ascMoney.replace("\u4edf", "e");
        ascMoney = ascMoney.replace("\u4f70", "B");
        if ((ascMoney = ascMoney.replace("\u62fe", "A")).indexOf("\u89d2") > -1) {
            ascMoney = ascMoney.replace("\u5143", "C");
            ascMoney = ascMoney.replace("\u89d2", "E");
        } else {
            ascMoney = ascMoney.replace("\u5143", "E");
        }
        ascMoney = ascMoney.replace("\u7396", "9");
        ascMoney = ascMoney.replace("\u634c", "8");
        ascMoney = ascMoney.replace("\u67d2", "7");
        ascMoney = ascMoney.replace("\u9646", "6");
        ascMoney = ascMoney.replace("\u4f0d", "5");
        ascMoney = ascMoney.replace("\u8086", "4");
        ascMoney = ascMoney.replace("\u53c1", "3");
        ascMoney = ascMoney.replace("\u8d30", "2");
        ascMoney = ascMoney.replace("\u58f9", "1");
        ascMoney = ascMoney.replace("\u96f6", "0");
        return ascMoney;
    }

    public byte[] voiceInfo(String cont, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            String[] voiceStr = new String[]{cont};
            msgBag = this.assembleMsg(voiceStr, devIp, 2);
        }
        return msgBag;
    }

    public byte[] viewInfo(String content1, String content2, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            String[] viewStr = new String[]{content1, content2};
            long handle = this.parkCacheService.getHandleByIp(devIp);
            if (ParkWebCommonUtil.isNotNull(handle) && handle != 0L) {
                Timestamp nowTime = new Timestamp(System.currentTimeMillis());
                Timestamp newTime = ParkWebCommonUtil.pastTime(nowTime, 0, -20);
                String handleStr = "park:view_defa_content:" + handle;
                if (this.parkCacheService.exists(handleStr)) {
                    this.parkCacheService.set(handleStr, (Object)String.valueOf(newTime.getTime()), 0L);
                    msgBag = this.assembleMsg(viewStr, devIp, 1);
                }
            }
        }
        return msgBag;
    }

    public byte[] assembleMsg(String[] ascIIStr, String devIp, int devType) {
        byte[] msgBag = null;
        try {
            byte[] msgAry = ascIIStr[0].getBytes("GBK");
            if (ascIIStr.length > 1) {
                byte[] msg_F = ascIIStr[0].getBytes("GBK");
                byte[] msg_S = ascIIStr[1].getBytes("GBK");
                msgAry = new byte[msg_F.length + msg_S.length + 1];
                System.arraycopy(msg_F, 0, msgAry, 0, msg_F.length);
                msgAry[msg_F.length] = 10;
                System.arraycopy(msg_S, 0, msgAry, msg_F.length + 1, msg_S.length);
            }
            msgBag = this.protocolAssembly(0, devType, 1, msgAry);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return msgBag;
    }

    public byte[] protocolAssembly(int devAddr, int devType, int cnt, byte[] info) {
        byte[] msgBag = new byte[info.length + 9];
        msgBag[0] = -86;
        msgBag[1] = (byte)devAddr;
        msgBag[2] = 5;
        byte[] len = new byte[2];
        String lenStr = Integer.toHexString(info.length + 2);
        this.hexStringToByte(lenStr, len);
        msgBag[3] = len[1];
        msgBag[4] = len[0];
        msgBag[5] = (byte)cnt;
        msgBag[6] = (byte)devType;
        for (int i = 0; i < info.length; ++i) {
            msgBag[7 + i] = info[i];
        }
        byte[] temData = new byte[info.length + 6];
        System.arraycopy(msgBag, 1, temData, 0, info.length + 6);
        byte[] crc16R = new byte[2];
        String crcStr = ParkCRC16Util.crcTable(temData, 0, temData.length);
        this.hexStringToByte(crcStr, crc16R);
        msgBag[7 + info.length] = crc16R[1];
        msgBag[8 + info.length] = crc16R[0];
        return msgBag;
    }

    public byte[] setVolume175(int volume, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 175);
            msgBag[7] = (byte)volume;
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] interruptedVolume176(String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 176);
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] sendVoice177ForSingleLine(byte[] voiceContent, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            msgBag = this.basicFormatSingleLine(voiceContent.length, 177);
            System.arraycopy(voiceContent, 0, msgBag, 7, voiceContent.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] sendVoice177(byte[] voiceContent, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            msgBag = this.basicFormat(voiceContent.length, 177);
            System.arraycopy(voiceContent, 0, msgBag, 7, voiceContent.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] sendVoice177For4Lines(byte[] voiceContent, String devIp) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            msgBag = this.basicFormatFor4Lines(voiceContent.length, 177);
            System.arraycopy(voiceContent, 0, msgBag, 7, voiceContent.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public byte[] getTime178(Date date, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(7, 178);
            msgBag[7] = (byte)this.hexStringToInt(date.getSeconds());
            msgBag[8] = (byte)this.hexStringToInt(date.getMinutes());
            msgBag[9] = (byte)this.hexStringToInt(date.getHours());
            msgBag[10] = 0;
            msgBag[11] = (byte)this.hexStringToInt(date.getDate());
            msgBag[12] = (byte)this.hexStringToInt(date.getMonth());
            msgBag[13] = (byte)this.hexStringToInt(date.getYear());
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] getVersion179(String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 179);
            msgBag[7] = 0;
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] setDefaultParam180(String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 180);
            msgBag[7] = 0;
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] setDisplayLongTime181(int times, String devIp) {
        if (this.parkParamsService.isLprCamera()) {
            byte[] msgBag = this.basicFormat(1, 181);
            msgBag[7] = (byte)times;
            this.generateCRC16(msgBag);
        }
        return null;
    }

    public byte[] sendTrafficLights153(Short baseType, int colId) {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            msgBag = ParkConstants.LED_TWOVERTICAL.equals(baseType) ? this.basicFormat(4, 153) : this.basicFormatFor4Lines(4, 153);
            byte[] dataBag = new byte[4];
            byte[] len1 = this.integerToByte(1);
            dataBag[0] = 38;
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = (byte)colId;
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    public String setRealTimeLcdDisplayFor4Lines(String first, String second, String third, String fourth, Short channelStatus, Short displayType) {
        String companyNameCustom = ParkWebCommonUtil.convertBase64Char(first);
        String carTime = ParkWebCommonUtil.convertBase64Char(second);
        String carId = ParkWebCommonUtil.convertBase64Char(third);
        String displayContCustom = ParkWebCommonUtil.convertBase64Char(fourth);
        JSONObject data = new JSONObject();
        List<Short> channelStates = Arrays.asList(ParkConstants.CHANNEL_STATE_CART_IN, ParkConstants.CHANNEL_STATE_CAR_IN);
        data.put("car_id", (Object)carId);
        if (channelStates.contains(channelStatus)) {
            data.put("car_in_time", (Object)carTime);
        } else {
            data.put("car_out_time", (Object)carTime);
        }
        JSONArray array = new JSONArray();
        array.add((Object)companyNameCustom);
        array.add((Object)displayContCustom);
        data.put("custom", (Object)array);
        data.put("scene_name", (Object)"YnVzeV9oYWxm");
        if (ParkConstants.LCD_FULLSCREEN.equals(displayType)) {
            data.put("scene_name", (Object)"ZnVsbA==");
        }
        JSONObject body = new JSONObject();
        body.put("body", (Object)data);
        body.put("cmd", (Object)"ad_push_message");
        body.put("id", (Object)UUID.randomUUID().toString());
        return ParkWebCommonUtil.convertBase64Char(body.toString());
    }

    public byte[] sendCloseGate153() {
        byte[] msgBag = null;
        if (this.parkParamsService.isLprCamera()) {
            msgBag = this.basicFormatFor4Lines(4, 153);
            byte[] dataBag = new byte[7];
            byte[] len1 = this.integerToByte(4);
            dataBag[0] = 11;
            dataBag[1] = len1[1];
            dataBag[2] = len1[0];
            dataBag[3] = 1;
            dataBag[4] = 1;
            dataBag[5] = 1;
            dataBag[6] = 1;
            System.arraycopy(dataBag, 0, msgBag, 7, dataBag.length);
            this.generateCRC16(msgBag);
        }
        return msgBag;
    }

    private void generateCRC16(byte[] msgBag) {
        byte[] temdata = new byte[msgBag.length - 3];
        System.arraycopy(msgBag, 1, temdata, 0, temdata.length);
        byte[] crc16R = new byte[2];
        String crcStr = ParkCRC16Util.crcTable(temdata, 0, temdata.length);
        this.hexStringToByte(crcStr, crc16R);
        msgBag[msgBag.length - 2] = crc16R[1];
        msgBag[msgBag.length - 1] = crc16R[0];
    }

    private byte[] integerToByte(int param) {
        byte[] len = new byte[2];
        String contStr = Integer.toHexString(param);
        this.hexStringToByte(contStr, len);
        return len;
    }

    private void hexStringToByte(String strHex, byte[] buf) {
        while (strHex.length() < 4) {
            strHex = "0" + strHex;
        }
        int nLen = strHex.length() / 2;
        for (int i = 0; i < nLen; ++i) {
            buf[i] = Integer.valueOf(strHex.substring(i * 2, i * 2 + 2), 16).byteValue();
        }
    }

    private int hexStringToInt(Object hexString) {
        int result = 0;
        if (Objects.nonNull(hexString)) {
            result = Integer.parseInt(hexString.toString(), 16);
        }
        return result;
    }

    private byte[] transcodingForTBM(String content) {
        byte[] contentByte = null;
        try {
            if (this.parkParamsService.isChineseLanguage()) {
                contentByte = content.getBytes("GBK");
                log.info("Chinese");
            } else {
                String viewCode = this.parkParamsService.getViewCode();
                String lang = ParkViewEnum.getLang((String)viewCode);
                log.info("Overseas" + lang);
                contentByte = "es".equals(lang) ? this.gbEncodingForSpanish(content) : content.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return contentByte;
    }

    private byte[] transcodingForLPR(String content) {
        byte[] contentByte = null;
        try {
            String viewCode;
            String lang;
            contentByte = this.parkParamsService.isChineseLanguage() ? content.getBytes("GBK") : ("th".equals(lang = ParkViewEnum.getLang((String)(viewCode = this.parkParamsService.getViewCode()))) ? this.gbEncodingForThai(content) : ("es".equals(lang) ? this.gbEncodingForSpanish(content) : ("tr".equals(lang) ? this.gbEncodingForTurkey(content) : content.getBytes("UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return contentByte;
    }

    private byte[] gbEncodingForThai(String content) throws UnsupportedEncodingException {
        char[] charAry = content.toCharArray();
        int charLength = 0;
        for (char a : charAry) {
            if (a >= '\u007f') continue;
            ++charLength;
        }
        int length = charLength + (charAry.length - charLength) * 2;
        byte[] dataByte = new byte[length];
        int j = 0;
        for (int i = 0; i < charAry.length; ++i) {
            if (charAry[i] <= '\u007f') {
                dataByte[j] = (byte)charAry[i];
            } else {
                byte[] tempByte = String.valueOf(charAry[i]).getBytes("unicode");
                dataByte[j] = tempByte[2];
                dataByte[j + 1] = tempByte[3];
                ++j;
            }
            ++j;
        }
        return dataByte;
    }

    private byte[] gbEncodingForTurkey(String content) throws UnsupportedEncodingException {
        byte[] byteAry;
        if (content.contains("\u20ba")) {
            content = content.trim();
        }
        int charLength = 0;
        for (byte b : byteAry = content.getBytes("ISO-8859-9")) {
            if (b >= 255) continue;
            ++charLength;
        }
        int length = charLength + (byteAry.length - charLength) * 2;
        byte[] dataByte = new byte[length];
        int j = 0;
        for (int i = 0; i < byteAry.length; ++i) {
            if (byteAry[i] <= 255) {
                dataByte[j] = byteAry[i];
                if (content.contains("\u20ba")) {
                    dataByte[0] = -120;
                }
            } else {
                byte[] tempByte = String.valueOf(byteAry[i]).getBytes("unicode");
                dataByte[j] = tempByte[2];
                dataByte[j + 1] = tempByte[3];
                ++j;
            }
            ++j;
        }
        return dataByte;
    }

    private byte[] gbEncodingForSpanish(String content) throws UnsupportedEncodingException {
        if (content.contains("\ufdfc") || content.contains("\u20ae") || content.contains("\u062c\u0646\u064a\u0647")) {
            content = content.trim();
        }
        char[] charAry = content.toCharArray();
        int charLength = 0;
        for (char a : charAry) {
            if (a >= '\u00ff') continue;
            ++charLength;
        }
        int length = charLength + (charAry.length - charLength) * 2;
        byte[] dataByte = new byte[length];
        int j = 0;
        for (int i = 0; i < charAry.length; ++i) {
            if (charAry[i] <= '\u00ff') {
                dataByte[j] = (byte)charAry[i];
            } else {
                byte[] tempByte = String.valueOf(charAry[i]).getBytes("unicode");
                dataByte[j] = tempByte[2];
                dataByte[j + 1] = tempByte[3];
                ++j;
            }
            ++j;
        }
        if (content.contains("\u062c\u0646\u064a\u0647")) {
            byte[] byteEmpt = new byte[length - 6];
            byteEmpt[0] = -106;
            byteEmpt[1] = 39;
            int t = 2;
            for (int q = 8; q < dataByte.length; ++q) {
                byteEmpt[t] = dataByte[q];
                ++t;
            }
            return byteEmpt;
        }
        return dataByte;
    }
}

