/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKHandler;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import java.util.Arrays;
import java.util.List;
import javax.websocket.ClientEndpoint;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class ParkWebSocketSDKClient {
    private static final Logger log = LoggerFactory.getLogger(ParkWebSocketSDKClient.class);
    private ParkSDKHandler parkSDKHandler = (ParkSDKHandler)SpringUtil.getBean(ParkSDKHandler.class);
    private ParkParamsService parkParamsService = (ParkParamsService)SpringUtil.getBean(ParkParamsService.class);

    @OnOpen
    public void onOpen(Session session) {
        log.info("PARK_SDKClient == ParkWebSocketSDKClient Connect, sessionID =" + session.getId());
    }

    @OnMessage(maxMessageSize=10000000L)
    public void onMessage(String message) {
        JSONObject json = JSONObject.parseObject((String)message);
        String opType = json.getString("OpType");
        List<String> list = Arrays.asList("SerialSend", "Status", "SentData");
        if (!list.contains(opType) && this.parkParamsService.printParkLogger()) {
            log.info("PARK_SDK_OnMessage <<<<< message = " + json);
        }
        this.parkSDKHandler.distributeMsg(json);
    }

    @OnError
    public void onError(Throwable t) {
        log.info("PARK_SDKClient == ParkWebSocketSDKClient Connect Error ", t);
        t.printStackTrace();
    }

    @OnClose
    public void onClose() {
        log.info("PARK_SDKClient == ParkWebSocketSDKClient Connect OnClose");
    }
}

