/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkRecordCallbackTask
implements ParkSDKTasks {
    private static final Logger log = LoggerFactory.getLogger(ParkRecordCallbackTask.class);
    @Autowired
    private ParkDeviceService parkDeviceService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        String dataStr = Base64Util.getFromBase64((String)json.getString("Data"));
        String tableType = json.getString("TableType");
        this.parkDeviceService.startSaveOfflineRecordCallBackThread(dataStr, tableType);
    }

    @Override
    public boolean match(JSONObject json) {
        return "OnRecordCallback".equalsIgnoreCase(json.getString("OpType"));
    }

    @Override
    public long order() {
        return Long.parseLong("30");
    }
}

