/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.park.bean.ParkVehiclePlateInfo;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkPlateInfoTask
implements ParkSDKTasks {
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        JSONObject dataObj = JSONObject.parseObject((String)Base64Util.getFromBase64((String)json.getString("Data")));
        String license = dataObj.getString("License");
        if (StringUtils.isNotBlank((CharSequence)license)) {
            String handle = dataObj.getString("Handle");
            String devIp = this.parkCacheService.getStr("park:dev_handle:" + handle);
            if (StringUtils.isNotBlank((CharSequence)devIp)) {
                String rootPath = ParkWebCommonUtil.getSystemFilePath();
                String picFileName = dataObj.getString("PicFileName");
                String relativePath = picFileName.substring(rootPath.length());
                ParkVehiclePlateInfo vehiclePlate = new ParkVehiclePlateInfo(license);
                vehiclePlate.setPlateColor(dataObj.getString("PlateColor"));
                this.parkDeviceService.routeBusiness(vehiclePlate, devIp, relativePath, null);
            }
        }
    }

    @Override
    public boolean match(JSONObject json) {
        return "OnPlateInfo".equalsIgnoreCase(json.getString("OpType"));
    }

    @Override
    public long order() {
        return Long.parseLong("10");
    }
}

