/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkDefaultTask
implements ParkSDKTasks {
    private static final Logger log = LoggerFactory.getLogger(ParkDefaultTask.class);
    private static final long VALUE_TIME = 600L;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private ParkWebsocketService parkWebsocketService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        String opType;
        String key = "park:ws_msgid:";
        String dataStr = "";
        JSONObject dataObj = new JSONObject();
        JSONObject msgJson = null;
        String msgId = json.getString("MsgId");
        switch (opType = json.getString("OpType")) {
            case "OnDeviceFound": {
                this.receiveDevInfo(json);
                break;
            }
            case "OpenDevice": {
                this.updateDevInfo(json);
                break;
            }
            case "GetDeviceData": 
            case "GetOfflineParam": 
            case "ExportPlateListExt": 
            case "ExportPlateList": {
                msgJson = this.generateJsonObj(json);
                dataStr = json.getString("Data");
                if (StringUtils.isNotBlank((CharSequence)dataStr)) {
                    String fromBase64 = Base64Util.getFromBase64((String)dataStr);
                    dataObj = JSONObject.parseObject((String)fromBase64);
                }
                msgJson.put("Data", (Object)dataObj);
                this.parkCacheService.setJson(key + msgId, msgJson, 600L);
                break;
            }
            case "GetDeviceFunList": {
                msgJson = this.generateJsonObj(json);
                dataStr = json.getString("Data");
                msgJson.put("Data", (Object)dataStr);
                this.parkCacheService.setJson(key + msgId, msgJson, 600L);
                break;
            }
            default: {
                msgJson = this.generateJsonObj(json);
                if (StringUtils.isNotBlank((CharSequence)json.getString("Data"))) {
                    dataObj = json.getJSONObject("Data");
                    msgJson.put("Data", (Object)dataObj);
                } else {
                    msgJson.put("Data", (Object)"");
                }
                this.parkCacheService.setJson(key + msgId, msgJson, 600L);
            }
        }
    }

    private JSONObject generateJsonObj(JSONObject json) {
        JSONObject msgJson = new JSONObject();
        msgJson.put("Ret", (Object)json.getString("Ret"));
        msgJson.put("OpType", (Object)json.getString("OpType"));
        return msgJson;
    }

    private void receiveDevInfo(JSONObject msgObj) {
        log.info("PARK_Device_Sdk == OnDeviceFound msgObj = " + msgObj.toString());
        JSONObject data = msgObj.getJSONObject("Data");
        String ipAddr = data.getString("IP");
        ParkDeviceItem item = this.parkDeviceService.getByIpAddress(ipAddr);
        if (Objects.isNull(item)) {
            String code = data.getString("DeviceType");
            ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
            cheOutInfo.setMsgType("search");
            cheOutInfo.setDevName(data.getString("DeviceName"));
            cheOutInfo.setVendorsType(code);
            String lprDevType = data.getString("LprDevType");
            if (StringUtils.isBlank((CharSequence)lprDevType)) {
                cheOutInfo.setLprDeviceType(Short.valueOf("0"));
            } else {
                cheOutInfo.setLprDeviceType(Short.valueOf(lprDevType));
            }
            cheOutInfo.setMsgInfo(code);
            cheOutInfo.setIpAddress(ipAddr);
            cheOutInfo.setPort(Long.parseLong(data.getString("PortListen")));
            cheOutInfo.setSn("");
            cheOutInfo.setProtype("sdk");
            String comm = this.parkCSPavilioMsg.sendMsgToPavilio("search", cheOutInfo);
            this.channelService.groupPush(comm);
            this.messagingTemplate.convertAndSend((Object)"/topic/parkDevice/message", (Object)comm);
        }
    }

    private void updateDevInfo(JSONObject msgObj) {
        log.info("PARK_DEVICE == OpenDevice Update msgObj = " + msgObj.toString());
        String msgId = msgObj.getString("MsgId");
        String handle = msgObj.getString("Ret");
        String devIp = msgObj.getJSONObject("Data").getString("IpAddr");
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (Objects.nonNull(devObj) && Long.parseLong(handle) != 0L) {
            JSONObject data = msgObj.getJSONObject("Data");
            long serialHand = data.getLong("Serialhandle");
            devObj.put("serialHand", (Object)serialHand);
            devObj.put("handle", (Object)handle);
            devObj.put("state", (Object)"onLine");
            log.info("PARK_DEVICE == OpenDevice Update DevInfo Update Redis = " + devObj.toString());
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            this.parkCacheService.set("park:dev_handle:" + handle, (Object)devIp, 0L);
            this.parkCacheService.set("park:view_defa_content:" + handle, (Object)"0", 0L);
            this.parkCacheService.setJson("park:ws_msgid:" + msgId, msgObj, 600L);
            this.parkDeviceService.startSaveOfflineRecordThread(devIp);
        } else {
            log.info("PARK_DEVICE == OpenDevice [{}] Fail ", (Object)devIp);
        }
    }

    @Override
    public boolean match(JSONObject json) {
        return true;
    }

    @Override
    public long order() {
        return Long.parseLong("40");
    }
}

