/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkCommonNotifyTask
implements ParkSDKTasks {
    private static final Logger log = LoggerFactory.getLogger(ParkCommonNotifyTask.class);
    private static final int VZ_LPRC_ONLINE = 3;
    private static final int VZ_LPRC_OFFLINE = 4;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        JSONObject dataObj = json.getJSONObject("Data");
        if (3 == Integer.parseInt(dataObj.getString("ENotify"))) {
            this.onGateRunStatusFun(dataObj);
        } else if (4 == Integer.parseInt(dataObj.getString("ENotify"))) {
            this.onCommonNotifyFun(dataObj);
        }
    }

    @Override
    public boolean match(JSONObject json) {
        return "OnCommonNotify".equalsIgnoreCase(json.getString("OpType"));
    }

    @Override
    public long order() {
        return Long.parseLong("20");
    }

    private void onCommonNotifyFun(JSONObject msgObj) {
        JSONObject devObj;
        boolean parkLogger = this.parkParamsService.printParkLogger();
        if (parkLogger) {
            log.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback msgObj = " + msgObj.toString());
        }
        long handle = Long.parseLong(msgObj.getString("Handle"));
        String devIp = this.parkCacheService.getStr("park:dev_handle:" + handle);
        if (StringUtils.isNotBlank((CharSequence)devIp) && "enable".equals((devObj = this.parkCacheService.getJson("park:dev_info_" + devIp)).getString("enabled"))) {
            if (parkLogger) {
                log.info("PARK_DEVICE == OnCommonNotifyFun Offline Callback Delete Redis View And Handle devIp = {}", (Object)devIp);
            }
            String keyStr = "park:view_defa_content:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            keyStr = "park:dev_handle:" + handle;
            this.parkCacheService.delExistsKey(keyStr);
            devObj.put("carTeamSignal", (Object)false);
            this.parkCacheService.updateDevOffLine(devObj);
            this.parkCacheService.setJson("park:dev_info_" + devIp, devObj, 0L);
            this.parkWebsocketService.reconnDevice(devIp);
        }
    }

    private void onGateRunStatusFun(JSONObject msgObj) {
        JSONObject devObj;
        boolean parkLogger = this.parkParamsService.printParkLogger();
        if (parkLogger) {
            log.info("PARK_DEVICE == onGateRunStatusFun Online Callback msgObj GateSwitchStatus = " + msgObj.toString());
        }
        long handle = Long.parseLong(msgObj.getString("Handle"));
        String devIp = this.parkCacheService.getStr("park:dev_handle:" + handle);
        if (StringUtils.isNotBlank((CharSequence)devIp) && "enable".equals((devObj = this.parkCacheService.getJson("park:dev_info_" + devIp)).getString("enabled")) && parkLogger) {
            log.info("PARK_DEVICE == onGateRunStatusFun Online Callback GateSwitchStatus = " + msgObj.getString("GateSwitchStatus"));
        }
    }
}

